/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.xtext;

import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.xtext.ITextProcessor;
import com.e1c.langtool.v8.dt.xtext.MultiTextEditParseTreeVisitor;
import com.e1c.langtool.v8.dt.xtext.XtextUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public abstract class AbstractXtextObjectTextEditor
implements ITextProcessor {
    private final EObject root;
    private IDocument document = null;

    public AbstractXtextObjectTextEditor(EObject root) {
        this.root = root;
    }

    @Override
    public IStatus process(IProgressMonitor monitor) {
        ICompositeNode tree = NodeModelUtils.getNode((EObject)this.root);
        if (tree == null || monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.document = new Document(tree.getText());
        MultiTextEdit edit = new MultiTextEdit();
        MultiTextEditParseTreeVisitor treeVisitor = this.createTreeVisitor(edit, this.root, monitor);
        if (treeVisitor == null) {
            return Status.OK_STATUS;
        }
        try {
            XtextUtils.walkParseTree((INode)tree, treeVisitor);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            edit.apply(this.document);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        catch (BadLocationException | MalformedTreeException e) {
            URI uri = EcoreUtil.getURI((EObject)this.root);
            String message = MessageFormat.format("Cannot process text of object: {0}", uri);
            IStatus status = DtPlugin.createErrorStatus(message, e);
            DtPlugin.log(status);
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            treeVisitor.dispose();
            this.dispose();
        }
        return Status.OK_STATUS;
    }

    protected abstract MultiTextEditParseTreeVisitor createTreeVisitor(MultiTextEdit var1, EObject var2, IProgressMonitor var3);

    @Override
    public String getSourceText() {
        ICompositeNode tree = NodeModelUtils.getNode((EObject)this.root);
        if (tree == null) {
            return null;
        }
        return tree.getText();
    }

    @Override
    public String getProcessedText() {
        Assert.isNotNull((Object)this.document, (String)"Cannot call this method before call process()");
        return this.document.get();
    }

    protected void dispose() {
    }
}

