/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.xtext;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.DtPlugin;
import com.e1c.langtool.v8.dt.xtext.ParseTreeVisitor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.nodemodel.ILeafNode;

public abstract class MultiTextEditParseTreeVisitor
implements ParseTreeVisitor {
    protected final MultiTextEdit multiTextEdit;

    public MultiTextEditParseTreeVisitor(MultiTextEdit multiTextEdit) {
        this.multiTextEdit = multiTextEdit;
    }

    protected void addReplace(ILeafNode node, String replace) {
        int offset = node.getOffset();
        int length = node.getLength();
        String text = node.getText();
        if (replace != null && !text.equals(replace)) {
            this.multiTextEdit.addChild((TextEdit)new ReplaceEdit(offset, length, replace));
            if (DtPlugin.TRACE_XTEXT_EDITINGS) {
                System.out.println(text + " = " + replace);
            }
        }
    }

    public void dispose() {
        this.multiTextEdit.removeChildren();
    }

    protected void addReplaceIfNotEmpty(ILeafNode node, String replace) {
        if (StringUtils.isNotEmpty((String)replace)) {
            this.addReplace(node, replace);
        }
    }
}

