/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.microsoft.ui;

import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.microsoft.ITokenProvider;
import com.e1c.langtool.microsoft.MicrosoftServiceConstants;
import com.e1c.langtool.microsoft.ui.Messages;
import com.e1c.langtool.ui.ViewUtils;
import com.e1c.langtool.ui.external.AbstractTranslationPreferencePage;
import com.e1c.langtool.ui.external.ExternalTranslationView;
import com.google.inject.Inject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MicrosoftTranslatorPreferencePage
extends AbstractTranslationPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.e1c.langtool.microsoft.ui.microsoftTranslatorPreferencePage";
    private static final String GETTING_KEY_URL = "https://docs.microsoft.com/en-us/azure/cognitive-services/translator/translator-how-to-signup";
    @Inject
    private ITokenProvider tokenProvider;
    protected Text apiKeyText;
    private Text authApiLocationText;
    private Text categoryIdText;

    @Inject
    public MicrosoftTranslatorPreferencePage(ITranslationCacheManager translationCacheManager) {
        super(translationCacheManager, "com.e1c.langtool.microsoft.microsoftTranslatorProvider");
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.e1c.langtool.microsoft");
        this.setPreferenceStore((IPreferenceStore)prefs);
        this.setDescription(Messages.MicrosoftTranslatorPreferencePage_PreferencePageDescription);
    }

    protected void createAccessKeyGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.MicrosoftTranslatorPreferencePage_Access_group_text);
        new Label((Composite)group, 0).setText(Messages.MicrosoftTranslatorPreferencePage_API_key);
        this.apiKeyText = new Text((Composite)group, 0x400800);
        this.apiKeyText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.apiKeyText.setMessage(Messages.MicrosoftTranslatorPreferencePage_API_key_message);
        new Label((Composite)group, 0).setText(Messages.MicrosoftTranslatorPreferencePage_API_location);
        this.authApiLocationText = new Text((Composite)group, 2048);
        this.authApiLocationText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.authApiLocationText.setMessage(Messages.MicrosoftTranslatorPreferencePage_API_location_message);
        new Label((Composite)group, 0);
        Composite composite = new Composite((Composite)group, 0);
        GridData gridData = new GridData(131072, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, true);
        composite.setLayout((Layout)layout);
        this.createCheckAccessKeyButton(composite);
        this.createGetAccessKeyLink(composite);
        Group group2 = new Group(parent, 0);
        group2.setLayoutData((Object)new GridData(4, 4, true, false));
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setText(Messages.MicrosoftTranslatorPreferencePage_Custom_Translator_group_text);
        new Label((Composite)group2, 0).setText(Messages.MicrosoftTranslatorPreferencePage_Category_ID);
        this.categoryIdText = new Text((Composite)group2, 2048);
        this.categoryIdText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.categoryIdText.setMessage(Messages.MicrosoftTranslatorPreferencePage_Category_ID_message);
        this.categoryIdText.setToolTipText(Messages.MicrosoftTranslatorPreferencePage_Category_ID_tootip);
    }

    protected String getAccessKey() {
        return this.apiKeyText.getText();
    }

    public boolean performOk() {
        boolean isOk = super.performOk();
        try {
            this.tokenProvider.generateToken(this.getAccessKey());
        }
        catch (TranslationServiceException translationServiceException) {
            // empty catch block
        }
        return isOk;
    }

    protected void performDefaults() {
        this.doGetPreferenceStore().setValue("apiKey", MicrosoftServiceConstants.DEFAUTL_APP_KEY);
        this.doGetPreferenceStore().setValue("authApiLocation", MicrosoftServiceConstants.DEFAUTL_AUTH_API_LOCATION);
        this.doGetPreferenceStore().setValue("categoryId", MicrosoftServiceConstants.DEFAUTL_CATEGORY_ID);
        super.performDefaults();
    }

    /*
     * Exception decompiling
     */
    protected boolean checkAccessKey(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void initializeValues() {
        this.apiKeyText.setText(this.getPreferenceStore().getString("apiKey"));
        this.authApiLocationText.setText(this.getPreferenceStore().getString("authApiLocation"));
        this.categoryIdText.setText(this.getPreferenceStore().getString("categoryId"));
    }

    protected void storeValues() {
        String newValue;
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String oldValue = preferenceStore.getString("apiKey");
        if (!oldValue.equals(newValue = this.apiKeyText.getText())) {
            this.isApiKeyValueChanged = true;
            preferenceStore.setValue("apiKey", newValue);
        }
        preferenceStore.setValue("authApiLocation", this.authApiLocationText.getText());
        preferenceStore.setValue("categoryId", this.categoryIdText.getText());
    }

    protected void reloadView() {
        ExternalTranslationView view = (ExternalTranslationView)ViewUtils.getView((String)"com.e1c.langtool.microsoft.ui.microsoftTranslatorView");
        if (view != null && !view.isInitialized()) {
            ViewUtils.reloadView((String)"com.e1c.langtool.microsoft.ui.microsoftTranslatorView");
        }
    }

    protected SelectionListener createLinkSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)MicrosoftTranslatorPreferencePage.GETTING_KEY_URL);
            }
        };
    }
}

