/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.extension.sync;

import com._1c.g5.v8.dt.core.lifecycle.IDtProjectResourceLifecycleBootstrap;
import com._1c.g5.v8.dt.core.operations.ProjectPipelineJob;
import com._1c.g5.v8.dt.core.platform.IConfigurationProject;
import com._1c.g5.v8.dt.core.platform.IConfigurationProjectManager;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IExtensionProject;
import com._1c.g5.v8.dt.core.platform.IExtensionProjectManager;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassFactory;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.v8.dt.extension.ITranslatedExtensionProject;
import com.e1c.langtool.v8.dt.extension.ITranslatingExtensionProject;
import com.e1c.langtool.v8.dt.extension.translator.ExtensionProjectTranslationProvider;
import com.e1c.langtool.v8.dt.internal.extension.ExtPlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatingConfigurationProject;
import com.e1c.langtool.v8.dt.sync.AbstractBmSyncSession;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExtensionSyncSession
extends AbstractBmSyncSession {
    @Inject
    private IConfigurationProjectManager configurationProjectManager;
    @Inject
    private IExtensionProjectManager extensionProjectManager;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    @Inject
    private IDtProjectResourceLifecycleBootstrap bootstrap;
    private final Object lock = new Object();
    private final ITranslatedExtensionProject translatedExtension;
    private IProjectTranslationProvider translationProvider;
    private Object sourceConfigHandle;
    private Object targetSourceConfigHandle;

    public ExtensionSyncSession(ITranslatedProject translatedProject) {
        super(translatedProject);
        Assert.isLegal((boolean)(translatedProject instanceof ITranslatedExtensionProject));
        this.translatedExtension = (ITranslatedExtensionProject)translatedProject;
    }

    public IStatus createProject(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.translatedExtension.getSourceProject().isTranslating()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IProject project = this.translatedExtension.getProject();
        if (project == null || !project.exists()) {
            IProject baseProject = this.translatedExtension.getBaseProject();
            IConfigurationProject configurationProject = this.configurationProjectManager.getProject(baseProject.getName());
            if (configurationProject == null) {
                return Status.CANCEL_STATUS;
            }
            try {
                ITranslatingProject translatingProject = this.translatedExtension.getSourceProject();
                IProject sourceExtensionProject = translatingProject.getProject();
                IExtensionProject extensionV8Project = (IExtensionProject)this.v8ProjectManager.getProject(sourceExtensionProject);
                Configuration configuration = MdClassFactory.eINSTANCE.createConfiguration();
                configuration.setName(this.translatedExtension.getProjectName());
                configuration.setScriptVariant(this.translatedExtension.getScriptVariant());
                if (extensionV8Project.getConfiguration().eIsSet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__COMPATIBILITY_MODE)) {
                    configuration.setCompatibilityMode(extensionV8Project.getConfiguration().getCompatibilityMode());
                }
                configuration.setConfigurationExtensionCompatibilityMode(extensionV8Project.getConfigurationExtensionCompatibilityMode());
                ITranslatingProject sourceProject = this.translatedExtension.getSourceProject();
                Version version = this.runtimeVersionSupport.getRuntimeVersion(sourceProject.getProject());
                project = this.extensionProjectManager.create(this.translatedExtension.getProjectName(), version, configuration, baseProject, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Exception e) {
                return ExtPlugin.createErrorStatus(e.getMessage(), e);
            }
        }
        if (!project.isOpen()) {
            try {
                project.open((IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                return ExtPlugin.createErrorStatus(e.getMessage(), e);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProjectTranslationProvider getTranslationProvider() {
        IProjectTranslationProvider local = this.translationProvider;
        if (local == null) {
            Object object = this.lock;
            synchronized (object) {
                local = this.translationProvider;
                if (local == null) {
                    local = this.translationProvider = ExtensionProjectTranslationProvider.create(this.translatedExtension);
                }
            }
        }
        return this.translationProvider;
    }

    public void beginSyncOperation() {
        super.beginSyncOperation();
        this.beginSourceConfigProjectOperation();
        this.beginTargetSourceConfigProjectOperation();
        this.bootstrap.blockDtProjectRestarts();
    }

    public void endSyncOperation() {
        this.bootstrap.unblockDtProjectRestarts();
        super.endSyncOperation();
        this.endSourceConfigProjectOperation();
        this.endTargetSourceConfigProjectOperation();
    }

    private void beginSourceConfigProjectOperation() {
        ITranslatingExtensionProject project;
        ITranslatingConfigurationProject configProject;
        ITranslatingProject sourceProject = this.translatedExtension.getSourceProject();
        if (sourceProject instanceof ITranslatingExtensionProject && (configProject = (project = (ITranslatingExtensionProject)sourceProject).getTranslatingConfigurationProject()) != null && configProject.getProject() != null && configProject.getProject().isAccessible()) {
            IProject sourceConfigProject = configProject.getProject();
            this.waitUntilStarted(sourceConfigProject, Duration.ofMinutes(5L));
            IDtProject sourceDtProject = this.dtProjectManager.getDtProject(sourceConfigProject);
            this.sourceConfigHandle = this.workspaceOrchestrator.beginBackgroundOperation("synchronize-source-config-Project", (Collection)Lists.newArrayList((Object[])new IDtProject[]{sourceDtProject}), ProjectPipelineJob.BUILD);
        }
    }

    private void endSourceConfigProjectOperation() {
        if (this.sourceConfigHandle == null) {
            return;
        }
        try {
            this.workspaceOrchestrator.endOperation(this.sourceConfigHandle);
        }
        catch (Exception e) {
            ExtPlugin.logError(e);
        }
    }

    private void beginTargetSourceConfigProjectOperation() {
        IProject translatedSourceProject = this.translatedExtension.getBaseProject();
        if (translatedSourceProject != null && translatedSourceProject.isAccessible()) {
            this.waitUntilStarted(translatedSourceProject, Duration.ofMinutes(5L));
            IDtProject sourceDtProject = this.dtProjectManager.getDtProject(translatedSourceProject);
            this.targetSourceConfigHandle = this.workspaceOrchestrator.beginBackgroundOperation("synchronize-target-source-config-Project", (Collection)Lists.newArrayList((Object[])new IDtProject[]{sourceDtProject}), ProjectPipelineJob.BUILD);
        } else {
            String message = MessageFormat.format("Translated base configuration \"{0}\" is not available, but need for extension project translation.", translatedSourceProject);
            IStatus status = ExtPlugin.createWarningStatus(message);
            ExtPlugin.log(status);
        }
    }

    private void endTargetSourceConfigProjectOperation() {
        if (this.targetSourceConfigHandle == null) {
            return;
        }
        try {
            this.workspaceOrchestrator.endOperation(this.targetSourceConfigHandle);
        }
        catch (Exception e) {
            ExtPlugin.logError(e);
        }
    }
}

