/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.extension.translator;

import com._1c.g5.v8.dt.core.platform.IExtensionProject;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.md.extension.adopt.IModelObjectAdopter;
import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.v8.dt.extension.AdoptableFeatureSettings;
import com.e1c.langtool.v8.dt.extension.ITranslatedExtensionProject;
import com.e1c.langtool.v8.dt.extension.ITranslatingExtensionProject;
import com.e1c.langtool.v8.dt.internal.extension.ExtPlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProvider;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;

public class ExtensionProjectTranslationProvider
extends ProjectTranslationProvider {
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private IModelObjectAdopter modelObjectAdopter;
    @Inject
    private AdoptableFeatureSettings adoptableFeatureSettings;
    private IProject baseSourceProject;
    private IProjectTranslationReader baseProjectTranslationReader;
    private IExtensionProject sourceExtensionProject;
    private Map<TranslateLanguage, TranslateLanguage> baseLanguages;

    public static ExtensionProjectTranslationProvider create(ITranslatedV8Project translatedProject) {
        Assert.isLegal((translatedProject != null ? 1 : 0) != 0, (String)"translatedProject should not be null");
        ExtensionProjectTranslationProvider provider = new ExtensionProjectTranslationProvider(translatedProject);
        ExtPlugin.getDefault().getInjector().injectMembers((Object)provider);
        return provider;
    }

    protected ExtensionProjectTranslationProvider(ITranslatedV8Project translatedProject) {
        super(translatedProject);
    }

    public String getTranslation(EObject source, EFeatureSettings featureSettings, TranslateLanguage language) {
        EObject extSource = null;
        try {
            if (source != null && this.adoptableFeatureSettings.isRequreFromSource(source.eClass(), featureSettings)) {
                extSource = this.modelObjectAdopter.getSource(source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (extSource != null) {
            TranslateLanguage baseLanguage = this.getBaseLanguage(language);
            if (extSource != null && baseLanguage != null) {
                return super.getTranslation(extSource, featureSettings, baseLanguage);
            }
        }
        return super.getTranslation(source, featureSettings, language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranslateLanguage getBaseLanguage(TranslateLanguage source) {
        if (this.baseLanguages == null) {
            ExtensionProjectTranslationProvider extensionProjectTranslationProvider = this;
            synchronized (extensionProjectTranslationProvider) {
                if (this.baseLanguages != null) {
                    return this.baseLanguages.get(source);
                }
                List sourceLanguages = this.geExtensionProject().getSourceProject().getInterfaceLanguages();
                this.baseLanguages = this.geExtensionProject().getInterfaceLanguages().stream().collect(Collectors.toMap(l -> l, l -> sourceLanguages.stream().filter(s -> s.getLanguageCode().equals(l.getLanguageCode())).findAny().orElse(null), (existing, replacement) -> existing));
            }
        }
        return this.baseLanguages.get(source);
    }

    protected String getStoredTranslationInternal(ContextTranslationKey key, TranslateLanguage language, ITranslationStorageProvider.Storage.Type ... storageTypes) {
        TranslateLanguage baseLanguage;
        if (StringUtils.isNullOrEmpty((String)key.getValue())) {
            return "";
        }
        if (key.getSourceProject().equals((Object)this.getBaseSourceProject())) {
            if (this.ignoreService.ignoreTranslation(this.getBaseSourceProject(), key, (IProgressMonitor)new NullProgressMonitor())) {
                return key.getValue();
            }
            TranslateLanguage baseLanguage2 = this.getBaseLanguage(language);
            if (baseLanguage2 != null) {
                return this.getBaseReader().getStoredTranslation((TranslationKey)key, baseLanguage2, storageTypes);
            }
        }
        if (this.ignoreService.ignoreTranslation(this.getSourceProject(), key, (IProgressMonitor)new NullProgressMonitor())) {
            return key.getValue();
        }
        String translation = super.getStoredTranslationInternal(key, language, storageTypes);
        if (StringUtils.isNullOrEmpty((String)translation) && (baseLanguage = this.getBaseLanguage(language)) != null) {
            translation = this.getBaseReader().getStoredTranslation((TranslationKey)key, baseLanguage, storageTypes);
        }
        return translation;
    }

    protected IExtensionProject getSourceExtensionProject() {
        if (this.sourceExtensionProject == null) {
            this.sourceExtensionProject = (IExtensionProject)this.v8ProjectManager.getProject(this.getSourceProject());
        }
        return this.sourceExtensionProject;
    }

    protected ITranslatedExtensionProject geExtensionProject() {
        return (ITranslatedExtensionProject)this.getProject();
    }

    protected IProject getBaseSourceProject() {
        if (this.baseSourceProject == null) {
            Assert.isNotNull((Object)this.getProject());
            ITranslatingProject source = this.getProject().getSourceProject();
            Assert.isNotNull((Object)source);
            Assert.isLegal((boolean)(source instanceof ITranslatingExtensionProject));
            this.baseSourceProject = ((ITranslatingExtensionProject)source).getTranslatingConfigurationProject().getProject();
        }
        return this.baseSourceProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IProjectTranslationReader getBaseReader() {
        if (this.baseProjectTranslationReader == null) {
            ExtensionProjectTranslationProvider extensionProjectTranslationProvider = this;
            synchronized (extensionProjectTranslationProvider) {
                if (this.baseProjectTranslationReader != null) {
                    return this.baseProjectTranslationReader;
                }
                this.baseProjectTranslationReader = this.storageManager.getTranslationReader(this.getBaseSourceProject());
            }
        }
        return this.baseProjectTranslationReader;
    }
}

