/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.extension;

import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.extension.ITranslatedExtensionProject;
import com.e1c.langtool.v8.dt.extension.ITranslatingExtensionProject;
import com.e1c.langtool.v8.dt.platform.AbstractTranslateV8Project;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedExtensionProject;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class TranslatedExtensionProject
extends AbstractTranslateV8Project
implements ITranslatedExtensionProject {
    @Inject
    private IConfigurationProvider configurationProvider;
    private final V8TranslatedExtensionProject translatedProject;
    private final ITranslatingExtensionProject sourceProject;
    private volatile List<TranslateLanguage> interfaceLanguages;
    private volatile List<Language> languages;

    public TranslatedExtensionProject(IProject project, V8TranslatedExtensionProject translatedProject, ITranslatingExtensionProject sourceProject) {
        super(project);
        this.translatedProject = translatedProject;
        this.sourceProject = sourceProject;
    }

    public boolean isTranslated() {
        return true;
    }

    public TranslateLanguage getDefaultLanguage() {
        if (!this.isChangeDefaultLanguage()) {
            return this.getSourceProject().getDefaultLanguage();
        }
        String langName = this.translatedProject.getDefaultLanguageName();
        if (langName != null) {
            Optional defaultLang = this.convertNamesToLanguages((List<String>)ImmutableList.of((Object)langName), false).stream().findFirst();
            if (defaultLang.isPresent()) {
                return (TranslateLanguage)defaultLang.get();
            }
            throw new RuntimeException(MessageFormat.format("Default language \"{0}\" for translation project not found", langName));
        }
        return this.getSourceProject().getDefaultLanguage();
    }

    public ITranslatingProject getSourceProject() {
        return this.sourceProject;
    }

    public List<TranslateLanguage> getInterfaceLanguages() {
        if (this.interfaceLanguages == null) {
            TreeSet languageNames = new TreeSet();
            languageNames.addAll(this.translatedProject.getInterfaceLanguageNames());
            ArrayList<String> interfaceLanguageNames = new ArrayList<String>();
            interfaceLanguageNames.addAll(languageNames);
            List<TranslateLanguage> languageList = this.convertNamesToLanguages(interfaceLanguageNames, true);
            if (this.isChangeDefaultLanguage()) {
                languageList.add(this.getDefaultLanguage());
            }
            this.interfaceLanguages = ImmutableList.copyOf(languageList);
        }
        return this.interfaceLanguages;
    }

    public String getProjectName() {
        return this.translatedProject.getName();
    }

    public ScriptVariant getScriptVariant() {
        if (this.translatedProject.isSetScriptVariant()) {
            return this.translatedProject.getScriptVariant();
        }
        return this.sourceProject.getScriptVariant();
    }

    public boolean isChangeScriptVariant() {
        return this.translatedProject.isSetScriptVariant() && !this.translatedProject.getScriptVariant().equals((Object)this.sourceProject.getV8Project().getScriptVariant());
    }

    public boolean isChangeDefaultLanguage() {
        return this.translatedProject.getDefaultLanguageName() != null && !this.translatedProject.getDefaultLanguageName().equalsIgnoreCase(this.getSourceProject().getDefaultLanguage().getName());
    }

    @Override
    public IProject getBaseProject() {
        if (this.translatedProject.getBaseProject() != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(this.translatedProject.getBaseProject());
        }
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurationProvider.getConfiguration(this.getProject());
    }

    public List<Language> getLanguages() {
        if (this.languages == null) {
            ArrayList<String> interfaceLanguageNames = new ArrayList<String>((Collection<String>)this.translatedProject.getInterfaceLanguageNames());
            if (!interfaceLanguageNames.contains(this.getDefaultLanguage().getName())) {
                interfaceLanguageNames.add(this.getDefaultLanguage().getName());
            }
            HashSet<Language> languageList = new HashSet<Language>();
            if (!interfaceLanguageNames.isEmpty()) {
                for (Language l2 : this.sourceProject.getV8Project().getLanguages()) {
                    if (!interfaceLanguageNames.contains(l2.getName())) continue;
                    languageList.add(l2);
                    interfaceLanguageNames.remove(l2.getName());
                }
            }
            List<TranslateLanguage> rest = this.convertNamesToLanguages(interfaceLanguageNames, true);
            rest.forEach(l -> {
                if (l instanceof Language && interfaceLanguageNames.contains(l.getName())) {
                    languageList.add((Language)l);
                    interfaceLanguageNames.remove(l.getName());
                }
            });
            this.languages = ImmutableList.copyOf(languageList);
        }
        return this.languages;
    }

    private List<TranslateLanguage> convertNamesToLanguages(List<String> languageNames, boolean interfaceOnly) {
        ITranslatingProject project = this.getSourceProject();
        HashSet parentLangs = new HashSet(project.getInterfaceLanguages());
        if (!interfaceOnly) {
            parentLangs.addAll(project.getModelLanguages());
        }
        Function<String, Optional> findLanguageByName = langName -> parentLangs.stream().filter(lang -> lang.getName().equals(langName)).findFirst();
        return languageNames.stream().map(findLanguageByName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

