/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.extension;

import com._1c.g5.modeling.xml.AbstractXmlResource;
import com._1c.g5.v8.dt.core.platform.IConfigurationProvider;
import com._1c.g5.v8.dt.core.platform.IDtProject;
import com._1c.g5.v8.dt.core.platform.IDtProjectManager;
import com._1c.g5.v8.dt.core.platform.IExtensionProject;
import com._1c.g5.v8.dt.core.platform.IV8Project;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.core.platform.IWorkspaceOrchestrator;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.Language;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassPackage;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.sync.SynchronizableProject;
import com.e1c.langtool.v8.dt.extension.ITranslatingExtensionProject;
import com.e1c.langtool.v8.dt.internal.extension.ExtPlugin;
import com.e1c.langtool.v8.dt.internal.extension.TranslatedExtensionProject;
import com.e1c.langtool.v8.dt.lang.model.TranslateLanguageFactory;
import com.e1c.langtool.v8.dt.lang.model.V8TranslateLanguage;
import com.e1c.langtool.v8.dt.lang.model.util.LanguageUtil;
import com.e1c.langtool.v8.dt.platform.AbstractTranslateV8Project;
import com.e1c.langtool.v8.dt.platform.ITranslatingConfigurationProject;
import com.e1c.langtool.v8.dt.projectsettings.DependentManifestUtils;
import com.e1c.langtool.v8.dt.projectsettings.ManifestException;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageConstants;
import com.e1c.langtool.v8.dt.projectsettings.TranslateLanguageManifest;
import com.e1c.langtool.v8.dt.projectsettings.TranslatedProjectManifest;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedExtensionProject;
import com.e1c.langtool.v8.dt.settings.model.V8TranslatedProject;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TranslatingExtensionProject
extends AbstractTranslateV8Project
implements ITranslatingExtensionProject,
SynchronizableProject {
    @Inject
    private IConfigurationProvider configurationProvider;
    @Inject
    private Provider<ResourceSetImpl> resourceSetProvider;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    @Inject
    private ITranslatingProjectManager translatingProjectManager;
    @Inject
    private IWorkspaceOrchestrator orchestrator;
    @Inject
    private IDtProjectManager dtProjectManager;
    private IResourceChangeListener projectManifestChangeListener = new ProjectManifestChangeListener();
    private final ManifestContent manifest = new ManifestContent();

    public TranslatingExtensionProject(IProject project) {
        super(project);
    }

    public List<TranslateLanguage> getModelLanguages() {
        return this.manifest.getModelLanguages();
    }

    public List<TranslateLanguage> getInterfaceLanguages() {
        return this.manifest.getAllLanguages();
    }

    public List<ITranslatedProject> getTranslatedProjects() {
        return this.manifest.getTranslatedProjects();
    }

    public TranslateLanguage getDefaultLanguage() {
        return this.manifest.getDefaultLanguage();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurationProvider.getConfiguration(this.getProject());
    }

    public boolean isTranslating() {
        return !this.getInterfaceLanguages().isEmpty();
    }

    @Override
    public ITranslatingConfigurationProject getTranslatingConfigurationProject() {
        IProject baseProject;
        IV8Project v8project = this.v8ProjectManager.getProject(this.getProject());
        if (v8project instanceof IExtensionProject && (baseProject = ((IExtensionProject)v8project).getParentProject()) != null && this.translatingProjectManager.getProject(baseProject) instanceof ITranslatingConfigurationProject) {
            return (ITranslatingConfigurationProject)this.translatingProjectManager.getProject(baseProject);
        }
        return null;
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.projectManifestChangeListener);
        this.manifest.reset();
        super.dispose();
    }

    private Language loadFromConfiguration() {
        URI uri;
        Resource resource;
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        IFile file = this.getProject().getFile("src/Configuration/Configuration.mdo");
        if (file.exists() && !(resource = resourceSet.getResource(uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true)).getContents().isEmpty()) {
            EObject obj;
            Object language;
            if (resource instanceof AbstractXmlResource) {
                ((AbstractXmlResource)resource).setLinker(null);
            }
            if ((language = (obj = (EObject)resource.getContents().get(0)).eGet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__DEFAULT_LANGUAGE, true)) instanceof Language) {
                if (((Language)language).eIsProxy()) {
                    String fragment = EcoreUtil.getURI((EObject)((Language)language)).fragment();
                    String defaultLanguageName = this.extractLanguageNameFromUriFragment(fragment);
                    EList languages = (EList)obj.eGet((EStructuralFeature)MdClassPackage.Literals.CONFIGURATION__LANGUAGES, true);
                    for (Language lang : languages) {
                        if (!lang.getName().equals(defaultLanguageName)) continue;
                        return lang;
                    }
                } else {
                    return (Language)language;
                }
            }
        }
        return null;
    }

    private TranslateLanguage getDefaultLanguageFromSettings(Language defaultLanguage) {
        if (defaultLanguage instanceof TranslateLanguage) {
            return (TranslateLanguage)defaultLanguage;
        }
        if (defaultLanguage == null) {
            return null;
        }
        for (TranslateLanguage language : this.getInterfaceLanguages()) {
            if (!defaultLanguage.getUuid().equals(language.getUuid()) || !defaultLanguage.getLanguageCode().equals(language.getLanguageCode())) continue;
            return language;
        }
        return null;
    }

    private String extractLanguageNameFromUriFragment(String fragment) {
        String preffix = "::Language.";
        int index = fragment.indexOf("::Language.");
        if (index > -1 && fragment.length() > index + "::Language.".length()) {
            return fragment.substring(index + "::Language.".length());
        }
        return null;
    }

    private boolean checkProjectAsDependent(IProject project) {
        if (DependentManifestUtils.checkManifest((IProject)project)) {
            try {
                IProject sourceProject = DependentManifestUtils.readManifest((IProject)project, (IProgressMonitor)new NullProgressMonitor());
                if (sourceProject.getName().equals(this.getProject().getName())) {
                    return true;
                }
            }
            catch (ManifestException e) {
                ExtPlugin.logError(e);
            }
        }
        return false;
    }

    private Collection<V8TranslateLanguage> readLanguagesFromExternalProject(IProject project) {
        try {
            return TranslateLanguageManifest.loadAllIfAccessible((IProject)project);
        }
        catch (ManifestException e) {
            ExtPlugin.logError(e);
            return Collections.emptyList();
        }
    }

    private class ManifestContent {
        private volatile List<TranslateLanguage> modelLanguages;
        private volatile List<TranslateLanguage> allLanguages;
        private volatile List<V8TranslatedExtensionProject> v8TranslatedProjects;
        private volatile List<ITranslatedProject> translatedProjects;
        private volatile TranslateLanguage defaultLanguage;
        private List<V8TranslateLanguage> loadedLanguages;
        private List<V8TranslatedProject> loadedProjects;
        private final Object manifestDataLock = new Object();

        private ManifestContent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<TranslateLanguage> getModelLanguages() {
            if (this.modelLanguages == null) {
                ArrayList<TranslateLanguage> languageList = new ArrayList<TranslateLanguage>();
                for (TranslateLanguage language : this.getAllLanguages()) {
                    if (!language.getOption().equals((Object)TranslationOption.MODEL_AND_INTERFACE)) continue;
                    languageList.add(language);
                }
                Object object = this.manifestDataLock;
                synchronized (object) {
                    this.modelLanguages = ImmutableList.copyOf(languageList);
                }
            }
            return this.modelLanguages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<TranslateLanguage> getAllLanguages() {
            if (this.allLanguages == null) {
                Object object = this.manifestDataLock;
                synchronized (object) {
                    this.readProjectManifestFile();
                }
            }
            return this.allLanguages == null ? new ArrayList() : this.allLanguages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ITranslatedProject> getTranslatedProjects() {
            if (this.translatedProjects == null) {
                Object object = this.manifestDataLock;
                synchronized (object) {
                    if (this.v8TranslatedProjects == null) {
                        this.readProjectManifestFile();
                    }
                    if (this.v8TranslatedProjects != null) {
                        this.translatedProjects = this.v8TranslatedProjects.stream().map(settingsProject -> {
                            IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject(settingsProject.getName());
                            TranslatedExtensionProject project = new TranslatedExtensionProject(oldProject, (V8TranslatedExtensionProject)settingsProject, TranslatingExtensionProject.this);
                            ExtPlugin.getDefault().getInjector().injectMembers((Object)project);
                            return project;
                        }).collect(Collectors.toList());
                    }
                }
            }
            return this.translatedProjects == null ? new ArrayList() : this.translatedProjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TranslateLanguage getDefaultLanguage() {
            if (this.defaultLanguage == null) {
                Language language = TranslatingExtensionProject.this.getConfiguration() == null ? TranslatingExtensionProject.this.loadFromConfiguration() : TranslatingExtensionProject.this.getConfiguration().getDefaultLanguage();
                Object object = this.manifestDataLock;
                synchronized (object) {
                    this.defaultLanguage = TranslatingExtensionProject.this.getDefaultLanguageFromSettings(language);
                    if (this.defaultLanguage == null && language != null) {
                        V8TranslateLanguage v8Lang = TranslateLanguageFactory.eINSTANCE.createV8TranslateLanguage();
                        v8Lang.setOption(TranslationOption.MODEL_AND_INTERFACE);
                        LanguageUtil.copyLanguageContent((Language)language, (V8TranslateLanguage)v8Lang);
                        this.defaultLanguage = v8Lang;
                    }
                }
            }
            return this.defaultLanguage;
        }

        private boolean isAllLanguagesInited() {
            return this.allLanguages != null;
        }

        private boolean isV8translatedProjectsInited() {
            return this.v8TranslatedProjects != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            Object object = this.manifestDataLock;
            synchronized (object) {
                this.modelLanguages = null;
                this.defaultLanguage = null;
                this.translatedProjects = null;
                this.allLanguages = null;
                this.v8TranslatedProjects = null;
            }
        }

        private void readProjectManifestFile() {
            IDtProject dtProject = TranslatingExtensionProject.this.dtProjectManager.getDtProject(TranslatingExtensionProject.this.getProject());
            if (dtProject == null) {
                return;
            }
            ManifestReadingLanguages languagesTask = new ManifestReadingLanguages();
            ManifestReadingProjects projectsTask = new ManifestReadingProjects();
            try {
                Future languagesFuture = ForkJoinPool.commonPool().submit((Callable)languagesTask);
                Future projectsFuture = ForkJoinPool.commonPool().submit((Callable)projectsTask);
                this.loadedLanguages = (List)((ForkJoinTask)languagesFuture).get();
                this.loadedProjects = (List)((ForkJoinTask)projectsFuture).get();
            }
            catch (Throwable e) {
                ExtPlugin.logError(e);
            }
            if (this.loadedLanguages == null || this.loadedProjects == null) {
                return;
            }
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && !project.getName().equals(TranslatingExtensionProject.this.getProject().getName()) && TranslatingExtensionProject.this.checkProjectAsDependent(project)) {
                    this.loadedLanguages.addAll(TranslatingExtensionProject.this.readLanguagesFromExternalProject(project));
                }
                ++n2;
            }
            Collections.sort(this.loadedLanguages, (l1, l2) -> l1.getName().compareTo(l2.getName()));
            Collections.sort(this.loadedProjects, (p1, p2) -> p1.getName().compareTo(p2.getName()));
            this.modelLanguages = null;
            this.defaultLanguage = null;
            this.translatedProjects = null;
            this.allLanguages = ImmutableList.copyOf(this.loadedLanguages);
            this.v8TranslatedProjects = ImmutableList.copyOf((Collection)this.loadedProjects.stream().filter(V8TranslatedExtensionProject.class::isInstance).map(V8TranslatedExtensionProject.class::cast).collect(Collectors.toList()));
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener(TranslatingExtensionProject.this.projectManifestChangeListener);
        }

        private class ManifestReadingLanguages
        implements Callable<List<V8TranslateLanguage>> {
            private ManifestReadingLanguages() {
            }

            @Override
            public List<V8TranslateLanguage> call() throws Exception {
                try {
                    List languages = TranslateLanguageManifest.loadAllIfAccessible((IProject)TranslatingExtensionProject.this.getProject());
                    return languages;
                }
                catch (Exception e) {
                    ExtPlugin.logError(e);
                    return null;
                }
            }
        }

        private class ManifestReadingProjects
        implements Callable<List<V8TranslatedProject>> {
            private ManifestReadingProjects() {
            }

            @Override
            public List<V8TranslatedProject> call() throws Exception {
                try {
                    List projects = TranslatedProjectManifest.loadAllIfAccessible((IProject)TranslatingExtensionProject.this.getProject());
                    return projects;
                }
                catch (Exception e) {
                    ExtPlugin.logError(e);
                    return null;
                }
            }
        }
    }

    private class ProjectManifestChangeListener
    implements IResourceChangeListener {
        private ProjectManifestChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!TranslatingExtensionProject.this.manifest.isAllLanguagesInited() && !TranslatingExtensionProject.this.manifest.isV8translatedProjectsInited() || event == null) {
                return;
            }
            if (event.getType() != 1) {
                return;
            }
            if (event.getDelta() == null) {
                return;
            }
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                if (delta.getResource() instanceof IProject && TranslatingExtensionProject.this.getProject().equals((Object)delta.getResource())) {
                    IResourceDelta resourceDelta = delta.findMember(TranslateLanguageConstants.FOLDER_PATH_SRC_LANGUAGES);
                    if (resourceDelta != null) {
                        TranslatingExtensionProject.this.manifest.reset();
                        return;
                    }
                    resourceDelta = delta.findMember((IPath)new Path("DT-INF"));
                    if (resourceDelta != null) {
                        TranslatingExtensionProject.this.manifest.reset();
                        return;
                    }
                }
                ++n2;
            }
        }
    }
}

