/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.sync;

import com._1c.g5.v8.dt.core.platform.IConfigurationProject;
import com._1c.g5.v8.dt.core.platform.IConfigurationProjectManager;
import com._1c.g5.v8.dt.core.platform.IV8ProjectManager;
import com._1c.g5.v8.dt.metadata.mdclass.Configuration;
import com._1c.g5.v8.dt.metadata.mdclass.MdClassFactory;
import com._1c.g5.v8.dt.platform.version.IRuntimeVersionSupport;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.platform.ITranslatedConfigurationProject;
import com.e1c.langtool.v8.dt.platform.ITranslatedV8Project;
import com.e1c.langtool.v8.dt.sync.AbstractBmSyncSession;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ProjectTranslationProvider;
import com.google.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ConfigurationSyncSession
extends AbstractBmSyncSession {
    @Inject
    private IConfigurationProjectManager configurationProjectManager;
    @Inject
    private IRuntimeVersionSupport runtimeVersionSupport;
    @Inject
    private IV8ProjectManager v8ProjectManager;
    private final ITranslatedConfigurationProject translatedConfiguration;
    private final Object lock = new Object();
    private volatile IProjectTranslationProvider translationProvider;

    public ConfigurationSyncSession(ITranslatedProject translatedProject) {
        super(translatedProject);
        Assert.isLegal((boolean)(translatedProject instanceof ITranslatedConfigurationProject));
        this.translatedConfiguration = (ITranslatedConfigurationProject)translatedProject;
    }

    public IStatus createProject(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.translatedConfiguration.getSourceProject().isTranslating()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IProject project = this.translatedConfiguration.getProject();
        if (project == null || !project.exists()) {
            try {
                ITranslatingProject translatingProject = this.translatedConfiguration.getSourceProject();
                IProject sourceExtensionProject = translatingProject.getProject();
                IConfigurationProject configurationV8Project = (IConfigurationProject)this.v8ProjectManager.getProject(sourceExtensionProject);
                Configuration configuration = MdClassFactory.eINSTANCE.createConfiguration();
                configuration.setName(this.translatedConfiguration.getProjectName());
                configuration.setScriptVariant(this.translatedConfiguration.getScriptVariant());
                configuration.setCompatibilityMode(configurationV8Project.getCompatibilityMode());
                ITranslatingProject sourceProject = this.translatedConfiguration.getSourceProject();
                Version version = this.runtimeVersionSupport.getRuntimeVersion(sourceProject.getProject());
                project = this.configurationProjectManager.create(this.translatedConfiguration.getProjectName(), version, configuration, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Exception e) {
                return SyncPlugin.createErrorStatus(e.getMessage(), e);
            }
        }
        if (!project.isOpen()) {
            try {
                project.open((IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                return SyncPlugin.createErrorStatus(e.getMessage(), e);
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProjectTranslationProvider getTranslationProvider() {
        IProjectTranslationProvider local = this.translationProvider;
        if (local == null) {
            Object object = this.lock;
            synchronized (object) {
                local = this.translationProvider;
                if (local == null) {
                    local = this.translationProvider = ProjectTranslationProvider.create((ITranslatedV8Project)this.translatedConfiguration);
                }
            }
        }
        return local;
    }
}

