/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.internal.sync.naming;

import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.core.platform.IResourceLookup;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com._1c.g5.v8.dt.metadata.IExternalPropertyManager;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectCache;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGenerator;
import com.e1c.langtool.v8.dt.sync.naming.TranslatedTopObjectFqnGeneratorDelegate;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

public final class DelegatingTranslatedTopObjectFqnGenerator
implements TranslatedTopObjectFqnGenerator {
    private static final String DELEGATE_CLASS_ATTRIBUTE = "class";
    private static final String TOP_OBJECT_FQN_GENERATOR_DELEGATES_EXTENSION_POINT_ID = "com.e1c.langtool.v8.dt.sync.translatedTopObjectFqnGenerator";
    @Inject
    private IResourceLookup resourceLookup;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IBmModelManager modelManager;
    @Inject
    private IExternalPropertyManagerRegistry externalPropertyManagerRegistry;
    private Object delegatesLock = new Object();
    private Map<EPackage, TranslatedTopObjectFqnGeneratorDelegate> delegatesMap;

    @Override
    public String generateFqn(EObject source, IProjectTranslationProvider translationProvider) {
        Provider provider = () -> {
            TranslatedTopObjectFqnGeneratorDelegate delegate = this.getDelegate(source.eClass().getEPackage());
            if (delegate != null) {
                return delegate.generateFqn(source, translationProvider);
            }
            IProject project = this.resourceLookup.getProject(source);
            if (project == null) {
                return null;
            }
            IBmModel model = this.modelManager.getModel(project);
            if (model == null) {
                return null;
            }
            IExternalPropertyManager manager = this.externalPropertyManagerRegistry.getExternalPropertyManager(model);
            EReference ownerFeature = manager.getReference(source);
            EObject owner = manager.getOwner(source, EObject.class);
            if (owner != null && ownerFeature != null) {
                String ownerFqn;
                delegate = this.getDelegate(owner.eClass().getEPackage());
                String string = ownerFqn = delegate == null ? null : delegate.generateFqn(owner, translationProvider);
                if (ownerFqn != null) {
                    QualifiedName fqn = this.qualifiedNameConverter.toQualifiedName(ownerFqn);
                    fqn = fqn.append(StringUtils.capitalize((String)ownerFeature.getName()));
                    return this.qualifiedNameConverter.toString(fqn);
                }
            }
            return null;
        };
        TranslatedTopObjectCache cache = (TranslatedTopObjectCache)translationProvider.getCache(TranslatedTopObjectCache.class);
        return cache.getTranslation(EcoreUtil.getURI((EObject)source), provider);
    }

    private TranslatedTopObjectFqnGeneratorDelegate getDelegate(EPackage ePackage) {
        return this.getDelegatesMap().get(ePackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<EPackage, TranslatedTopObjectFqnGeneratorDelegate> getDelegatesMap() {
        Object object = this.delegatesLock;
        synchronized (object) {
            if (this.delegatesMap == null) {
                this.loadDelegates();
            }
            return this.delegatesMap;
        }
    }

    private void loadDelegate(IConfigurationElement configElement) {
        try {
            TranslatedTopObjectFqnGeneratorDelegate e = (TranslatedTopObjectFqnGeneratorDelegate)configElement.createExecutableExtension(DELEGATE_CLASS_ATTRIBUTE);
            for (EPackage ePackage : e.getSupportedPackages()) {
                this.delegatesMap.put(ePackage, e);
            }
        }
        catch (CoreException err) {
            SyncPlugin.logError(err);
        }
    }

    private void loadDelegates() {
        this.delegatesMap = Maps.newHashMap();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(TOP_OBJECT_FQN_GENERATOR_DELEGATES_EXTENSION_POINT_ID);
        int i = 0;
        while (i < config.length) {
            IConfigurationElement configElement = config[i];
            this.loadDelegate(configElement);
            ++i;
        }
    }
}

