/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync;

import com._1c.g5.v8.bm.core.IBmNamespace;
import com._1c.g5.v8.dt.core.naming.ISymbolicNameService;
import com._1c.g5.v8.dt.core.platform.V8ParametersStringParser;
import com._1c.g5.v8.dt.mcore.Event;
import com._1c.g5.v8.dt.metadata.mdclass.ScriptVariant;
import com._1c.g5.v8.dt.platform.version.Version;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.emf.settings.EFeatureSettings;
import com.e1c.langtool.emf.settings.IFeatureSettingsService;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.v8.dt.format.FormatInternalizeTokenProvider;
import com.e1c.langtool.v8.dt.format.FormatUtils;
import com.e1c.langtool.v8.dt.settings.DtFeatureSettings;
import com.e1c.langtool.v8.dt.sync.ITranslatedSymbolicNameService;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.e1c.langtool.v8.dt.translator.ModelNameTranslationCache;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractEObjectCopier
extends EcoreUtil.Copier {
    @Inject
    protected transient ISymbolicNameService symbolicNameService;
    @Inject
    protected transient ITranslatedSymbolicNameService translatedSymbolicNameService;
    @Inject
    protected transient IFeatureSettingsService featureSettingsService;
    @Inject
    private transient FormatInternalizeTokenProvider formatTokenProvider;
    protected transient Map<Pair<EObject, String>, String> cache = new ConcurrentHashMap<Pair<EObject, String>, String>(1000);
    protected final ModelNameTranslationCache nameCache;
    protected final String modelCacheSuffix;
    protected final transient IProjectTranslationProvider translationProvider;
    protected final transient Version runtimeVersion;
    protected final transient IBmNamespace targetNamespace;
    private List<String> languageCodes;

    public AbstractEObjectCopier(IProjectTranslationProvider translationProvider, IBmNamespace targetNamespace, Version runtimeVersion) {
        super(false, false);
        this.translationProvider = translationProvider;
        this.targetNamespace = targetNamespace;
        this.runtimeVersion = runtimeVersion;
        this.modelCacheSuffix = "model_trans_" + translationProvider.getProject().getDefaultLanguage().getLanguageCode();
        this.nameCache = (ModelNameTranslationCache)translationProvider.getCache(ModelNameTranslationCache.class);
    }

    protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
        if (eObject.eIsSet((EStructuralFeature)eAttribute) && (this.translationProvider.getProject().isChangeDefaultLanguage() || this.translationProvider.getProject().isChangeScriptVariant()) && this.featureSettingsService.isModelFeature((EStructuralFeature)eAttribute, eObject)) {
            Pair key = new Pair((Object)eObject, (Object)(this.modelCacheSuffix + eAttribute.getName()));
            EFeatureSettings fs = this.featureSettingsService.getSettings((EStructuralFeature)eAttribute, eObject);
            Provider provider = () -> {
                TranslateLanguage language = this.translationProvider.getProject().getDefaultLanguage();
                Optional trans = this.translationProvider.getOptionalTranslation(eObject, fs, language);
                return trans.orElse((String)eObject.eGet((EStructuralFeature)eAttribute));
            };
            String translation = null;
            translation = fs.isId() ? this.nameCache.getTranslation(EcoreUtil.getURI((EObject)eObject), provider) : this.computeIfAbsent((Pair<EObject, String>)key, (Provider<String>)provider);
            copyEObject.eSet((EStructuralFeature)eAttribute, (Object)translation);
        } else if (eAttribute.isUnsettable() && !eObject.eIsSet((EStructuralFeature)eAttribute)) {
            copyEObject.eUnset((EStructuralFeature)eAttribute);
        } else if (!eAttribute.isUnsettable() && !eObject.eIsSet((EStructuralFeature)eAttribute)) {
            if (eAttribute.isMany()) {
                Object oldValue = copyEObject.eGet((EStructuralFeature)eAttribute);
                if (oldValue instanceof Collection) {
                    Collection collection = (Collection)oldValue;
                    collection.clear();
                }
            } else {
                copyEObject.eSet((EStructuralFeature)eAttribute, eAttribute.getDefaultValue());
            }
        } else {
            super.copyAttribute(eAttribute, eObject, copyEObject);
        }
    }

    protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
        if (!eReference.isTransient()) {
            super.copyContainment(eReference, eObject, copyEObject);
            if (eReference.isMany()) {
                List source = (List)eObject.eGet((EStructuralFeature)eReference);
                List target = (List)copyEObject.eGet((EStructuralFeature)eReference);
                if (source.isEmpty()) {
                    target.clear();
                }
            }
            if (this.featureSettingsService.isInterfaceFeature((EStructuralFeature)eReference, eObject)) {
                EFeatureSettings featureSettings = this.featureSettingsService.getSettings((EStructuralFeature)eReference, eObject);
                if (featureSettings.isInterface()) {
                    EMap featureValue = (EMap)copyEObject.eGet((EStructuralFeature)eReference);
                    Iterator iterator = featureValue.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        if (this.getLanguageCodes().contains(entry.getKey())) continue;
                        iterator.remove();
                    }
                    for (TranslateLanguage language : this.translationProvider.getProject().getInterfaceLanguages()) {
                        String translation = this.translationProvider.getTranslation(eObject, featureSettings, language);
                        if (StringUtils.isNotEmpty((String)translation) && !translation.equals(featureValue.get((Object)language.getLanguageCode()))) {
                            featureValue.put((Object)language.getLanguageCode(), (Object)translation);
                        }
                        if (!this.isFormatFeature(featureSettings)) continue;
                        this.replaceFormatKeys((EMap<String, String>)featureValue);
                    }
                }
            } else if (!eObject.eIsSet((EStructuralFeature)eReference) && eReference.isUnsettable()) {
                copyEObject.eUnset((EStructuralFeature)eReference);
            }
        }
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        if (!eReference.isTransient()) {
            if (eReference.isMany()) {
                EList fromList = (EList)eObject.eGet((EStructuralFeature)eReference);
                EList toList = (EList)copyEObject.eGet((EStructuralFeature)eReference);
                toList.clear();
                for (EObject item : fromList) {
                    toList.add((Object)this.createReplacement(eObject, eReference, item, copyEObject));
                }
            } else {
                copyEObject.eSet((EStructuralFeature)eReference, (Object)this.createReplacement(eObject, eReference, (EObject)eObject.eGet((EStructuralFeature)eReference), copyEObject));
            }
        }
    }

    protected abstract String getTranslatedTopObjectFqn();

    protected EObject createReplacement(EObject context, EReference reference, EObject replaceObject, EObject targetContext) {
        String symbolicName;
        if (replaceObject == null) {
            return null;
        }
        if (replaceObject instanceof Event) {
            URI uri = EcoreUtil.getURI((EObject)replaceObject);
            EObject result = EcoreUtil.create((EClass)replaceObject.eClass());
            ((InternalEObject)result).eSetProxyURI(uri);
            return result;
        }
        String string = symbolicName = this.translationProvider.getProject().isChangeDefaultLanguage() ? this.translatedSymbolicNameService.generateSymbolicName(replaceObject, context, reference, this.translationProvider) : this.symbolicNameService.generateSymbolicName(replaceObject, context, reference);
        if (symbolicName == null) {
            return (EObject)this.get(replaceObject);
        }
        EObject result = EcoreUtil.create((EClass)replaceObject.eClass());
        URI uri = this.symbolicNameService.convertSymbolicNameToUri(symbolicName, targetContext, reference, this.getTranslatedTopObjectFqn(), this.targetNamespace.asEngine(), this.runtimeVersion);
        ((InternalEObject)result).eSetProxyURI(uri);
        return result;
    }

    protected List<String> getLanguageCodes() {
        if (this.languageCodes == null) {
            this.languageCodes = Lists.newArrayList();
            this.translationProvider.getProject().getLanguages().forEach(l -> {
                boolean bl = this.languageCodes.add(l.getLanguageCode());
            });
        }
        return this.languageCodes;
    }

    protected String computeIfAbsent(Pair<EObject, String> key, Provider<String> provider) {
        if (this.cache.get(key) == null) {
            String value = (String)provider.get();
            if (value != null) {
                this.cache.put(key, value);
            }
            return value;
        }
        return this.cache.get(key);
    }

    private String getTranslation(String sourceString) {
        String translation = FormatUtils.processFormatContent((String)sourceString, (ScriptVariant)this.translationProvider.getProject().getScriptVariant(), (FormatInternalizeTokenProvider)this.formatTokenProvider);
        if (StringUtils.isNullOrEmpty((String)translation)) {
            return sourceString;
        }
        return translation;
    }

    private boolean hasFormatKey(String content) {
        V8ParametersStringParser parser = new V8ParametersStringParser(content);
        if (parser.getStatus().isOK() && !parser.getParameters().isEmpty()) {
            Map parameters = parser.getParameters();
            for (Map.Entry entry : parameters.entrySet()) {
                if (!this.formatTokenProvider.isFormatKey((String)entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private void replaceFormatKeys(EMap<String, String> featureValue) {
        for (Map.Entry entry : featureValue.entrySet()) {
            boolean replaceByTranslation;
            String languageCode = (String)entry.getKey();
            String sourceString = (String)featureValue.get((Object)languageCode);
            boolean bl = replaceByTranslation = featureValue.containsKey((Object)languageCode) && this.hasFormatKey(sourceString);
            if (!replaceByTranslation) continue;
            String sourceTranslation = this.getTranslation(sourceString);
            featureValue.put((Object)languageCode, (Object)sourceTranslation);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFormatFeature(EFeatureSettings featureSettings) {
        EFeatureSettings eFeatureSettings = featureSettings;
        if (eFeatureSettings instanceof DtFeatureSettings) {
            void dtFeatureSettings;
            DtFeatureSettings dtFeatureSettings2 = (DtFeatureSettings)eFeatureSettings;
            DtFeatureSettings cfr_ignored_0 = (DtFeatureSettings)eFeatureSettings;
            if (dtFeatureSettings.isFormat()) {
                return true;
            }
        }
        return false;
    }
}

