/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.sync;

import com._1c.g5.v8.bm.core.IBmObject;
import com._1c.g5.v8.bm.core.IBmTransaction;
import com._1c.g5.v8.bm.integration.IBmModel;
import com._1c.g5.v8.dt.bm.xtext.BmAwareResourceSetProvider;
import com._1c.g5.v8.dt.core.platform.IBmModelManager;
import com._1c.g5.v8.dt.md.IExternalPropertyManagerRegistry;
import com._1c.g5.v8.dt.metadata.IExternalPropertyManager;
import com.e1c.g5.dt.core.api.naming.INamingService;
import com.e1c.g5.dt.core.api.platform.BmOperationContext;
import com.e1c.langtool.platform.ITranslatedProject;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.sync.SyncSession;
import com.e1c.langtool.v8.dt.internal.sync.SyncPlugin;
import com.e1c.langtool.v8.dt.sync.AbstractExternalPropertySynchronizer;
import com.e1c.langtool.v8.dt.sync.BmSyncSession;
import com.e1c.langtool.v8.dt.translator.IProjectTranslationProvider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public abstract class ExternalPropertySynchronizer
extends AbstractExternalPropertySynchronizer {
    @Inject
    protected IBmModelManager modelManager;
    @Inject
    protected IExternalPropertyManagerRegistry externalPropertyManagerRegistry;
    @Inject
    private Provider<ResourceSetImpl> resourceSetProvider;
    @Inject
    private BmAwareResourceSetProvider bmResourceSetProvider;
    @Inject
    private INamingService namingService;

    protected abstract IStatus synchronize(IFile var1, BmOperationContext var2, EObject var3, EObject var4, EReference var5, IProject var6, IFile var7, BmSyncSession var8, IProjectTranslationProvider var9, IProgressMonitor var10);

    @Override
    protected IStatus synchronize(IFile sourceFile, EObject owner, IProject target, IFile targetFile, BmSyncSession bmSession, IProjectTranslationProvider translationProvider, IProgressMonitor monitor) {
        EObject topObject;
        IProject project = sourceFile.getProject();
        IBmModel model = this.modelManager.getModel(project);
        IBmTransaction transaction = model.getEngine().getCurrentTransaction();
        BmOperationContext operationContext = new BmOperationContext(this.namingService, this.modelManager, transaction);
        if (transaction != null && owner instanceof IBmObject && ((IBmObject)owner).bmGetEngine() != null) {
            owner = transaction.toTransactionObject(owner);
        }
        if ((topObject = this.emfObjectProvider.getObjectByFile(sourceFile)) == null) {
            if (SyncPlugin.getDefault().isDebugging()) {
                System.out.println("EMF Object not found. Cannot synchronize file: " + sourceFile.getFullPath().toString());
            }
            return Status.CANCEL_STATUS;
        }
        if (transaction != null && topObject instanceof IBmObject && ((IBmObject)topObject).bmGetEngine() != null) {
            topObject = transaction.toTransactionObject(topObject);
        }
        try {
            IExternalPropertyManager manager = this.externalPropertyManagerRegistry.getExternalPropertyManager(model);
            EReference property = manager.getReference(topObject);
            IStatus iStatus = this.synchronize(sourceFile, operationContext, owner, topObject, property, target, targetFile, bmSession, translationProvider, monitor);
            return iStatus;
        }
        finally {
            Resource res = topObject.eResource();
            if (res != null) {
                res.unload();
                ResourceSet resourceSet = res.getResourceSet();
                if (resourceSet != null) {
                    resourceSet.getResources().remove((Object)res);
                }
            }
        }
    }

    public Collection<IFile> remove(IFile sourceFile, ITranslatingProject sourceProject, ITranslatedProject target, SyncSession session, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    protected ResourceSet getResourceSet(IFile modelFile) {
        IResourceServiceProvider rsp = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(URI.createURI((String)("*." + modelFile.getFileExtension())));
        if (rsp == null) {
            return (ResourceSet)this.resourceSetProvider.get();
        }
        return this.bmResourceSetProvider.get(modelFile.getProject());
    }
}

