/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.yandex;

import com.e1c.langtool.common.StringUtils;
import com.google.gson.Gson;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;

public class YandexQueryBuilder {
    private static final String APPLICATION_JSON = "application/json";
    public static final String LICENSE_KEY_PARAM = "Api-Key ";
    private static final String API_URL = "https://translate.api.cloud.yandex.net";
    private static final String TRANSLATION_PATH = "/translate/v2/translate";
    private static final String GETTING_LANGS_PATH = "/translate/v2/languages";
    private static final String PLAIN_TEXT = "PLAIN_TEXT";
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(3L);
    private final Gson gson;
    private final BuilderType builderType;
    protected String licenseKey;
    protected String folderId;
    protected String sourceLocale;
    protected String targetLocale;
    protected String model;
    protected List<String> texts = new LinkedList<String>();

    public static YandexQueryBuilder createTranslationQuery() {
        return new YandexQueryBuilder(BuilderType.TRANSLATION);
    }

    public static YandexQueryBuilder createGettingSupportedLanguagesQuery() {
        return new YandexQueryBuilder(BuilderType.GETTING_SUPPORTED_LANGS);
    }

    protected YandexQueryBuilder(BuilderType builderType) {
        this.builderType = builderType;
        this.gson = new Gson();
    }

    public YandexQueryBuilder key(String key) {
        this.licenseKey = key;
        return this;
    }

    public YandexQueryBuilder folderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    public YandexQueryBuilder model(String model) {
        this.model = model;
        return this;
    }

    public YandexQueryBuilder language(String sourceLocale, String targetLocale) {
        this.sourceLocale = sourceLocale;
        this.targetLocale = targetLocale;
        return this;
    }

    public YandexQueryBuilder text(String text) {
        this.texts.add(text);
        return this;
    }

    public HttpRequest build() {
        Request request = new Request();
        request.setFolderId(this.folderId);
        HttpRequest.Builder builder = HttpRequest.newBuilder().header("Content-Type", APPLICATION_JSON).header("Authorization", LICENSE_KEY_PARAM + this.licenseKey).timeout(REQUEST_TIMEOUT).version(HttpClient.Version.HTTP_1_1);
        if (this.builderType == BuilderType.TRANSLATION) {
            request.setSourceLanguageCode(this.sourceLocale);
            request.setTargetLanguageCode(this.targetLocale);
            request.setFormat(PLAIN_TEXT);
            request.setTexts(this.texts);
            if (StringUtils.isNotEmpty((String)this.model)) {
                request.setModel(this.model);
            }
            builder.uri(URI.create("https://translate.api.cloud.yandex.net/translate/v2/translate"));
        } else {
            builder.uri(URI.create("https://translate.api.cloud.yandex.net/translate/v2/languages"));
        }
        String requestBody = this.gson.toJson((Object)request);
        return builder.POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
    }

    public BuilderType getBuilderType() {
        return this.builderType;
    }

    public static enum BuilderType {
        TRANSLATION,
        GETTING_SUPPORTED_LANGS;

    }

    public static class GlossaryConfig {
        private GlossaryData glossaryData;

        public GlossaryData getGlossaryData() {
            return this.glossaryData;
        }

        public void setGlossaryData(GlossaryData glossaryData) {
            this.glossaryData = glossaryData;
        }
    }

    public static class GlossaryData {
        private List<GlossaryPair> glossaryPairs;

        public List<GlossaryPair> getGlossaryPairs() {
            return this.glossaryPairs;
        }

        public void setGlossaryPairs(List<GlossaryPair> glossaryPairs) {
            this.glossaryPairs = glossaryPairs;
        }
    }

    public static class GlossaryPair {
        private String sourceText;
        private String translatedText;

        public String getSourceText() {
            return this.sourceText;
        }

        public void setSourceText(String sourceText) {
            this.sourceText = sourceText;
        }

        public String getTranslatedText() {
            return this.translatedText;
        }

        public void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }
    }

    public static class Request {
        private String folderId;
        private String sourceLanguageCode;
        private String targetLanguageCode;
        private String format;
        private List<String> texts;
        private String model;
        private GlossaryConfig glossaryConfig;

        public void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        public String getFolderId() {
            return this.folderId;
        }

        public String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        public void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public String getTargetLanguageCode() {
            return this.targetLanguageCode;
        }

        public void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public List<String> getTexts() {
            return this.texts;
        }

        public void setTexts(List<String> texts) {
            this.texts = texts;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public GlossaryConfig getGlossaryConfig() {
            return this.glossaryConfig;
        }

        public void setGlossaryConfig(GlossaryConfig glossaryConfig) {
            this.glossaryConfig = glossaryConfig;
        }
    }
}

