/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.v8.dt.textdocument.sync;

import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.sync.DependentContentComputer;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class TextDependentContentComputer
implements DependentContentComputer {
    protected static final String FILE_NAME_SEGMENT_SPLITTER = "_";
    @Inject
    private ITranslatingProjectManager translatingProjectManager;

    public Collection<IFile> computeDependentContentToSynchronize(IFile source, boolean sourceRemoved, IProgressMonitor monitor) {
        String fileName = source.getFullPath().lastSegment();
        String[] segments = fileName.split(FILE_NAME_SEGMENT_SPLITTER);
        if (segments.length == 2) {
            IPath newPath;
            IFile originFile;
            IProject sourceProject = source.getProject();
            Optional translating = this.translatingProjectManager.getTranslatingForExternalProject(source.getProject());
            if (translating.isPresent() && ((ITranslatingProject)translating.get()).isTranslating()) {
                sourceProject = ((ITranslatingProject)translating.get()).getProject();
            }
            if ((originFile = sourceProject.getFile(newPath = source.getProjectRelativePath().removeLastSegments(1).append(segments[0]).addFileExtension(source.getFileExtension()))).exists()) {
                return Lists.newArrayList((Object[])new IFile[]{originFile});
            }
        }
        return Lists.newArrayList();
    }
}

