/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.google.ui;

import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.google.ui.Messages;
import com.e1c.langtool.ui.ViewUtils;
import com.e1c.langtool.ui.external.AbstractTranslationPreferencePage;
import com.e1c.langtool.ui.external.ExternalTranslationView;
import com.google.inject.Inject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GoogleTranslatePreferencePage
extends AbstractTranslationPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.e1c.langtool.google.ui.googleTranslatePreferencePage";
    private static final String GETTING_KEY_URL = "https://developers.google.com/identity/protocols/oauth2";
    private static final String GETTING_PROJECT_ID_URL = "https://cloud.google.com/translate/docs/setup?hl#project";
    private static final String GETTING_CLIENT_ID_URL = "https://console.developers.google.com/";
    private static final String GETTING_REFRESH_TOKEN_URL = "https://developers.google.com/oauthplayground/";
    private Text projectIDText;
    protected Text tokenText;
    private Text modelText;
    private Text locationText;
    private Text clientIdText;
    private Text clientSecretText;

    @Inject
    public GoogleTranslatePreferencePage(ITranslationCacheManager translationCacheManager) {
        super(translationCacheManager, "com.e1c.langtool.google.googleTranslateProvider");
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.e1c.langtool.google");
        this.setPreferenceStore((IPreferenceStore)prefs);
        this.setDescription(Messages.GoogleTranslatePreferencePage_Description);
    }

    protected void createAccessKeyGroup(Composite parent) {
        Group commonGroup = new Group(parent, 0);
        commonGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        commonGroup.setLayout((Layout)new GridLayout(1, false));
        commonGroup.setText(Messages.GoogleTranslatePreferencePage_Access_group_text);
        this.createProjectIDGetLink((Composite)commonGroup);
        Composite group = new Composite((Composite)commonGroup, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        new Label(group, 0).setText(Messages.GoogleTranslatePreferencePage_Parent);
        this.projectIDText = new Text(group, 0x400800);
        this.projectIDText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectIDText.setMessage(Messages.GoogleTranslatePreferencePage_Parent_message);
        this.createClientIDGetLink((Composite)commonGroup);
        Group groupOauth = new Group((Composite)commonGroup, 0);
        groupOauth.setLayoutData((Object)new GridData(4, 4, true, false));
        groupOauth.setLayout((Layout)new GridLayout(2, false));
        groupOauth.setText(Messages.GoogleTranslatePreferencePage_OAuth_group_text);
        new Label((Composite)groupOauth, 0).setText(Messages.GoogleTranslatePreferencePage_Client_ID);
        this.clientIdText = new Text((Composite)groupOauth, 0x400800);
        this.clientIdText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.clientIdText.setMessage(Messages.GoogleTranslatePreferencePage_Client_ID_Message);
        new Label((Composite)groupOauth, 0).setText(Messages.GoogleTranslatePreferencePage_Client_Secret);
        this.clientSecretText = new Text((Composite)groupOauth, 0x400800);
        this.clientSecretText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.clientSecretText.setMessage(Messages.GoogleTranslatePreferencePage_Client_Secret_Message);
        this.createRefreshTokenGetLink((Composite)commonGroup);
        Composite composite1 = new Composite((Composite)commonGroup, 0);
        composite1.setLayoutData((Object)new GridData(4, 4, true, false));
        composite1.setLayout((Layout)new GridLayout(2, false));
        new Label(composite1, 0).setText(Messages.GoogleTranslatePreferencePage_Token);
        this.tokenText = new Text(composite1, 0x400800);
        this.tokenText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tokenText.setMessage(Messages.GoogleTranslatePreferencePage_Token_message);
        new Label(composite1, 0);
        Composite composite = new Composite(composite1, 0);
        GridData gridData = new GridData(131072, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        this.createCheckAccessKeyButton(composite);
        Group group2 = new Group(parent, 0);
        group2.setLayoutData((Object)new GridData(4, 4, true, false));
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setText(Messages.GoogleTranslatePreferencePage_Model_ID_group_text);
        new Label((Composite)group2, 0).setText(Messages.GoogleTranslatePreferencePage_Model_ID);
        this.modelText = new Text((Composite)group2, 2048);
        this.modelText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.modelText.setMessage(Messages.GoogleTranslatePreferencePage_Model_ID_message);
        new Label((Composite)group2, 0).setText(Messages.GoogleTranslatePreferencePage_Location);
        this.locationText = new Text((Composite)group2, 2048);
        this.locationText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.locationText.setMessage(Messages.GoogleTranslatePreferencePage_Location_message);
    }

    protected String getAccessKey() {
        return this.tokenText.getText();
    }

    /*
     * Exception decompiling
     */
    protected boolean checkAccessKey(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void reloadView() {
        ExternalTranslationView view = (ExternalTranslationView)ViewUtils.getView((String)"com.e1c.langtool.google.ui.googleTranslateView");
        if (view != null && !view.isInitialized()) {
            ViewUtils.reloadView((String)"com.e1c.langtool.google.ui.googleTranslateView");
        }
    }

    protected SelectionListener createLinkSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)GoogleTranslatePreferencePage.GETTING_KEY_URL);
            }
        };
    }

    protected void initializeValues() {
        this.projectIDText.setText(this.getPreferenceStore().getString("projectID"));
        this.tokenText.setText(this.getPreferenceStore().getString("refreshToken"));
        this.modelText.setText(this.getPreferenceStore().getString("model"));
        this.clientIdText.setText(this.getPreferenceStore().getString("clientId"));
        this.clientSecretText.setText(this.getPreferenceStore().getString("clientSecret"));
        this.locationText.setText(this.getPreferenceStore().getString("location"));
    }

    protected void storeValues() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String oldValue = preferenceStore.getString("refreshToken");
        String projectIDOldValue = preferenceStore.getString("projectID");
        String newApiKey = this.tokenText.getText();
        String projectIDNewValue = this.projectIDText.getText();
        if (!oldValue.equals(newApiKey) || !projectIDOldValue.equals(projectIDNewValue)) {
            this.isApiKeyValueChanged = true;
            preferenceStore.setValue("refreshToken", newApiKey);
            preferenceStore.setValue("projectID", projectIDNewValue);
        }
        String newModel = this.modelText.getText();
        preferenceStore.setValue("model", newModel);
        String newLocation = this.locationText.getText();
        preferenceStore.setValue("location", newLocation);
        String newClientId = this.clientIdText.getText();
        preferenceStore.setValue("clientId", newClientId);
        String newClientSecret = this.clientSecretText.getText();
        preferenceStore.setValue("clientSecret", newClientSecret);
    }

    protected void createProjectIDGetLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.GoogleTranslationPreferencePage_GetProjectIDLink);
        link.addSelectionListener(this.createLinkProjectIDSelectionListener());
    }

    protected SelectionListener createLinkProjectIDSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)GoogleTranslatePreferencePage.GETTING_PROJECT_ID_URL);
            }
        };
    }

    protected void createClientIDGetLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.GoogleTranslationPreferencePage_GetLink);
        link.addSelectionListener(this.createLinkClientIDSelectionListener());
    }

    protected SelectionListener createLinkClientIDSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)GoogleTranslatePreferencePage.GETTING_CLIENT_ID_URL);
            }
        };
    }

    protected void createRefreshTokenGetLink(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(Messages.GoogleTranslationPreferencePage_GetOAuthLink);
        link.addSelectionListener(this.createLinkRefreshTokenSelectionListener());
    }

    protected SelectionListener createLinkRefreshTokenSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)GoogleTranslatePreferencePage.GETTING_REFRESH_TOKEN_URL);
            }
        };
    }
}

