/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.settings.FeatureSettings;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class ContextTranslationKeyImpl
implements ContextTranslationKey {
    private static final long serialVersionUID = 5060134311075419913L;
    private final String fullPath;
    private transient IPath resourceId;
    private final FeatureKey featureKey;
    private final FeatureSettings featureSettings;
    private final String value;
    private transient IProject project;
    private final int hashCode;

    public ContextTranslationKeyImpl(IProject project, IPath resourceId, FeatureKey featureKey, FeatureSettings featureSettings, String value) {
        this.project = project;
        this.resourceId = resourceId;
        this.featureKey = featureKey;
        this.featureSettings = featureSettings;
        this.value = value;
        IPath path = project.getFullPath().append(resourceId);
        Assert.isLegal((path.segmentCount() > 1 ? 1 : 0) != 0, (String)"Path cannot be less that 2 segments");
        this.fullPath = path.toString();
        this.hashCode = Objects.hash(featureKey, this.fullPath, value);
    }

    public ContextTranslationKeyImpl(IFile file, FeatureKey featureKey, FeatureSettings featureSettings, String value) {
        this(file.getProject(), file.getProjectRelativePath(), featureKey, featureSettings, value);
    }

    public ContextTranslationKeyImpl(String fullPath, FeatureKey featureKey, FeatureSettings featureSettings, String value) {
        this(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath)), featureKey, featureSettings, value);
    }

    @Override
    public FeatureSettings getFeatureSettings() {
        return this.featureSettings;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public IProject getSourceProject() {
        if (this.project == null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.fullPath));
            this.project = file.getProject();
        }
        return this.project;
    }

    @Override
    public IPath getResourceId() {
        if (this.resourceId == null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.fullPath));
            this.resourceId = file.getProjectRelativePath();
        }
        return this.resourceId;
    }

    @Override
    public FeatureKey getFeatureKey() {
        return this.featureKey;
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextTranslationKeyImpl other = (ContextTranslationKeyImpl)obj;
        return Objects.equals(this.featureKey, other.featureKey) && Objects.equals(this.fullPath, other.fullPath) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ContextTranslationKeyImpl [fullPath=" + this.fullPath + ", featureKey=" + String.valueOf(this.featureKey) + ", featureSettings=" + String.valueOf(this.featureSettings) + ", value=" + this.value + "]";
    }
}

