/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com._1c.g5.wiring.IManagedService;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingCacheChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public interface ICollectingCacheManager
extends IManagedService {
    public void addChangeListener(ICollectingCacheChangeListener var1);

    public void removeChangeListener(ICollectingCacheChangeListener var1);

    public void clear(IProject var1);

    public void enableTrackChanges(IProject var1);

    public void closeAndDisableTrackChanges(IProject var1);

    default public boolean invalidate(IFile file) {
        return this.invalidate(file.getProject(), file.getProjectRelativePath());
    }

    public boolean invalidate(IProject var1, IPath var2);

    public boolean isInvalidated(IProject var1, IPath var2);

    public boolean invalidateAll(IProject var1);

    public Iterator<IPath> allInvalidated(IProject var1);

    public Iterator<IPath> allResources(IProject var1);

    default public Collection<FeatureValue> getInterface(IFile file) {
        return this.getInterface(file.getProject(), file.getProjectRelativePath());
    }

    public Collection<FeatureValue> getInterface(IProject var1, IPath var2);

    default public void putInterface(IFile file, Collection<FeatureValue> keys) {
        this.putInterface(file.getProject(), file.getProjectRelativePath(), keys);
    }

    public void putInterface(IProject var1, IPath var2, Collection<FeatureValue> var3);

    default public Collection<FeatureValue> getModel(IFile file) {
        return this.getModel(file.getProject(), file.getProjectRelativePath());
    }

    public Collection<FeatureValue> getModel(IProject var1, IPath var2);

    default public void putModel(IFile file, Collection<FeatureValue> keys) {
        this.putModel(file.getProject(), file.getProjectRelativePath(), keys);
    }

    public void putModel(IProject var1, IPath var2, Collection<FeatureValue> var3);

    default public Collection<FeatureValue> getModelComputed(IFile file) {
        return this.getModelComputed(file.getProject(), file.getProjectRelativePath());
    }

    public Collection<FeatureValue> getModelComputed(IProject var1, IPath var2);

    default public void putModelComputed(IFile file, Collection<FeatureValue> keys) {
        this.putModelComputed(file.getProject(), file.getProjectRelativePath(), keys);
    }

    public void putModelComputed(IProject var1, IPath var2, Collection<FeatureValue> var3);

    default public Collection<FeatureValue> computeIfAbsent(IFile file, Function<IFile, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v1 = null;
        Collection<FeatureValue> v2 = null;
        Collection<FeatureValue> v3 = null;
        if (this.isInvalidated(file.getProject(), file.getProjectRelativePath()) || (v1 = this.getInterface(file)) == null || (v2 = this.getModel(file)) == null || (v3 = this.getModelComputed(file)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(file);
            if (newValue != null) {
                this.putInterface(file, newValue.stream().filter(v -> v.getContextKey().getFeatureSettings().isInterface()).collect(Collectors.toList()));
                this.putModel(file, newValue.stream().filter(v -> !v.isComputedValue() && v.getContextKey().getFeatureSettings().isModel()).collect(Collectors.toList()));
                this.putModelComputed(file, newValue.stream().filter(v -> v.isComputedValue() && v.getContextKey().getFeatureSettings().isModel()).collect(Collectors.toList()));
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        ArrayList<FeatureValue> v4 = new ArrayList<FeatureValue>();
        v4.addAll(v1);
        v4.addAll(v2);
        v4.addAll(v3);
        return v4;
    }

    default public Collection<FeatureValue> computeIfAbsent(IProject project, IPath path, BiFunction<IProject, IPath, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v1 = null;
        Collection<FeatureValue> v2 = null;
        Collection<FeatureValue> v3 = null;
        if (this.isInvalidated(project, path) || (v1 = this.getInterface(project, path)) == null || (v2 = this.getModel(project, path)) == null || (v3 = this.getModelComputed(project, path)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(project, path);
            if (newValue != null) {
                this.putInterface(project, path, newValue.stream().filter(v -> v.getContextKey().getFeatureSettings().isInterface()).collect(Collectors.toList()));
                this.putModel(project, path, newValue.stream().filter(v -> !v.isComputedValue() && v.getContextKey().getFeatureSettings().isModel()).collect(Collectors.toList()));
                this.putModelComputed(project, path, newValue.stream().filter(v -> v.isComputedValue() && v.getContextKey().getFeatureSettings().isModel()).collect(Collectors.toList()));
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        ArrayList<FeatureValue> v4 = new ArrayList<FeatureValue>();
        v4.addAll(v1);
        v4.addAll(v2);
        v4.addAll(v3);
        return v4;
    }

    default public Collection<FeatureValue> computeIfAbsentInterface(IFile file, Function<IFile, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v = null;
        if (this.isInvalidated(file.getProject(), file.getProjectRelativePath()) || (v = this.getInterface(file)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(file);
            if (newValue != null) {
                this.putInterface(file, newValue);
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        return v;
    }

    default public Collection<FeatureValue> computeIfAbsentInterface(IProject project, IPath path, BiFunction<IProject, IPath, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v = null;
        if (this.isInvalidated(project, path) || (v = this.getInterface(project, path)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(project, path);
            if (newValue != null) {
                this.putInterface(project, path, newValue);
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        return v;
    }

    default public Collection<FeatureValue> computeIfAbsentModel(IFile file, Function<IFile, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v = null;
        if (this.isInvalidated(file.getProject(), file.getProjectRelativePath()) || (v = this.getModel(file)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(file);
            if (newValue != null) {
                this.putModel(file, newValue);
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        return v;
    }

    default public Collection<FeatureValue> computeIfAbsentModel(IProject project, IPath path, BiFunction<IProject, IPath, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v = null;
        if (this.isInvalidated(project, path) || (v = this.getModel(project, path)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(project, path);
            if (newValue != null) {
                this.putModel(project, path, newValue);
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        return v;
    }

    default public Collection<FeatureValue> computeIfAbsentModelComputed(IFile file, Function<IFile, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v = null;
        if (this.isInvalidated(file.getProject(), file.getProjectRelativePath()) || (v = this.getModelComputed(file)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(file);
            if (newValue != null) {
                this.putModelComputed(file, newValue);
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        return v;
    }

    default public Collection<FeatureValue> computeIfAbsentModelComputed(IProject project, IPath path, BiFunction<IProject, IPath, Collection<FeatureValue>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Collection<FeatureValue> v = null;
        if (this.isInvalidated(project, path) || (v = this.getModelComputed(project, path)) == null) {
            Collection<FeatureValue> newValue = mappingFunction.apply(project, path);
            if (newValue != null) {
                this.putModelComputed(project, path, newValue);
                return newValue;
            }
            return new ArrayList<FeatureValue>(0);
        }
        return v;
    }
}

