/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.platform.TranslateLanguage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public interface ICollectingParameters {
    public static final ICollectingParameters DEFAULT = new CollectingParameters(false, true, true, true, CollectModelType.ANY, false, (Set)Sets.newHashSet(), false, true, false){

        @Override
        public Collection<Exception> getErrors() {
            return Lists.newArrayList();
        }
    };

    public boolean isCollectChildObjects();

    public boolean isCollectModelStrings();

    public boolean isCollectInterfaceStrings();

    public CollectModelType getCollectModelType();

    public boolean isCollectSubResources();

    public Set<TranslateLanguage> getLanguages();

    public boolean isCollectEmptyValue();

    public boolean isContinueAfterFirstError();

    public Collection<Exception> getErrors();

    default public Map<String, Object> getFilterParameters() {
        return Collections.emptyMap();
    }

    public boolean useCache();

    public boolean isKeepLanguagesMode();

    public static enum CollectModelType {
        ANY,
        NONE,
        COMPUTED_ONLY,
        UNKNOWN_ONLY,
        TAGS_ONLY;

        private static final Map<String, CollectModelType> nameMap;

        static {
            nameMap = new TreeMap<String, CollectModelType>(String.CASE_INSENSITIVE_ORDER);
            CollectModelType[] collectModelTypeArray = CollectModelType.values();
            int n = collectModelTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CollectModelType value = collectModelTypeArray[n2];
                nameMap.put(value.name(), value);
                ++n2;
            }
            nameMap.put("none", NONE);
            nameMap.put("computed", COMPUTED_ONLY);
            nameMap.put("unknown", UNKNOWN_ONLY);
            nameMap.put("tags", TAGS_ONLY);
        }

        public static CollectModelType forName(String value) {
            if (value == null) {
                return null;
            }
            return nameMap.get(value);
        }
    }
}

