/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.Messages;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.internal.CorePlugin;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;

public class ProjectMultiThreadCollectingOperation {
    private final IFeatureValueCollectingService collectingService;
    private final IProject project;
    private final ICollectingParameters parameters;
    private final String beforeOperationTaskName;
    private final Runnable beforeOperationRun;
    private final String operationTaskName;
    private final Duration threadKeepAliveTime;
    private final String threadNamePrefix;
    private final BiFunction<Long, Long, String> subTaskName;

    private ProjectMultiThreadCollectingOperation(IFeatureValueCollectingService collectingService, IProject project, ICollectingParameters parameters, String threadNamePrefix, Duration threadKeepAliveTime, String beforeOperationTaskName, Runnable beforeOperationRun, String operationTaskName, BiFunction<Long, Long, String> subTaskName) {
        this.collectingService = collectingService;
        this.project = project;
        this.parameters = parameters;
        this.threadNamePrefix = threadNamePrefix;
        this.threadKeepAliveTime = threadKeepAliveTime;
        this.beforeOperationTaskName = beforeOperationTaskName;
        this.beforeOperationRun = beforeOperationRun;
        this.operationTaskName = operationTaskName;
        this.subTaskName = subTaskName;
    }

    public void process(BiConsumer<Object, FeatureValue> action, IProgressMonitor monitor) {
        this.beforeProcess(monitor);
        Pair<ExecutorService, BlockingQueue<Runnable>> pair = this.createQueueAndPool();
        this.collectingService.collectAll(this.project, this.parameters, action, pair.getKey(), monitor);
        this.awaitComputation(pair.getKey(), pair.getValue(), monitor);
        monitor.done();
    }

    public void processByFiles(BiConsumer<IFile, Collection<FeatureValue>> action, IProgressMonitor monitor) {
        this.beforeProcess(monitor);
        Pair<ExecutorService, BlockingQueue<Runnable>> pair = this.createQueueAndPool();
        this.collectingService.collectAllByFile(this.project, this.parameters, action, pair.getKey(), monitor);
        this.awaitComputation(pair.getKey(), pair.getValue(), monitor);
        monitor.done();
    }

    @Deprecated
    public void processRaw(BiConsumer<Object, FeatureValue> action, IProgressMonitor monitor) {
        this.beforeProcess(monitor);
        Pair<ExecutorService, BlockingQueue<Runnable>> pair = this.createQueueAndPool();
        this.collectingService.collectAll(this.project, this.parameters, action, pair.getKey(), monitor);
        this.awaitComputation(pair.getKey(), pair.getValue(), monitor);
        monitor.done();
    }

    private void awaitComputation(ExecutorService pool, BlockingQueue<Runnable> queue, IProgressMonitor monitor) {
        Long total = ((ThreadPoolExecutor)pool).getTaskCount();
        int current = total.intValue();
        monitor.beginTask(this.operationTaskName, total.intValue());
        pool.shutdown();
        boolean terminated = false;
        do {
            try {
                terminated = pool.awaitTermination(500L, TimeUnit.MILLISECONDS);
                int left = queue.size();
                monitor.worked(current - left);
                current = left;
                monitor.subTask(this.subTaskName.apply(total - (long)current, total));
            }
            catch (InterruptedException e) {
                CorePlugin.logError(e);
                break;
            }
        } while (!terminated && !monitor.isCanceled());
        if (monitor.isCanceled() && !pool.isTerminated()) {
            pool.shutdownNow();
        }
    }

    private Pair<ExecutorService, BlockingQueue<Runnable>> createQueueAndPool() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        int poolSize = TranslationUtils.computePoolSize(false);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(poolSize, poolSize, this.threadKeepAliveTime.toSeconds(), TimeUnit.SECONDS, queue, new ThreadFactory(){
            final AtomicInteger index = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(ProjectMultiThreadCollectingOperation.this.threadNamePrefix + this.index.incrementAndGet());
                return t;
            }
        });
        return new Pair<ExecutorService, BlockingQueue<Runnable>>(pool, queue);
    }

    private void beforeProcess(IProgressMonitor monitor) {
        monitor.beginTask(this.beforeOperationTaskName, -1);
        if (this.beforeOperationRun != null) {
            this.beforeOperationRun.run();
        }
    }

    public static final class Builder {
        private IFeatureValueCollectingService collectingService;
        private IProject project;
        private ICollectingParameters parameters;
        private String beforeOperationTaskName;
        private @Nullable Runnable beforeOperationRun;
        private String operationTaskName;
        private Duration threadKeepAliveTime;
        private String threadNamePrefix;
        private BiFunction<Long, Long, String> subTaskName;

        public static Builder newBuilder() {
            return new Builder();
        }

        public ProjectMultiThreadCollectingOperation build() {
            Assert.isNotNull((Object)this.project, (String)"Project cannot be null");
            if (this.collectingService == null) {
                this.collectingService = (IFeatureValueCollectingService)CorePlugin.getDefault().getInjector().getInstance(IFeatureValueCollectingService.class);
            }
            if (this.parameters == null) {
                this.parameters = ICollectingParameters.DEFAULT;
            }
            if (this.beforeOperationTaskName == null) {
                this.beforeOperationTaskName = MessageFormat.format(Messages.ProjectMultiThreadCollectingOperation_Collecting_strings_from__N, this.project.getName());
            }
            if (this.threadNamePrefix == null) {
                this.threadNamePrefix = "Project-string-collector-(" + this.project.getName() + ")-";
            }
            if (this.threadKeepAliveTime == null || this.threadKeepAliveTime.toSeconds() < 1L) {
                this.threadKeepAliveTime = Duration.ofSeconds(10L);
            }
            if (this.operationTaskName == null) {
                this.operationTaskName = MessageFormat.format(Messages.ProjectMultiThreadCollectingOperation_Collecting_strings_from__N, this.project.getName());
            }
            if (this.subTaskName == null) {
                this.subTaskName = (done, total) -> MessageFormat.format(Messages.ProjectMultiThreadCollectingOperation_files__N__of__T, done, total);
            }
            return new ProjectMultiThreadCollectingOperation(this.collectingService, this.project, this.parameters, this.threadNamePrefix, this.threadKeepAliveTime, this.beforeOperationTaskName, this.beforeOperationRun, this.beforeOperationTaskName, this.subTaskName);
        }

        public Builder collectingService(IFeatureValueCollectingService collectingService) {
            this.collectingService = collectingService;
            return this;
        }

        public Builder beforeOperationTaskName(String beforeOperationTaskName) {
            this.beforeOperationTaskName = beforeOperationTaskName;
            return this;
        }

        public Builder beforeOperationRun(Runnable beforeOperationRun) {
            this.beforeOperationRun = beforeOperationRun;
            return this;
        }

        public Builder operationTaskName(String operationTaskName) {
            this.operationTaskName = operationTaskName;
            return this;
        }

        public Builder threadKeepAliveTime(Duration threadKeepAliveTime) {
            this.threadKeepAliveTime = threadKeepAliveTime;
            return this;
        }

        public Builder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Builder subTaskName(BiFunction<Long, Long, String> subTaskName) {
            this.subTaskName = subTaskName;
            return this;
        }

        public Builder parameters(ICollectingParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder project(IProject project) {
            this.project = project;
            return this;
        }
    }
}

