/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.collector;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.CollectingFilterParticipant;
import com.e1c.langtool.collector.FeatureValue;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class RegExCollectingFilter
implements CollectingFilterParticipant {
    public static final String PARAM_RESOURCE_ID_REGEX = "resource-id-regex";
    public static final String PARAM_FEATURE_KEY_REGEX = "feature-key-regex";
    public static final String PARAM_FEATURE_VALUE_REGEX = "feature-value-regex";

    @Override
    public boolean canCollect(TranslationSource source, Map<String, Object> parameters, IProgressMonitor monitor) {
        if (parameters.containsKey(PARAM_RESOURCE_ID_REGEX)) {
            IPath path = source.getProjectRelativePath();
            Pattern pattern = this.getPattern(parameters, PARAM_RESOURCE_ID_REGEX);
            if (path != null && !path.isEmpty() && pattern != null && !pattern.matcher(path.toString()).find()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean needCollectRaw(TranslationSource source, Object sourceObject, FeatureValue value, Map<String, Object> parameters, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public boolean needCollect(TranslationSource sourc, FeatureValue value, Map<String, Object> parameters, IProgressMonitor monitor) {
        Pattern pattern;
        if (parameters.containsKey(PARAM_RESOURCE_ID_REGEX)) {
            IPath path = value.getContextKey().getResourceId();
            Pattern pattern2 = this.getPattern(parameters, PARAM_RESOURCE_ID_REGEX);
            if (pattern2 == null || path != null && !path.isEmpty() && !pattern2.matcher(path.toString()).find()) {
                return false;
            }
        }
        if (parameters.containsKey(PARAM_FEATURE_KEY_REGEX) && ((pattern = this.getPattern(parameters, PARAM_FEATURE_KEY_REGEX)) == null || !pattern.matcher(value.getContextKey().getFeatureKey().toString()).find())) {
            return false;
        }
        return !parameters.containsKey(PARAM_FEATURE_VALUE_REGEX) || (pattern = this.getPattern(parameters, PARAM_FEATURE_VALUE_REGEX)) != null && pattern.matcher(value.getContextKey().getValue()).find();
    }

    private Pattern getPattern(Map<String, Object> parameters, String key) {
        Object value = parameters.get(key);
        if (value instanceof Pattern) {
            return (Pattern)value;
        }
        if (value instanceof String) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile((String)value, 256);
                parameters.put(key, pattern);
                return pattern;
            }
            catch (PatternSyntaxException e) {
                return null;
            }
            catch (UnsupportedOperationException e) {
                return pattern;
            }
        }
        return null;
    }
}

