/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.external.cache;

import com.e1c.langtool.external.cache.ITranslationCacheManager;
import com.e1c.langtool.external.cache.TranslationQueryEntity;
import com.e1c.langtool.external.cache.TranslationResultEntity;
import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.Path;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class TranslationCache
implements ITranslationCacheManager.ITranslationCache {
    private static final String CACHE_MAP_NAME = "cache";
    private final Gson gson = new Gson();
    private final ConcurrentMap<String, String> map;
    private final DB db;

    public TranslationCache(String path, String name) {
        File dbFile = new File(Paths.get(path, name + ".db").toString());
        this.db = DBMaker.newFileDB((File)dbFile).closeOnJvmShutdown().cacheLRUEnable().make();
        this.renameOldMap(name, path);
        this.map = this.db.createHashMap(CACHE_MAP_NAME).counterEnable().makeOrGet();
    }

    @Override
    public synchronized void put(TranslationQueryEntity key, TranslationResultEntity value) {
        String strKey = this.serializeKey(key);
        String strValue = this.serializeValue(value);
        if (strKey != null && strValue != null) {
            this.map.put(strKey, strValue);
            this.db.commit();
        }
    }

    @Override
    public synchronized void putAll(Map<? extends TranslationQueryEntity, ? extends TranslationResultEntity> map) {
        for (Map.Entry<? extends TranslationQueryEntity, ? extends TranslationResultEntity> entry : map.entrySet()) {
            String strKey = this.serializeKey(entry.getKey());
            String strValue = this.serializeValue(entry.getValue());
            if (strKey == null || strValue == null) continue;
            this.map.put(strKey, strValue);
        }
        this.db.commit();
    }

    @Override
    public synchronized TranslationResultEntity get(TranslationQueryEntity key) {
        String strKey = this.serializeKey(key);
        if (strKey == null) {
            return null;
        }
        String strValue = (String)this.map.get(strKey);
        if (strValue == null) {
            return null;
        }
        return this.deserializeValue(strValue);
    }

    @Override
    public synchronized void remove(TranslationQueryEntity key) {
        String strKey = this.serializeKey(key);
        if (strKey != null) {
            this.map.remove(strKey);
        }
        this.db.commit();
    }

    @Override
    public synchronized void removeAll(Iterator<?> keys) {
        while (keys.hasNext()) {
            String strKey = this.serializeKey(keys.next());
            if (strKey == null) continue;
            this.map.remove(strKey);
        }
        this.db.commit();
    }

    @Override
    public synchronized void removeAll() {
        this.map.clear();
        this.db.commit();
    }

    @Override
    public synchronized long size() {
        return this.map.size();
    }

    @Override
    public synchronized Map<TranslationQueryEntity, TranslationResultEntity> getAll() {
        HashMap<TranslationQueryEntity, TranslationResultEntity> result = new HashMap<TranslationQueryEntity, TranslationResultEntity>();
        for (Map.Entry entry : this.map.entrySet()) {
            TranslationQueryEntity query = this.deserializeKey((String)entry.getKey());
            TranslationResultEntity res = this.deserializeValue((String)entry.getValue());
            if (query == null || res == null) continue;
            result.put(query, res);
        }
        return result;
    }

    private String serializeKey(Object query) {
        return this.gson.toJson(query);
    }

    private TranslationQueryEntity deserializeKey(String key) {
        return (TranslationQueryEntity)this.gson.fromJson(key, TranslationQueryEntity.class);
    }

    private String serializeValue(Object result) {
        return this.gson.toJson(result);
    }

    private TranslationResultEntity deserializeValue(String value) {
        return (TranslationResultEntity)this.gson.fromJson(value, TranslationResultEntity.class);
    }

    private void renameOldMap(String name, String path) {
        String oldName = Paths.get(path, name + ".map").toString();
        if (this.db.exists(oldName)) {
            this.db.rename(oldName, CACHE_MAP_NAME);
        } else {
            oldName = this.findMovedMapName(name);
            if (oldName != null && this.db.exists(oldName)) {
                this.db.rename(oldName, CACHE_MAP_NAME);
                this.db.commit();
            }
        }
    }

    private String findMovedMapName(String name) {
        String lastSegment = name + ".map.type";
        for (Map.Entry entry : this.db.getCatalog().entrySet()) {
            String oldMapName;
            String key = (String)entry.getKey();
            Path keyPath = null;
            if (!Path.isValidPosixPath((String)key) || !lastSegment.equals((keyPath = new Path(key)).lastSegment()) || !this.db.exists(oldMapName = keyPath.removeLastSegments(1).append(name + ".map").toFile().toPath().toString())) continue;
            return oldMapName;
        }
        return null;
    }
}

