/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.generatestring;

import com.e1c.langtool.ContextTranslationKeyImpl;
import com.e1c.langtool.collector.CollectingServiceRegistry;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.PersistableFeatureValue;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.generatestring.CustomClassLoaderObjectInputStream;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.settings.FeatureSettings;
import com.google.inject.Inject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.mapdb.Serializer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class FeatureValueSerializer
implements Serializer<FeatureValue>,
Serializable {
    private static final long serialVersionUID = 1856169444708394575L;
    private transient CollectingServiceRegistry collectingServiceRegistry;

    @Inject
    public FeatureValueSerializer(CollectingServiceRegistry collectingServiceRegistry) {
        this.collectingServiceRegistry = collectingServiceRegistry;
    }

    public void serialize(DataOutput out, FeatureValue value) throws IOException {
        boolean isOldObject = !(value instanceof PersistableFeatureValue);
        out.writeBoolean(isOldObject);
        if (isOldObject) {
            this.serializeOld(out, value);
        } else {
            this.serializeNew(out, value);
        }
    }

    public FeatureValue deserialize(DataInput in, int available) throws IOException {
        boolean isOldObject = in.readBoolean();
        if (isOldObject) {
            return this.deserializeOld(in, available);
        }
        return this.deserializeNew(in, available);
    }

    public int fixedSize() {
        return -1;
    }

    private void serializeOld(DataOutput out, FeatureValue value) throws IOException {
        out.writeUTF(FrameworkUtil.getBundle(value.getClass()).getSymbolicName());
        ObjectOutputStream out2 = new ObjectOutputStream((OutputStream)((Object)out));
        out2.writeObject(value);
        out2.flush();
    }

    private FeatureValue deserializeOld(DataInput in, int available) throws IOException {
        String bundleName = in.readUTF();
        Bundle bundle = Platform.getBundle((String)bundleName);
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader bundleClassLoader = bundleWiring.getClassLoader();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CustomClassLoaderObjectInputStream in2 = new CustomClassLoaderObjectInputStream((InputStream)((Object)in), bundleClassLoader);){
                return (FeatureValue)in2.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private void serializeNew(DataOutput out, FeatureValue value) throws IOException {
        Assert.isLegal((value.getContextKey().getResourceId().segmentCount() > 0 ? 1 : 0) != 0);
        String fullPath = value.getContextKey().getFullPath();
        Assert.isLegal((boolean)StringUtils.isNotEmpty(fullPath));
        out.writeUTF(fullPath);
        List<String> segments = value.getContextKey().getFeatureKey().getSegments();
        out.writeInt(segments.size());
        for (String segment : segments) {
            out.writeUTF(segment);
        }
        String featureId = this.getCollectingServiceRegistry().getFeatureSettingsId(value.getContextKey().getFeatureSettings());
        out.writeUTF(featureId);
        String content = value.getContextKey().getValue();
        if (content == null) {
            content = "";
        }
        out.writeUTF(content);
        out.writeBoolean(value.isComputedValue());
        String comment = value.getComment();
        if (comment == null) {
            comment = "";
        }
        out.writeUTF(comment);
        Map<String, String> localStrings = Map.copyOf(value.getLocalStrings());
        int size = localStrings.size();
        out.writeInt(size);
        for (Map.Entry<String, String> entry : localStrings.entrySet()) {
            String entryValue;
            String entryKey = entry.getKey();
            if (entryKey == null) {
                entryKey = "";
            }
            if ((entryValue = entry.getValue()) == null) {
                entryValue = "";
            }
            out.writeUTF(entryKey);
            out.writeUTF(entryValue);
        }
    }

    private FeatureValue deserializeNew(DataInput in, int available) throws IOException {
        String fullPath = in.readUTF();
        int segmentCount = in.readInt();
        String[] segments = new String[segmentCount];
        int i = 0;
        while (i < segmentCount) {
            segments[i] = in.readUTF();
            ++i;
        }
        SegmentFeatureKey featureKey = SegmentFeatureKey.create(segments);
        String featureId = in.readUTF();
        FeatureSettings settings = this.getCollectingServiceRegistry().getFeatureSettings(featureId);
        String featureValue = in.readUTF();
        boolean computedValue = in.readBoolean();
        String comment = in.readUTF();
        ContextTranslationKeyImpl key = new ContextTranslationKeyImpl(fullPath, (FeatureKey)featureKey, settings, featureValue);
        PersistableFeatureValue value = new PersistableFeatureValue(key, computedValue, comment);
        int entryCount = in.readInt();
        int i2 = 0;
        while (i2 < entryCount) {
            String entryKey = in.readUTF();
            String entryValue = in.readUTF();
            if (entryKey != null) {
                value.getLocalStrings().put(entryKey, entryValue);
            }
            ++i2;
        }
        return value;
    }

    private CollectingServiceRegistry getCollectingServiceRegistry() {
        if (this.collectingServiceRegistry == null) {
            this.collectingServiceRegistry = (CollectingServiceRegistry)CorePlugin.getDefault().getInjector().getInstance(CollectingServiceRegistry.class);
        }
        return this.collectingServiceRegistry;
    }
}

