/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.generatestring;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.TranslationUtils;
import com.e1c.langtool.collector.CollectingFilterParticipant;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.CollectingServiceRegistry;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.collector.IFeatureValueCollectingService;
import com.e1c.langtool.collector.ProjectMultiThreadCollectingOperation;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.external.IExternalTranslationManager;
import com.e1c.langtool.external.InvalidLanguagesException;
import com.e1c.langtool.external.TranslationServiceException;
import com.e1c.langtool.generatestring.FillUpType;
import com.e1c.langtool.generatestring.InvalidStorageIdException;
import com.e1c.langtool.generatestring.Messages;
import com.e1c.langtool.generatestring.TempFileFeatureCollection;
import com.e1c.langtool.generatestring.TranslationStringsGenerator;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslationOption;
import com.e1c.langtool.query.ContextTranslationQuery;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.ModelValueAlreadyInUseException;
import com.e1c.langtool.storage.StorageID;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectGenerateTranslationStrings
implements TranslationStringsGenerator {
    @Inject
    protected ITranslationStorageManager storageManager;
    @Inject
    protected IFeatureValueCollectingService collectingService;
    @Inject
    private IExternalTranslationManager translationManager;
    @Inject
    private CollectingServiceRegistry collectingServiceRegistry;
    @Inject
    private ValidatorRegistry registry;
    private boolean collectModelStrings = true;
    private boolean collectInterfaceStrings = true;
    private ICollectingParameters.CollectModelType collectModelType = ICollectingParameters.CollectModelType.NONE;
    private List<TranslateLanguage> languages = Lists.newArrayList();
    private StorageID storageId;
    private FillUpType fillUpType = FillUpType.NOT_FILLUP;
    private boolean checkTranslationsInAnyAvailableStorage = false;
    private volatile TempFileFeatureCollection tempValuesStorage = null;
    private ITranslatingProject translatingProject;
    private String translationProviderId;
    private List<Exception> errors = Lists.newArrayList();
    private boolean continueAfterFirstError = false;
    protected Map<String, ? extends Object> filterParameters = Collections.emptyMap();
    private IProjectTranslationReader projectTranslationReader;
    private boolean useCache = true;

    @Override
    public List<TranslateLanguage> getLanguages() {
        return this.languages;
    }

    @Override
    public void setLanguages(List<TranslateLanguage> languages) {
        this.languages = languages;
        if (this.collectModelStrings && !this.isCollectModelStrings()) {
            this.setCollectModelStrings(this.isCollectModelStrings());
        }
    }

    @Override
    public void addLanguage(TranslateLanguage language) {
        if (!this.languages.contains(language)) {
            this.languages.add(language);
        }
        if (this.collectModelStrings && !this.isCollectModelStrings()) {
            this.setCollectModelStrings(this.isCollectModelStrings());
        }
    }

    @Override
    public void removeLanguage(TranslateLanguage language) {
        if (this.languages.contains(language)) {
            this.languages.remove(language);
        }
        if (this.collectModelStrings && !this.isCollectModelStrings()) {
            this.setCollectModelStrings(this.isCollectModelStrings());
        }
    }

    @Override
    public synchronized IProject getProject() {
        return this.getTranslatingProject().getProject();
    }

    @Override
    public boolean isCollectModelStrings() {
        return this.collectModelStrings && this.languages.stream().anyMatch(l -> l.getOption().equals((Object)TranslationOption.MODEL_AND_INTERFACE));
    }

    @Override
    public void setCollectModelStrings(boolean collectModelStrings) {
        this.collectModelStrings = collectModelStrings;
    }

    @Override
    public boolean isCollectInterfaceStrings() {
        return this.collectInterfaceStrings && !this.languages.isEmpty();
    }

    @Override
    public void setCollectInterfaceStrings(boolean collectInterfaceStrings) {
        this.collectInterfaceStrings = collectInterfaceStrings;
    }

    @Override
    public ICollectingParameters.CollectModelType getCollectModelType() {
        return this.collectModelType;
    }

    @Override
    public void setCollectModelType(ICollectingParameters.CollectModelType collectModelType) {
        this.collectModelType = collectModelType;
    }

    @Override
    public synchronized StorageID getStorageId() {
        return this.storageId;
    }

    @Override
    public synchronized void setStorageId(StorageID storageId) {
        this.storageId = storageId;
    }

    @Override
    public FillUpType getFillUpType() {
        return this.fillUpType;
    }

    @Override
    public void setFillUpType(FillUpType fillUpType) {
        this.fillUpType = fillUpType;
    }

    @Override
    public boolean isCheckTranslationsInAnyAvailableStorage() {
        return this.checkTranslationsInAnyAvailableStorage;
    }

    @Override
    public void setCheckTranslationsInAnyAvailableStorage(boolean checkTranslationsInAnyAvailableStorage) {
        this.checkTranslationsInAnyAvailableStorage = checkTranslationsInAnyAvailableStorage;
    }

    @Override
    public void setTranslationProviderId(String providerId) {
        this.translationProviderId = providerId;
    }

    @Override
    public String getTranslationProviderId() {
        return this.translationProviderId;
    }

    @Override
    public ITranslatingProject getTranslatingProject() {
        return this.translatingProject;
    }

    @Override
    public void setTranslatingProject(ITranslatingProject translatingProject) {
        this.translatingProject = translatingProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempFileFeatureCollection getCollectedValues() {
        if (this.tempValuesStorage == null) {
            ProjectGenerateTranslationStrings projectGenerateTranslationStrings = this;
            synchronized (projectGenerateTranslationStrings) {
                if (this.tempValuesStorage == null) {
                    this.tempValuesStorage = new TempFileFeatureCollection();
                }
            }
        }
        return this.tempValuesStorage;
    }

    @Override
    public void setContinueAfterFirstError(boolean isContinue) {
        this.continueAfterFirstError = isContinue;
    }

    @Override
    public boolean isContinueAfterFirstError() {
        return this.continueAfterFirstError;
    }

    @Override
    public boolean canProcess() {
        return this.continueAfterFirstError || this.getErrors().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Exception> getErrors() {
        List<Exception> list = this.errors;
        synchronized (list) {
            return this.errors;
        }
    }

    @Override
    public boolean checkSettings() {
        if (this.getFillUpType().equals((Object)FillUpType.FROM_PROVIDER) && (StringUtils.isNullOrEmpty(this.getTranslationProviderId()) || !this.checkLanguagesByTranslationService())) {
            return false;
        }
        if (!this.collectModelStrings && !this.collectInterfaceStrings || this.languages.isEmpty()) {
            return false;
        }
        if (this.collectModelStrings && this.languages.stream().noneMatch(l -> l.getOption() == TranslationOption.MODEL_AND_INTERFACE)) {
            return false;
        }
        return this.storageId != null;
    }

    @Override
    public boolean collectStrings(IProgressMonitor monitor) {
        if (!this.checkSettings()) {
            return false;
        }
        ICollectingParameters parameters = this.createCollectingParameters();
        String beforeOperationTaskName = MessageFormat.format(Messages.ProjectGenerateTranslationStrings_CollectingStringsFrom, this.getProject().getName());
        TempFileFeatureCollection collectedValues = this.getCollectedValues();
        ProjectMultiThreadCollectingOperation operation = ProjectMultiThreadCollectingOperation.Builder.newBuilder().project(this.getProject()).collectingService(this.collectingService).beforeOperationTaskName(beforeOperationTaskName).threadNamePrefix("Project-string-generator-(" + this.getProject().getName() + ")-").beforeOperationRun(collectedValues::clear).parameters(parameters).build();
        BiConsumer<Object, FeatureValue> action = (obj, value) -> {
            boolean bl = collectedValues.add(value);
        };
        operation.process(action, monitor);
        if (monitor.isCanceled()) {
            return false;
        }
        if (!parameters.getErrors().isEmpty()) {
            this.getErrors().addAll(parameters.getErrors());
        }
        boolean fillupResult = this.fillUpCollectedValues(monitor);
        return fillupResult;
    }

    @Override
    public void saveCollectedStrings(IProgressMonitor monitor) {
        if (!this.checkSettings()) {
            return;
        }
        ITranslationStorageProvider provider = this.storageManager.getStorageProvider(this.getStorageId());
        if (provider == null || !provider.isActive()) {
            return;
        }
        ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.getProject(), this.getStorageId());
        if (storage == null || storage.isReadOnly()) {
            return;
        }
        long millis = System.currentTimeMillis();
        if (CorePlugin.getDefault().isDebugging()) {
            CorePlugin.log(CorePlugin.createWarningStatus("[saveCollectedStrings] Begin loop over collected values."));
        }
        storage.beginBatchUpdate();
        try {
            for (FeatureValue featureValue : this.getCollectedValues()) {
                if (monitor.isCanceled()) {
                    return;
                }
                Map<String, String> featureValueStrings = featureValue.getLocalStrings();
                for (TranslateLanguage language : this.getLanguages()) {
                    if (!TranslationUtils.isValidFeatureForLanguage(featureValue.getContextKey().getFeatureSettings(), language)) continue;
                    String languageCode = language.getLanguageCode();
                    String translation = featureValueStrings.get(languageCode);
                    if (StringUtils.isNullOrEmpty(translation)) {
                        translation = "";
                    }
                    try {
                        storage.setTranslation(featureValue, language, translation, true);
                    }
                    catch (ModelValueAlreadyInUseException e) {
                        if (this.canProcess()) continue;
                        CorePlugin.logError(e);
                        throw e;
                    }
                }
                monitor.worked(1);
            }
        }
        finally {
            storage.endBatchUpdate();
            if (CorePlugin.getDefault().isDebugging()) {
                CorePlugin.log(CorePlugin.createWarningStatus("[saveCollectedStrings] End loop over collected values. Time = " + (System.currentTimeMillis() - millis)));
            }
        }
        monitor.done();
    }

    @Override
    public void dispose() {
        if (this.tempValuesStorage != null) {
            this.tempValuesStorage.dispose();
            this.tempValuesStorage = null;
        }
    }

    protected boolean collectStrings(TranslationSource object, IProgressMonitor monitor) {
        ICollectingParameters parameters = this.createCollectingParameters();
        monitor.beginTask(MessageFormat.format(Messages.ProjectGenerateTranslationStrings_CollectingStringsFrom, object.getId()), -1);
        TempFileFeatureCollection collectedValues = this.getCollectedValues();
        long collectMillis = System.currentTimeMillis();
        BiConsumer<Object, FeatureValue> filteringAction = (sourceObject, feature) -> {
            for (CollectingFilterParticipant filter : this.collectingServiceRegistry.allFilterParticipants()) {
                if (monitor.isCanceled()) {
                    return;
                }
                if (filter.needCollect(object, (FeatureValue)feature, parameters.getFilterParameters(), monitor)) continue;
                return;
            }
            collectedValues.add(feature);
        };
        this.collectingService.forEachCollected(object, parameters, monitor, filteringAction);
        if (CorePlugin.getDefault().isDebugging()) {
            CorePlugin.log(CorePlugin.createWarningStatus("[collectString] Foreach time: " + (System.currentTimeMillis() - collectMillis)));
        }
        if (!parameters.getErrors().isEmpty()) {
            this.getErrors().addAll(parameters.getErrors());
        }
        long millis = System.currentTimeMillis();
        boolean fillupResult = this.fillUpCollectedValues(monitor);
        if (CorePlugin.getDefault().isDebugging()) {
            CorePlugin.log(CorePlugin.createWarningStatus("[collectString] fillUpCollectedValues time: " + (System.currentTimeMillis() - millis)));
        }
        return fillupResult;
    }

    protected ICollectingParameters createCollectingParameters() {
        HashSet translateLanguages = Sets.newHashSet(this.languages);
        CollectingParameters.Builder builder = CollectingParameters.builder();
        builder.collectChildObjects().enableCache().collectSubResources().setLanguages(translateLanguages).setFilterParameters(this.filterParameters).setCollectModelType(this.getCollectModelType());
        if (this.isCollectModelStrings()) {
            builder.collectModel();
        }
        if (this.isCollectInterfaceStrings()) {
            builder.collectInterface();
        }
        if (this.isContinueAfterFirstError()) {
            builder.continueAfterFirstError();
        }
        if (this.useCache) {
            builder.enableCache();
        } else {
            builder.disableCache();
        }
        return builder.build();
    }

    protected boolean fillUpCollectedValues(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.getProject(), this.getStorageId());
        if (storage == null) {
            InvalidStorageIdException e = new InvalidStorageIdException(MessageFormat.format(Messages.ProjectGenerateTranslationStrings_UnknownStorageId, this.getStorageId()));
            this.getErrors().add(e);
            return false;
        }
        int total = this.getCollectedValues().size();
        SubMonitor iterSubMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)total);
        iterSubMonitor.setTaskName(Messages.ProjectGenerateTranslationStrings_GettingTranslationFor);
        ExecutorService pool = Executors.newFixedThreadPool(TranslationUtils.computePoolSize(false));
        Iterator<Long> iterator = this.getCollectedValues().resourceIterator();
        while (iterator.hasNext()) {
            Long id = iterator.next();
            pool.submit(() -> {
                if (iterSubMonitor.isCanceled()) {
                    return;
                }
                this.processResourceBucket(id, storage, iterSubMonitor);
            });
            if (this.canProcess()) continue;
            if (!pool.isTerminated()) {
                pool.shutdownNow();
            }
            return false;
        }
        pool.shutdown();
        boolean terminated = false;
        do {
            try {
                terminated = pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                CorePlugin.logError(e);
                break;
            }
        } while (!terminated && !monitor.isCanceled());
        if (monitor.isCanceled()) {
            if (!pool.isTerminated()) {
                pool.shutdownNow();
            }
            return false;
        }
        iterSubMonitor.done();
        return true;
    }

    private void processResourceBucket(Long id, ITranslationStorageProvider.Storage storage, SubMonitor iterSubMonitor) {
        HashSet<FeatureValue> toRemove = new HashSet<FeatureValue>();
        Collection<FeatureValue> bucket = this.getCollectedValues().getResourceBucket(id);
        Iterator<FeatureValue> iterator2 = bucket.iterator();
        while (iterator2.hasNext()) {
            if (!this.canProcess()) {
                return;
            }
            FeatureValue featureValue = iterator2.next();
            if (featureValue == null || !this.fillUpOrRemoveFeatureValue(featureValue, storage, (IProgressMonitor)iterSubMonitor.newChild(1))) continue;
            toRemove.add(featureValue);
        }
        this.getCollectedValues().putResourceBucket(id, bucket);
        for (FeatureValue featureValue : toRemove) {
            if (iterSubMonitor.isCanceled()) {
                return;
            }
            this.getCollectedValues().remove(featureValue);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean fillUpOrRemoveFeatureValue(final FeatureValue featureValue, final ITranslationStorageProvider.Storage storage, IProgressMonitor monitor) {
        validator = this.registry.getValidator(featureValue.getContextKey().getFeatureSettings());
        shouldRemoveValueIfAllExist = this.getFillUpType().equals((Object)FillUpType.NOT_FILLUP) == false;
        allLanguagesHaveTranslation = true;
        for (final TranslateLanguage language : this.languages) {
            if (monitor.isCanceled()) {
                return false;
            }
            if (!TranslationUtils.isValidFeatureForLanguage(featureValue.getContextKey().getFeatureSettings(), language)) continue;
            languageCode = language.getLanguageCode();
            context = new FeatureValueValidator.ValidationContext(){

                @Override
                public IProject getProject() {
                    return ProjectGenerateTranslationStrings.this.getProject();
                }

                @Override
                public ITranslationStorageProvider.Storage getStorage() {
                    return storage;
                }

                @Override
                public TranslateLanguage getLanguage() {
                    return language;
                }

                @Override
                public TranslationKey getTranslationKey() {
                    return featureValue.getContextKey();
                }
            };
            value = featureValue.getLocalStrings().get(languageCode);
            if (StringUtils.isNullOrEmpty(value)) {
                translation = storage.getTranslation(featureValue, language);
                if (this.checkTranslationsInAnyAvailableStorage && StringUtils.isNullOrEmpty(translation) && !this.getFillUpType().equals((Object)FillUpType.NOT_FILLUP) && StringUtils.isNotEmpty(other = this.getReader().getStoredTranslation(featureValue.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]))) continue;
                if (StringUtils.isNotEmpty(translation)) {
                    value = translation;
                } else if (this.getFillUpType().equals((Object)FillUpType.FROM_SOURCE_LANGUAGE)) {
                    allLanguagesHaveTranslation = false;
                    value = featureValue.getContextKey().getValue();
                } else if (this.getFillUpType().equals((Object)FillUpType.FROM_PROVIDER)) {
                    allLanguagesHaveTranslation = false;
                    query = new ContextTranslationQuery.Builder(featureValue.getContextKey().getValue(), languageCode).featureValue(featureValue).projectName(this.getProject().getName()).sourceLanguage(this.translatingProject.getDefaultLanguage().getLanguageCode()).isProcessing(featureValue.getContextKey().getFeatureSettings().isCamelCase()).storageId(this.storageId).build();
                    try {
                        value = this.translateByProvider(query).orElse("");
                    }
                    catch (TranslationServiceException exc) {
                        this.getErrors().add(exc);
                        if (this.canProcess()) ** GOTO lbl40
                        return false;
                    }
                }
            } else if (!this.getFillUpType().equals((Object)FillUpType.NOT_FILLUP) && StringUtils.isNullOrEmpty(translation = storage.getTranslation(featureValue, language))) {
                if (this.checkTranslationsInAnyAvailableStorage) {
                    other = this.getReader().getStoredTranslation(featureValue.getContextKey(), language, new ITranslationStorageProvider.Storage.Type[0]);
                    if (StringUtils.isNullOrEmpty(other)) {
                        allLanguagesHaveTranslation = false;
                    }
                } else {
                    allLanguagesHaveTranslation = false;
                }
            }
lbl40:
            // 9 sources

            value = validator.preprocessValue(value, context);
            if (!StringUtils.isNotEmpty(value) || !validator.isValid(value, context).isOK()) continue;
            featureValue.getLocalStrings().put(languageCode, value);
        }
        return allLanguagesHaveTranslation != false && shouldRemoveValueIfAllExist != false;
    }

    private Optional<String> translateByProvider(IContextTranslationQuery query) {
        String providerId = this.getTranslationProviderId();
        return this.translationManager.translate(query, providerId, (IProgressMonitor)new NullProgressMonitor()).stream().findFirst();
    }

    private boolean checkLanguagesByTranslationService() {
        HashSet<String> supportedLangs;
        try {
            supportedLangs = new HashSet<String>(this.translationManager.getSupportedLanguages(this.translationProviderId, (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (TranslationServiceException exc) {
            this.getErrors().add(exc);
            return false;
        }
        List unsupportedLangs = this.languages.stream().filter(lang -> !supportedLangs.contains(lang.getLanguageCode())).map(TranslateLanguage::getName).collect(Collectors.toList());
        if (!unsupportedLangs.isEmpty()) {
            InvalidLanguagesException e = new InvalidLanguagesException(MessageFormat.format(Messages.ProjectGenerateTranslationStrings_ErrorDialogStatusMsgWhileLangsChecking, unsupportedLangs.toString()));
            this.getErrors().add(e);
            return false;
        }
        return true;
    }

    @Override
    public void collectAndSaveStrings(IProgressMonitor monitor) {
        monitor.beginTask(Messages.ProjectGenerateTranslationStrings_Collecting_source_strings, 1);
        if (this.collectStrings(monitor)) {
            monitor.beginTask(Messages.ProjectGenerateTranslationStrings_Saving_translations, this.getCollectedValues().size());
            this.saveCollectedStrings((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)this.getCollectedValues().size()));
        }
    }

    @Override
    public void addOrUpdateValue(FeatureValue value) {
        this.getCollectedValues().updateValue(value);
    }

    @Override
    public void setFilterParameters(Map<String, ? extends Object> filterParameters) {
        this.filterParameters = filterParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProjectTranslationReader getReader() {
        if (this.projectTranslationReader == null) {
            ProjectGenerateTranslationStrings projectGenerateTranslationStrings = this;
            synchronized (projectGenerateTranslationStrings) {
                if (this.projectTranslationReader != null) {
                    return this.projectTranslationReader;
                }
                this.projectTranslationReader = this.storageManager.getTranslationReader(this.getProject());
            }
        }
        return this.projectTranslationReader;
    }

    @Override
    public void disableCache() {
        this.useCache = false;
    }

    @Override
    public void enableCache() {
        this.useCache = true;
    }
}

