/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.generatestring;

import com.e1c.langtool.TranslationSource;
import com.e1c.langtool.collector.CollectingParameters;
import com.e1c.langtool.collector.ICollectingParameters;
import com.e1c.langtool.generatestring.ProjectGenerateTranslationStrings;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectObjectsGenerateTranslationStrings
extends ProjectGenerateTranslationStrings {
    private Collection<TranslationSource> projectObjects;

    public synchronized Collection<TranslationSource> getProjectObjects() {
        return this.projectObjects;
    }

    public synchronized void setProjectObjects(Collection<TranslationSource> projectObjects) {
        this.projectObjects = projectObjects;
    }

    @Override
    public boolean collectStrings(IProgressMonitor monitor) {
        if (!this.checkSettings()) {
            return false;
        }
        this.getCollectedValues().clear();
        if (this.projectObjects.size() == 1) {
            return this.collectStrings(this.projectObjects.iterator().next(), monitor);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.projectObjects.size());
        for (TranslationSource object : this.projectObjects) {
            if (this.collectStrings(object, (IProgressMonitor)subMonitor.newChild(1))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected ICollectingParameters createCollectingParameters() {
        HashSet translateLanguages = Sets.newHashSet(this.getLanguages());
        CollectingParameters.Builder builder = CollectingParameters.builder();
        builder.collectChildObjects().collectSubResources().setLanguages(translateLanguages).setFilterParameters(this.filterParameters).setCollectModelType(this.getCollectModelType());
        if (this.isCollectModelStrings()) {
            builder.collectModel();
        }
        if (this.isCollectInterfaceStrings()) {
            builder.collectInterface();
        }
        if (this.isContinueAfterFirstError()) {
            builder.continueAfterFirstError();
        }
        return builder.build();
    }
}

