/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ignore;

import com.e1c.langtool.ignore.IgnoreTranslationChecker;
import com.e1c.langtool.ignore.TransIgnoreFile;
import com.e1c.langtool.ignore.TransIgnoreFileUtil;
import com.e1c.langtool.internal.CorePlugin;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractResourceIgnoreTranslationChecker
implements IgnoreTranslationChecker {
    public static final String TRANSIGNORE_FILE_NAME = ".transignore";
    protected Map<IProject, ProjectCache> projects = Maps.newConcurrentMap();
    private IResourceChangeListener resourceListener = new ReseourceChagneListener();

    protected Map<IPath, Optional<TransIgnoreFile>> getProjectCache(IProject project, IProgressMonitor monitor) {
        Map<IPath, Optional<TransIgnoreFile>> loadedCache = this.projects.computeIfAbsent(project, p -> new ProjectCache((IProject)p)).getCache();
        return loadedCache;
    }

    protected TransIgnoreFile createAndLoad(IFile file) {
        TransIgnoreFile transignore = null;
        try {
            transignore = TransIgnoreFileUtil.createAndLoad(file);
        }
        catch (IOException | CoreException e) {
            CorePlugin.logError(e);
            return null;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        return transignore;
    }

    public class ProjectCache {
        private final IProject project;
        private final Map<IPath, Optional<TransIgnoreFile>> loadedCache = Maps.newConcurrentMap();

        public ProjectCache(IProject project) {
            this.project = project;
        }

        public IProject getProject() {
            return this.project;
        }

        public Map<IPath, Optional<TransIgnoreFile>> getCache() {
            return this.loadedCache;
        }

        public boolean isEmpty() {
            return this.loadedCache.isEmpty() || !this.loadedCache.values().stream().anyMatch(f -> f.isPresent());
        }
    }

    class ReseourceChagneListener
    implements IResourceChangeListener {
        ReseourceChagneListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (AbstractResourceIgnoreTranslationChecker.this.projects.isEmpty()) {
                return;
            }
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IResource res = event.getResource();
                    if (!(res instanceof IProject)) break;
                    AbstractResourceIgnoreTranslationChecker.this.projects.remove(res);
                    break;
                }
                case 1: {
                    Iterator<Map.Entry<IProject, ProjectCache>> iterator = AbstractResourceIgnoreTranslationChecker.this.projects.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<IProject, ProjectCache> entry = iterator.next();
                        IPath path = entry.getKey().getFullPath();
                        HashSet pathToRemove = Sets.newHashSet();
                        for (Map.Entry<IPath, Optional<TransIgnoreFile>> fileEntry : entry.getValue().getCache().entrySet()) {
                            if (!fileEntry.getValue().isPresent()) continue;
                            IPath filePath = fileEntry.getValue().get().getPathPreffix().append(AbstractResourceIgnoreTranslationChecker.TRANSIGNORE_FILE_NAME);
                            IResourceDelta delta = event.getDelta().findMember(path.append(filePath));
                            if (delta == null) continue;
                            if (delta.getKind() == 2 || delta.getKind() == 1) {
                                pathToRemove.add(fileEntry.getKey());
                                continue;
                            }
                            if (delta.getKind() != 4 || (delta.getFlags() & 0x40100) == 0) continue;
                            pathToRemove.add(fileEntry.getKey());
                        }
                        for (IPath rem : pathToRemove) {
                            Iterator<Map.Entry<IPath, Optional<TransIgnoreFile>>> fileIterator = entry.getValue().getCache().entrySet().iterator();
                            while (fileIterator.hasNext()) {
                                Map.Entry<IPath, Optional<TransIgnoreFile>> fileEntry = fileIterator.next();
                                if (!rem.isPrefixOf(fileEntry.getKey())) continue;
                                fileIterator.remove();
                            }
                        }
                        if (!entry.getValue().getCache().isEmpty()) continue;
                        iterator.remove();
                    }
                    break;
                }
            }
            if (AbstractResourceIgnoreTranslationChecker.this.projects.entrySet().stream().allMatch(e -> ((ProjectCache)e.getValue()).isEmpty())) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(AbstractResourceIgnoreTranslationChecker.this.resourceListener);
            }
        }
    }
}

