/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.ignore;

import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TransIgnoreFile {
    private Queue<Line> lines = new ConcurrentLinkedQueue<Line>();
    private IPath pathPreffix;
    private volatile Map<IPath, Boolean> ignoreAllChildren;
    private volatile Boolean ignoreAll;

    public TransIgnoreFile(IPath pathPreffix) {
        Assert.isNotNull((Object)pathPreffix);
        this.pathPreffix = pathPreffix;
    }

    public IPath getPathPreffix() {
        return this.pathPreffix;
    }

    public Iterator<Line> getLines() {
        return this.lines.iterator();
    }

    public void addLine(Line line) {
        this.lines.add(line);
        this.ignoreAllChildren = null;
        this.ignoreAll = null;
    }

    public void removeLine(Line line) {
        this.lines.remove(line);
        this.ignoreAllChildren = null;
        this.ignoreAll = null;
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public void clear() {
        this.lines.clear();
        this.ignoreAllChildren = null;
        this.ignoreAll = null;
    }

    public int size() {
        return this.lines.size();
    }

    public List<Rule> getRules() {
        return this.lines.stream().filter(Rule.class::isInstance).map(Rule.class::cast).collect(Collectors.toList());
    }

    public boolean ignoreAll() {
        if (this.ignoreAll == null) {
            this.ignoreAll = this.lines.stream().filter(Rule.class::isInstance).map(Rule.class::cast).anyMatch(r -> r.anyResource() && r.anyFeatureKey());
        }
        return this.ignoreAll;
    }

    /*
     * Unable to fully structure code
     */
    public boolean ignoreAllChildren(IPath path) {
        if (!this.pathPreffix.isPrefixOf(path) || path == null || path.isEmpty()) {
            return false;
        }
        if (this.ignoreAll()) {
            return true;
        }
        resource = path.removeFirstSegments(this.pathPreffix.segmentCount());
        if (resource.isEmpty()) {
            return false;
        }
        if (this.getIgnoreAllChilren().isEmpty()) {
            return false;
        }
        if (!this.getIgnoreAllChilren().containsKey(resource)) ** GOTO lbl16
        return true;
lbl-1000:
        // 1 sources

        {
            resource = resource.removeLastSegments(1);
            wild = this.getIgnoreAllChilren().get(resource);
            if (wild == null || !wild.booleanValue()) continue;
            return true;
lbl16:
            // 2 sources

            ** while (!resource.isEmpty())
        }
lbl17:
        // 1 sources

        return false;
    }

    public boolean hasRules(IPath path) {
        if (!this.pathPreffix.isPrefixOf(path)) {
            return false;
        }
        IPath resource = path.removeFirstSegments(this.pathPreffix.segmentCount());
        if (resource == null || resource.isEmpty()) {
            return false;
        }
        String res = resource.toString();
        return this.lines.stream().filter(Rule.class::isInstance).map(l -> (Rule)l).anyMatch(r -> r.validForResource(res));
    }

    public boolean ignore(IPath path, FeatureKey featureKey) {
        if (!this.pathPreffix.isPrefixOf(path)) {
            return false;
        }
        IPath resource = path.removeFirstSegments(this.pathPreffix.segmentCount());
        if (resource == null || resource.isEmpty()) {
            return false;
        }
        String res = resource.toString();
        return this.lines.stream().filter(Rule.class::isInstance).map(l -> (Rule)l).anyMatch(r -> r.validForResource(res) && r.validForFeatureKey(featureKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IPath, Boolean> getIgnoreAllChilren() {
        if (this.ignoreAllChildren == null) {
            TransIgnoreFile transIgnoreFile = this;
            synchronized (transIgnoreFile) {
                if (this.ignoreAllChildren != null) {
                    return this.ignoreAllChildren;
                }
                HashMap<Path, Boolean> ignore = new HashMap<Path, Boolean>();
                for (Rule rule : this.getRules()) {
                    if (!rule.anyFeatureKey() || rule.anyResource()) continue;
                    String[] segments = rule.getResourceSegments();
                    boolean allchild = StringUtils.isNullOrEmpty(segments[segments.length - 1]);
                    String path = String.join((CharSequence)"/", rule.getResourceSegments());
                    if (!Path.isValidPosixPath((String)path)) continue;
                    ignore.put(Path.forPosix((String)path), allchild);
                }
                this.ignoreAllChildren = ImmutableMap.copyOf(ignore);
            }
        }
        return this.ignoreAllChildren;
    }

    public static class CommentLine
    extends Line {
        public CommentLine(String string) {
            super(string);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append(":");
            sb.append(" ");
            if (!this.isEmpty()) {
                sb.append(" ");
                sb.append(this.getSring());
            }
            return sb.toString();
        }
    }

    public static class Line {
        protected static final String SPLITTER = ":";
        private final String string;

        public Line() {
            this.string = "";
        }

        protected Line(String string) {
            Assert.isNotNull((Object)string);
            this.string = string;
        }

        public String getSring() {
            return this.string;
        }

        public boolean isEmpty() {
            return StringUtils.isNullOrEmpty(this.string);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append(SPLITTER);
            sb.append(" ");
            sb.append(this.string == "" ? "empty" : this.string);
            return sb.toString();
        }
    }

    public static class Rule
    extends Line {
        private static final Pattern WILDCARD_PATTERN = Pattern.compile("^\\*|(?<=[^\\\\])\\*");
        private static final Pattern SPLITTER_PATTERN = Pattern.compile("^(.*?)(?<=[^\\\\]):(.*)$");
        private final String resource;
        private final String featureKey;
        private String[] resourceSegments;
        private String[] featureKeySegments;

        public static Rule fromString(String input) {
            Matcher matcher = SPLITTER_PATTERN.matcher(input);
            String resource = null;
            String featureKey = null;
            if (matcher.matches()) {
                resource = matcher.group(1);
                featureKey = matcher.group(2);
            } else {
                resource = input;
            }
            return new Rule(input, resource, featureKey);
        }

        public Rule(String string, String resource, String featureKey) {
            super(string);
            this.resource = resource;
            this.featureKey = featureKey;
        }

        public Rule(String resource, String featureKey) {
            super(resource + ":" + featureKey);
            this.resource = resource;
            this.featureKey = featureKey;
        }

        public String getResource() {
            return this.resource;
        }

        public String[] getResourceSegments() {
            if (this.resourceSegments == null) {
                if (this.getResource() != null) {
                    String[] segments = WILDCARD_PATTERN.split(this.getResource());
                    if (this.getResource().endsWith("*") && !this.getResource().endsWith("\\*")) {
                        String[] newSegments = new String[segments.length + 1];
                        System.arraycopy(segments, 0, newSegments, 0, segments.length);
                        newSegments[segments.length] = "";
                        segments = newSegments;
                    }
                    this.resourceSegments = segments;
                } else {
                    this.resourceSegments = new String[0];
                }
            }
            return this.resourceSegments;
        }

        public boolean anyResource() {
            return this.getResourceSegments().length == 0 || this.getResourceSegments().length == 1 && StringUtils.isNullOrEmpty(this.getResourceSegments()[0]);
        }

        public boolean validForResource(String res) {
            if (StringUtils.isNullOrEmpty(res)) {
                return false;
            }
            if (this.getResource() != null && this.getResource().equals(res)) {
                return true;
            }
            return this.validForSegments(this.getResourceSegments(), res);
        }

        public String getFeatureKey() {
            return this.featureKey;
        }

        public String[] getFeatureKeySegments() {
            if (this.featureKeySegments == null) {
                if (this.getFeatureKey() != null) {
                    String[] segments = WILDCARD_PATTERN.split(this.getFeatureKey());
                    if (this.getFeatureKey().endsWith("*") && !this.getFeatureKey().endsWith("\\*")) {
                        String[] newSegments = new String[segments.length + 1];
                        System.arraycopy(segments, 0, newSegments, 0, segments.length);
                        newSegments[segments.length] = "";
                        segments = newSegments;
                    }
                    this.featureKeySegments = segments;
                } else {
                    this.featureKeySegments = new String[0];
                }
            }
            return this.featureKeySegments;
        }

        public boolean anyFeatureKey() {
            return this.getFeatureKeySegments().length == 0 || this.getFeatureKeySegments().length == 1 && StringUtils.isNullOrEmpty(this.getFeatureKeySegments()[0]);
        }

        public boolean validForFeatureKey(FeatureKey key) {
            if (key == null || key.isEmpty()) {
                return false;
            }
            String fk = key.toString();
            if (this.getFeatureKey() != null && this.getFeatureKey().equals(fk)) {
                return true;
            }
            return this.validForSegments(this.getFeatureKeySegments(), fk);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean validForSegments(String[] segments, String res) {
            String current = res;
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i];
                if (i == 0 && !segment.isEmpty()) {
                    if (!current.startsWith(segment)) return false;
                    current = current.substring(segment.length());
                } else {
                    if (i == segments.length - 1 && segment.isEmpty()) {
                        return true;
                    }
                    if (i == segments.length - 1 && !segment.isEmpty()) {
                        return current.endsWith(segment);
                    }
                    if (!segment.isEmpty()) {
                        int offset = current.indexOf(segment);
                        if (offset == -1) {
                            return false;
                        }
                        current = current.substring(offset + 1);
                    }
                }
                ++i;
            }
            return current.isEmpty();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getName());
            sb.append(":");
            sb.append(" ");
            if (this.getResource() != null) {
                sb.append(this.getResource());
            }
            if (this.getFeatureKey() != null) {
                sb.append(":");
                sb.append(this.getFeatureKey());
            }
            return sb.toString();
        }
    }
}

