/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.external;

import com.e1c.langtool.external.ExternalTranslationProviderAttrs;
import com.e1c.langtool.external.IExternalTranslationProvider;
import com.e1c.langtool.external.ITranslationProviderRegistry;
import com.e1c.langtool.internal.CorePlugin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class TranslationProviderRegistry
implements ITranslationProviderRegistry {
    private volatile Map<String, ExternalTranslationProviderAttrs> providerAttrs;
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ORDER = "order";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CACHEABLE = "cacheable";
    private static final String ATTR_TEXT_PROCESSABLE = "text_processable";

    @Override
    public IExternalTranslationProvider getExternalTranslationProvider(String id) {
        ExternalTranslationProviderAttrs attrs;
        if (this.providerAttrs == null) {
            this.getAllExternalTranslationProviders();
        }
        if ((attrs = this.providerAttrs.get(id)) != null) {
            return attrs.getProvider();
        }
        return null;
    }

    @Override
    public ExternalTranslationProviderAttrs getExternalTranslationProviderAttrs(String id) {
        if (this.providerAttrs == null) {
            this.getAllExternalTranslationProviders();
        }
        return this.providerAttrs.get(id);
    }

    @Override
    public List<String> getExternalTranslationProvidersIds(Predicate<ExternalTranslationProviderAttrs> predicate) {
        if (this.providerAttrs == null) {
            this.getAllExternalTranslationProviders();
        }
        ArrayList<ExternalTranslationProviderAttrs> configs = new ArrayList<ExternalTranslationProviderAttrs>(this.providerAttrs.values());
        configs.sort(new Comparator<ExternalTranslationProviderAttrs>(){

            @Override
            public int compare(ExternalTranslationProviderAttrs c1, ExternalTranslationProviderAttrs c2) {
                if (c1.getOrder() * c2.getOrder() < 0) {
                    return c1.getOrder() > c2.getOrder() ? -1 : 1;
                }
                return c1.getOrder() - c2.getOrder();
            }
        });
        ArrayList<String> providers = new ArrayList<String>();
        for (ExternalTranslationProviderAttrs config : configs) {
            if (!predicate.test(config)) continue;
            providers.add(config.getId());
        }
        return providers;
    }

    @Override
    public List<String> getExternalTranslationProvidersIds() {
        return this.getExternalTranslationProvidersIds(predicate -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IExternalTranslationProvider> getAllExternalTranslationProviders() {
        if (this.providerAttrs == null) {
            TranslationProviderRegistry translationProviderRegistry = this;
            synchronized (translationProviderRegistry) {
                if (this.providerAttrs == null) {
                    this.providerAttrs = this.loadExternalTranslationProviders();
                }
            }
        }
        return this.extractProvidersFromAttrsMap();
    }

    private Map<String, IExternalTranslationProvider> extractProvidersFromAttrsMap() {
        HashMap<String, IExternalTranslationProvider> res = new HashMap<String, IExternalTranslationProvider>();
        for (Map.Entry<String, ExternalTranslationProviderAttrs> entry : this.providerAttrs.entrySet()) {
            res.put(entry.getKey(), entry.getValue().getProvider());
        }
        return res;
    }

    private Map<String, ExternalTranslationProviderAttrs> loadExternalTranslationProviders() {
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.externalTranslationProvider");
        HashMap<String, ExternalTranslationProviderAttrs> providers = new HashMap<String, ExternalTranslationProviderAttrs>();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement configurationElement = configurationElements[i];
            String id = configurationElement.getAttribute(ATTR_ID);
            String name = configurationElement.getAttribute(ATTR_NAME);
            boolean isCacheable = Boolean.parseBoolean(configurationElement.getAttribute(ATTR_CACHEABLE));
            boolean textProcessable = Boolean.parseBoolean(configurationElement.getAttribute(ATTR_TEXT_PROCESSABLE));
            int order = -1;
            try {
                order = Integer.parseInt(configurationElement.getAttribute(ATTR_ORDER));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                IExternalTranslationProvider provider = (IExternalTranslationProvider)configurationElement.createExecutableExtension(ATTR_CLASS);
                ExternalTranslationProviderAttrs attrs = new ExternalTranslationProviderAttrs.Builder(id, name, provider).cacheable(isCacheable).order(order).textProcessable(textProcessable).build();
                providers.put(id, attrs);
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
            }
            ++i;
        }
        return providers;
    }
}

