/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.platform;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.platform.NonTranslatingProject;
import com.e1c.langtool.internal.platform.TranslateProjectFactoryService;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.platform.TranslatingProjectChangeEvent;
import com.e1c.langtool.platform.TranslatingProjectChangeListener;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TranslatingProjectManager
implements ITranslatingProjectManager {
    @Inject
    private TranslateProjectFactoryService factoryService;
    private final ConcurrentMap<IProject, ITranslatingProject> projects = new ConcurrentHashMap<IProject, ITranslatingProject>();
    private final Map<IProject, IProject> externalToTranslatingProjects = new ConcurrentHashMap<IProject, IProject>();
    private final Map<ProjectLocale, IProject> translatingToExternalProjects = new ConcurrentHashMap<ProjectLocale, IProject>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final IResourceChangeListener projectChangeListener = new ProjectChangeListener();
    private final ListenerList<TranslatingProjectChangeListener> postListeners = new ListenerList();

    public void activate() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangeListener, 7);
    }

    public void deactivate() {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangeListener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.postListeners.clear();
    }

    @Override
    public void register(ITranslatingProject translatingProject, IProject externalProject, Collection<TranslateLanguage> languages) {
        if (!translatingProject.isTranslating() && !languages.isEmpty() && translatingProject.getProject().isAccessible()) {
            IProject project = translatingProject.getProject();
            List<TranslateLanguage> langs = List.copyOf(languages);
            Job job = Job.create((String)"Register project as translating", m -> this.register(project, langs));
            job.setSystem(true);
            job.schedule();
        }
        ITranslatingProject removed = null;
        this.lock.writeLock().lock();
        try {
            Set<ProjectLocale> keys = languages.stream().map(lang -> new ProjectLocale(translatingProject.getProject().getName(), lang.getLanguageCode())).collect(Collectors.toSet());
            boolean needUpdateTranslating = false;
            Iterator<Map.Entry<ProjectLocale, IProject>> iterator = this.translatingToExternalProjects.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ProjectLocale, IProject> entry = iterator.next();
                if (keys.contains(entry.getKey()) || !entry.getValue().equals((Object)externalProject)) continue;
                iterator.remove();
                needUpdateTranslating = true;
            }
            keys.forEach(key -> {
                IProject iProject2 = this.translatingToExternalProjects.put((ProjectLocale)key, externalProject);
            });
            this.externalToTranslatingProjects.put(externalProject, translatingProject.getProject());
            if (needUpdateTranslating || !keys.isEmpty()) {
                removed = (ITranslatingProject)this.projects.remove(translatingProject.getProject());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (removed != null) {
            this.fireChanged(new TranslatingProjectChangeEvent(removed, TranslatingProjectChangeEvent.EventType.REGISTERED));
        }
    }

    @Override
    public @Nullable ITranslatingProject register(@NonNull IProject project, @NonNull List<TranslateLanguage> languages) {
        IProjectDescription description;
        Assert.isNotNull((Object)project, (String)"Project cannot be null");
        Assert.isLegal((!languages.isEmpty() ? 1 : 0) != 0, (String)"Languages cannot be null");
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
            return null;
        }
        String[] natures = description.getNatureIds();
        boolean hasNature = false;
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature != null && nature.equals("com.e1c.langtool.TranslatingNature")) {
                hasNature = true;
                break;
            }
            ++n2;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!hasNature) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "com.e1c.langtool.TranslatingNature";
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateNatureSet(newNatures);
            if (status.getCode() == 0) {
                description.setNatureIds(newNatures);
                try {
                    project.setDescription(description, (IProgressMonitor)monitor);
                    this.projects.remove(project);
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                    return null;
                }
            }
        }
        @NonNull ITranslatingProject translatingProject = this.getProject(project);
        TranslatingProjectChangeEvent event = new TranslatingProjectChangeEvent(translatingProject, TranslatingProjectChangeEvent.EventType.REGISTERED);
        this.fireChanged(event);
        return translatingProject;
    }

    @Override
    public void deregister(@NonNull IProject project) {
        IProjectDescription description;
        @NonNull TranslatingProjectChangeEvent event = new TranslatingProjectChangeEvent(this.getProject(project), TranslatingProjectChangeEvent.EventType.DEREGISTERED);
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
            this.fireChanged(event);
            return;
        }
        String[] natures = description.getNatureIds();
        boolean hasNature = false;
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature != null && nature.equals("com.e1c.langtool.TranslatingNature")) {
                hasNature = true;
                break;
            }
            ++n2;
        }
        if (!hasNature) {
            this.projects.remove(project);
            this.fireChanged(event);
            return;
        }
        String[] newNatures = new String[natures.length - 1];
        int j = 0;
        int i = 0;
        while (i < natures.length) {
            String nature = natures[i];
            if (!"com.e1c.langtool.TranslatingNature".equals(nature)) {
                newNatures[j] = nature;
                ++j;
            }
            ++i;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateNatureSet(newNatures);
        if (status.getCode() == 0) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            description.setNatureIds(newNatures);
            try {
                project.setDescription(description, (IProgressMonitor)monitor);
                this.projects.remove(project);
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
            }
            this.fireChanged(event);
        }
    }

    @Override
    public @NonNull ITranslatingProject getProject(@Nullable IProject project) {
        if (project == null) {
            return new NonTranslatingProject(project);
        }
        ITranslatingProject translatingProject = null;
        this.lock.readLock().lock();
        try {
            translatingProject = (ITranslatingProject)this.projects.get(project);
            if (translatingProject != null) {
                ITranslatingProject iTranslatingProject = translatingProject;
                return iTranslatingProject;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            translatingProject = (ITranslatingProject)this.projects.get(project);
            if (translatingProject != null) {
                ITranslatingProject iTranslatingProject = translatingProject;
                return iTranslatingProject;
            }
            if (project.isAccessible()) {
                translatingProject = this.factoryService.createTranslatingProject(project);
            }
            if (translatingProject == null) {
                translatingProject = new NonTranslatingProject(project);
            }
            this.projects.put(project, translatingProject);
            ITranslatingProject iTranslatingProject = translatingProject;
            return iTranslatingProject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public @NonNull ITranslatingProject getProject(@NonNull String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Assert.isLegal((boolean)root.getFullPath().isValidSegment(projectName), (String)"Project name is not valid name");
        IProject project = root.getProject(projectName);
        return this.getProject(project);
    }

    @Override
    public void addPostChangeListener(TranslatingProjectChangeListener listener) {
        this.postListeners.add((Object)listener);
    }

    @Override
    public void removePostChangeListener(TranslatingProjectChangeListener listener) {
        this.postListeners.remove((Object)listener);
    }

    @Override
    public @NonNull IProject getLanguageProject(@NonNull IProject project, @NonNull TranslateLanguage language) {
        return this.getLanguageProject(this.getProject(project), language);
    }

    @Override
    public @NonNull IProject getLanguageProject(@NonNull ITranslatingProject project, @NonNull TranslateLanguage language) {
        this.lock.readLock().lock();
        try {
            ProjectLocale key = new ProjectLocale(project.getProject().getName(), language.getLanguageCode());
            IProject external = this.translatingToExternalProjects.get(key);
            if (external == null) {
                external = project.getProject();
            }
            IProject iProject = external;
            return iProject;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<TranslateLanguage> getLanguagesForExternalProject(IProject externalProject) {
        ArrayList<TranslateLanguage> result = new ArrayList<TranslateLanguage>();
        IProject translatingProject = null;
        this.lock.readLock().lock();
        try {
            translatingProject = this.externalToTranslatingProjects.get(externalProject);
            if (translatingProject == null) {
                ArrayList<TranslateLanguage> arrayList = result;
                return arrayList;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        ITranslatingProject translating = this.getProject(translatingProject);
        this.lock.readLock().lock();
        try {
            String projectName = translatingProject.getName();
            for (TranslateLanguage language : translating.getInterfaceLanguages()) {
                ProjectLocale key = new ProjectLocale(projectName, language.getLanguageCode());
                IProject project = this.translatingToExternalProjects.get(key);
                if (!externalProject.equals((Object)project)) continue;
                result.add(language);
            }
            ArrayList<TranslateLanguage> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public @NonNull Optional<ITranslatingProject> getTranslatingForExternalProject(IProject externalProject) {
        IProject translating = null;
        this.lock.readLock().lock();
        try {
            translating = this.externalToTranslatingProjects.get(externalProject);
            if (translating == null) {
                Optional<ITranslatingProject> optional = Optional.empty();
                return optional;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Optional.ofNullable(this.getProject(translating));
    }

    @Override
    public Collection<IProject> getAllExternalProjects(ITranslatingProject translatingProject) {
        this.lock.readLock().lock();
        try {
            Collection collection = this.translatingToExternalProjects.entrySet().stream().filter(entry -> ((ProjectLocale)entry.getKey()).projectName.equals(translatingProject.getProject().getName())).map(Map.Entry::getValue).collect(Collectors.toSet());
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void fireChanged(TranslatingProjectChangeEvent event) {
        for (TranslatingProjectChangeListener l : this.postListeners) {
            try {
                SafeRunner.run(() -> l.changed(event));
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    private void removeProject(IProject project) {
        ITranslatingProject translating = null;
        this.lock.writeLock().lock();
        try {
            ITranslatingProject translating2;
            translating = (ITranslatingProject)this.projects.remove(project);
            String projectName = project.getName();
            Iterator<Map.Entry<ProjectLocale, IProject>> iterator = this.translatingToExternalProjects.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ProjectLocale, IProject> entry = iterator.next();
                if (!entry.getValue().equals((Object)project) && !entry.getKey().getProjectName().equals(projectName)) continue;
                iterator.remove();
            }
            IProject translatingProject = this.externalToTranslatingProjects.remove(project);
            if (!(translatingProject == null || (translating2 = (ITranslatingProject)this.projects.remove(translatingProject)) == null || translating != null && translating.isTranslating())) {
                translating = translating2;
            }
            Iterator<Map.Entry<IProject, IProject>> iterator2 = this.externalToTranslatingProjects.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<IProject, IProject> entry = iterator2.next();
                if (!entry.getValue().equals((Object)project)) continue;
                iterator2.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (translating != null) {
            TranslatingProjectChangeEvent changeEvent = new TranslatingProjectChangeEvent(translating, TranslatingProjectChangeEvent.EventType.DEREGISTERED);
            this.fireChanged(changeEvent);
        }
    }

    private class ProjectChangeListener
    implements IResourceChangeListener {
        private static final String PROJECT_FILENAME = ".project";

        private ProjectChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta;
            IResource res = event.getResource();
            if (event.getType() == 2 || event.getType() == 4) {
                if (res instanceof IProject) {
                    TranslatingProjectManager.this.removeProject((IProject)res);
                }
            } else if (event.getType() == 1 && (delta = event.getDelta()) != null) {
                Iterator iterator = TranslatingProjectManager.this.projects.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    IResourceDelta projectDelta = delta.findMember(((IProject)entry.getKey()).getFullPath().append(PROJECT_FILENAME));
                    if (projectDelta == null) continue;
                    TranslatingProjectChangeEvent changeEvent = new TranslatingProjectChangeEvent((ITranslatingProject)entry.getValue(), TranslatingProjectChangeEvent.EventType.CHANGED);
                    iterator.remove();
                    TranslatingProjectManager.this.fireChanged(changeEvent);
                }
            }
        }
    }

    private static final class ProjectLocale {
        private final String projectName;
        private final String locale;
        private final int hashCode;

        public ProjectLocale(String projectName, String locale) {
            this.projectName = projectName;
            this.locale = locale;
            this.hashCode = this.getHashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectLocale other = (ProjectLocale)obj;
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName));
        }

        public String getProjectName() {
            return this.projectName;
        }

        private int getHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
            return result;
        }
    }
}

