/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.settings;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.settings.CompositeValidator;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.settings.FeatureValueValidator;
import com.e1c.langtool.settings.ValidatorContributor;
import com.e1c.langtool.settings.ValidatorRegistry;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;

@Singleton
public class ValidatorRegistryImpl
implements ValidatorRegistry {
    private static final String ATT_CLASS = "class";
    private final Object lock = new Object();
    private volatile boolean initialized;
    private volatile Collection<ValidatorContributor> registry;

    @Override
    public @NonNull FeatureValueValidator getValidator(@NonNull FeatureSettings settings) {
        HashSet validators = Sets.newHashSet();
        for (ValidatorContributor contributor : this.getContributors()) {
            validators.addAll(contributor.getValidators(settings));
        }
        if (validators.isEmpty() || validators.size() > 1) {
            return new CompositeValidator(validators);
        }
        return (FeatureValueValidator)validators.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ValidatorContributor> getContributors() {
        if (this.initialized) {
            return this.registry;
        }
        Object object = this.lock;
        synchronized (object) {
            IConfigurationElement[] configElements;
            if (this.initialized) {
                return this.registry;
            }
            LinkedList allContributors = Lists.newLinkedList();
            IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool.featureValueValidator");
            int length = configElements.length;
            int index = 0;
            while (index < length) {
                IConfigurationElement configElement = elements[index];
                try {
                    ValidatorContributor e = (ValidatorContributor)configElement.createExecutableExtension(ATT_CLASS);
                    allContributors.add(e);
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                }
                ++index;
            }
            this.registry = allContributors;
            this.initialized = true;
            return this.registry;
        }
    }
}

