/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.AbstractFileStorage;
import com.e1c.langtool.storage.IFileEditor;
import com.e1c.langtool.storage.ITranslationFileEditorFactory;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import com.e1c.langtool.storage.TranslationStorageUtils;
import com.e1c.langtool.storage.context.ContextFormatFactory;
import com.e1c.langtool.storage.context.ContextTranslationData;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.google.common.hash.HashFunction;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ContextFileStorage
extends AbstractFileStorage
implements ITranslationStorageProvider.ContextStorage {
    private final ContextStorageSettings settings;
    private final ITranslatingProjectManager translatingProjectManager;

    public ContextFileStorage(IProject project, StorageID id, ContextStorageSettings settings, ITranslatingProjectManager translatingProjectManager) {
        super(project, id, settings);
        this.settings = settings;
        this.translatingProjectManager = translatingProjectManager;
    }

    @Override
    public String getTranslation(FeatureValue source, TranslateLanguage language) {
        return this.getTranslation(source.getContextKey(), language);
    }

    @Override
    public void setTranslation(FeatureValue source, TranslateLanguage language, String translation, boolean autoSave) {
        this.setTranslation(source.getContextKey(), language, translation, autoSave);
        this.setComment(source.getContextKey(), language, source.getComment(), autoSave);
    }

    @Override
    public void removeTranslation(FeatureValue source, TranslateLanguage language, boolean autoSave) {
        this.removeTranslation(source.getContextKey(), language, autoSave);
        this.removeComment(source.getContextKey(), language, autoSave);
    }

    @Override
    public void moveTranslation(FeatureValue fromSource, FeatureValue toSource, TranslateLanguage language, boolean autoSave) {
        this.moveTranslation(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
        this.moveComment(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
    }

    @Override
    public ITranslationStorageProvider.Storage.Type getType() {
        return ITranslationStorageProvider.Storage.Type.CONTEXT;
    }

    @Override
    public String getTranslation(ContextTranslationKey key, TranslateLanguage language) {
        String translation = "";
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return translation;
        }
        IFile file = this.getFile(key, language);
        if (file == null) {
            return translation;
        }
        ContextTranslationData data = this.getContextData(file, language);
        if (data != null) {
            translation = data.getTranslation(key);
        }
        if (translation == null) {
            translation = "";
        }
        return translation;
    }

    @Override
    public void setTranslation(ContextTranslationKey key, TranslateLanguage language, String translation, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(key, language);
        if (file == null) {
            return;
        }
        ContextTranslationData data = this.getContextData(file, language);
        if (data != null) {
            if (key.getFeatureSettings().isUnique()) {
                StringUtils.isNullOrEmpty(translation);
            }
            String comment = data.getComment(key);
            String oldTranslation = data.setTranslation(key, translation, comment);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.id, key, language, oldTranslation, translation);
            this.firePostValueChanged(event);
            if (autoSave) {
                this.addBatchUpdateNotification(event);
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public Map<IFile, byte[]> saveFiles(Collection<ContextTranslationKey> affectedKeys, TranslateLanguage language, HashFunction hashFunction) {
        HashMap<IFile, byte[]> results = new HashMap<IFile, byte[]>();
        HashSet<IFile> files = new HashSet<IFile>();
        for (ContextTranslationKey key : affectedKeys) {
            IFile file = this.getFile(key, language);
            if (file == null) continue;
            files.add(file);
        }
        for (IFile file : files) {
            byte[] hash = this.fileMediator.save(file, hashFunction);
            if (hash == null || hash.length == 0) continue;
            results.put(file, hash);
        }
        return results;
    }

    @Override
    public void removeTranslation(ContextTranslationKey key, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(key, language);
        if (file == null) {
            return;
        }
        ContextTranslationData data = this.getContextData(file, language);
        if (data != null) {
            String oldTranslation = data.removeTranslation(key);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), key, language, oldTranslation, null);
            this.firePostValueChanged(event);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public void moveTranslation(ContextTranslationKey fromKey, ContextTranslationKey toKey, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, fromKey.getFeatureSettings()) || !StorageSettingsUtils.canStoreFeature(this.settings, toKey.getFeatureSettings())) {
            return;
        }
        IFile fromFile = this.getFile(fromKey, language);
        IFile toFile = this.getFile(toKey, language);
        if (fromFile == null || toFile == null) {
            return;
        }
        ContextTranslationData fromData = this.getContextData(fromFile, language);
        ContextTranslationData toData = this.getContextData(toFile, language);
        if (fromData != null && toData != null) {
            String translation = fromData.getTranslation(fromKey);
            String comment = fromData.getComment(fromKey);
            fromData.removeTranslation(fromKey);
            String oldTranslation = toData.setTranslation(toKey, translation, comment);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), fromKey, language, translation, null);
            this.firePostValueChanged(event);
            StorageValueChangeEvent event2 = new StorageValueChangeEvent(this, this.getId(), toKey, language, oldTranslation, translation);
            this.firePostValueChanged(event2);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public String getComment(ContextTranslationKey key, TranslateLanguage language) {
        String comment = "";
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return comment;
        }
        IFile file = this.getFile(key, language);
        if (file == null) {
            return comment;
        }
        ContextTranslationData data = this.getContextData(file, language);
        if (data != null) {
            comment = data.getComment(key);
        }
        if (comment == null) {
            comment = "";
        }
        return comment;
    }

    @Override
    public void setComment(ContextTranslationKey key, TranslateLanguage language, String comment, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(key, language);
        if (file == null) {
            return;
        }
        ContextTranslationData data = this.getContextData(file, language);
        if (data != null) {
            String translation = data.getTranslation(key);
            if (translation == null && StringUtils.isNotEmpty(comment)) {
                translation = "";
            }
            String oldTranslation = data.setTranslation(key, translation, comment);
            this.firePostValueChanged(new StorageValueChangeEvent(this, this.id, key, language, oldTranslation, translation));
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public void removeComment(ContextTranslationKey key, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(key, language);
        if (file == null) {
            return;
        }
        ContextTranslationData data = this.getContextData(file, language);
        if (data != null) {
            String translation = data.getTranslation(key);
            if (translation != null) {
                data.setTranslation(key, translation, null);
            }
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), key, language, translation, translation);
            this.firePostValueChanged(event);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public void moveComment(ContextTranslationKey fromKey, ContextTranslationKey toKey, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, fromKey.getFeatureSettings()) || !StorageSettingsUtils.canStoreFeature(this.settings, toKey.getFeatureSettings())) {
            return;
        }
        IFile fromFile = this.getFile(fromKey, language);
        IFile toFile = this.getFile(toKey, language);
        if (fromFile == null || toFile == null) {
            return;
        }
        ContextTranslationData fromData = this.getContextData(fromFile, language);
        ContextTranslationData toData = this.getContextData(toFile, language);
        if (fromData != null && toData != null) {
            String translation = fromData.getTranslation(fromKey);
            String comment = fromData.getComment(fromKey);
            fromData.setTranslation(fromKey, translation, null);
            String toTranslation = toData.getTranslation(toKey);
            toData.setTranslation(toKey, toTranslation, comment);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), fromKey, language, translation, translation);
            this.firePostValueChanged(event);
            StorageValueChangeEvent event2 = new StorageValueChangeEvent(this, this.getId(), toKey, language, toTranslation, toTranslation);
            this.firePostValueChanged(event2);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public boolean hasKeyForValue(String value, TranslateLanguage language, ContextTranslationKey skipTranslationKey) {
        return false;
    }

    @Override
    protected Provider<ITranslationFileEditorFactory<?>> getTranslationFileEditorFactory(StorageSettings settings) {
        return () -> new ContextFormatFactory((ContextStorageSettings)settings);
    }

    private IFile getFile(ContextTranslationKey key, TranslateLanguage language) {
        IProject languageProject = this.translatingProjectManager.getLanguageProject(this.project, language);
        if (languageProject != null) {
            IPath path = TranslationStorageUtils.getContextFilePath(this.settings, key.getResourceId(), language);
            return languageProject.getFile(path);
        }
        return null;
    }

    private ContextTranslationData getContextData(IFile file, TranslateLanguage language) {
        IFileEditor editor = this.fileMediator.getFileOrLoad(file, this.project, language);
        if (editor != null) {
            return (ContextTranslationData)editor.getData();
        }
        return null;
    }
}

