/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.storage.ContextFileStorage;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.storage.AbstractFileStorageProvider;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.context.ContextFormatFactory;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;

public class ContextFileStorageProvider
extends AbstractFileStorageProvider {
    public static final String PROVIDER_ID = "context";
    public static final String SEGMENT = "trans";
    private final ITranslatingProjectManager translatingProjectManager;

    @Inject
    public ContextFileStorageProvider(ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager) {
        super(storageSettingsManager);
        this.translatingProjectManager = translatingProjectManager;
    }

    @Override
    public String getProviderId() {
        return PROVIDER_ID;
    }

    @Override
    protected ITranslationStorageProvider.Storage createStorage(IProject project, String segment) {
        ContextStorageSettings settings = this.getSegmentSettings(project, segment);
        if (settings == null) {
            settings = new ContextStorageSettings(segment);
            settings.setFormat("properties");
        }
        if (!this.isValidSettings(settings)) {
            return null;
        }
        return new ContextFileStorage(project, settings.getStorageId(), settings, this.translatingProjectManager);
    }

    @Override
    protected Collection<? extends ResourceStorageSettings> getProjectSettings(IProject project) {
        return this.storageSettingsManager.getSettingsOrDefault(project).getContextSettings();
    }

    private boolean isValidSettings(ContextStorageSettings settings) {
        if (!ContextFormatFactory.isFormatSupported(settings.getFormat())) {
            return false;
        }
        String replace = StorageSettingsUtils.getStringSettings(settings, "replace_file_name", "");
        return !StringUtils.isNotEmpty(replace) || Path.isValidPosixPath((String)replace);
    }

    private ContextStorageSettings getSegmentSettings(IProject project, String segment) {
        Collection<ContextStorageSettings> settingsList = this.storageSettingsManager.getSettingsOrDefault(project).getContextSettings();
        for (ContextStorageSettings settings : settingsList) {
            if (!segment.equalsIgnoreCase(settings.getId())) continue;
            return settings;
        }
        return null;
    }
}

