/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.storage.Messages;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.AbstractFileStorage;
import com.e1c.langtool.storage.IFileEditor;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.ITranslationFileEditorFactory;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.ModelValueAlreadyInUseException;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import com.e1c.langtool.storage.TranslationStorageUtils;
import com.e1c.langtool.storage.dictionary.DictionaryData;
import com.e1c.langtool.storage.dictionary.DictionaryFormatFactory;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.google.common.hash.HashFunction;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class DictionaryFileStorage
extends AbstractFileStorage
implements ITranslationStorageProvider.DictionaryStorage {
    private final ITranslatingProjectManager translatingProjectManager;
    private final IStorageSettingsManager storageSettingsManager;
    private final ITranslationStorageManager translationStorageManager;
    private final DictionaryStorageSettings settings;

    public DictionaryFileStorage(IProject project, StorageID id, DictionaryStorageSettings settings, ITranslatingProjectManager translatingProjectManager, IStorageSettingsManager storageSettingsManager, ITranslationStorageManager translationStorageManager) {
        super(project, id, settings);
        this.settings = settings;
        this.translatingProjectManager = translatingProjectManager;
        this.storageSettingsManager = storageSettingsManager;
        this.translationStorageManager = translationStorageManager;
    }

    @Override
    public String getTranslation(FeatureValue source, TranslateLanguage language) {
        return this.getTranslation(source.getContextKey(), language);
    }

    @Override
    public void setTranslation(FeatureValue source, TranslateLanguage language, String translation, boolean autoSave) {
        this.setTranslation(source.getContextKey(), language, translation, autoSave);
        this.setComment(source.getContextKey(), language, source.getComment(), autoSave);
    }

    @Override
    public void removeTranslation(FeatureValue source, TranslateLanguage language, boolean autoSave) {
        this.removeTranslation(source.getContextKey(), language, autoSave);
        this.removeComment(source.getContextKey(), language, autoSave);
    }

    @Override
    public void moveTranslation(FeatureValue fromSource, FeatureValue toSource, TranslateLanguage language, boolean autoSave) {
        this.moveTranslation(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
        this.moveComment(fromSource.getContextKey(), toSource.getContextKey(), language, autoSave);
    }

    @Override
    public ITranslationStorageProvider.Storage.Type getType() {
        return ITranslationStorageProvider.Storage.Type.COMMON;
    }

    @Override
    public String getTranslation(TranslationKey key, TranslateLanguage language) {
        String translation = "";
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return translation;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return translation;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            translation = data.getTranslation(key);
        }
        if (translation == null) {
            translation = "";
        }
        return translation;
    }

    @Override
    public void setTranslation(TranslationKey key, TranslateLanguage language, String translation, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            if (key.getFeatureSettings().isUnique() && StringUtils.isNullOrEmpty(translation) && data.hasKeyForValue(translation, key)) {
                String message = MessageFormat.format(Messages.DictionaryFileStorage_Translation__0__is_in_use_with_another_key_in_file__1__Source_key__2, translation, file.getFullPath(), key.getValue());
                throw new ModelValueAlreadyInUseException(message);
            }
            String comment = data.getComment(key);
            String oldTranslation = data.setTranslation(key, translation, comment);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.id, key, language, oldTranslation, translation);
            this.firePostValueChanged(event);
            if (autoSave) {
                this.addBatchUpdateNotification(event);
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public void removeTranslation(TranslationKey key, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            String oldTranslation = data.removeTranslation(key);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), key, language, oldTranslation, null);
            this.firePostValueChanged(event);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public void moveTranslation(TranslationKey fromKey, TranslationKey toKey, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, fromKey.getFeatureSettings()) || !StorageSettingsUtils.canStoreFeature(this.settings, toKey.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            String translation = data.getTranslation(fromKey);
            String comment = data.getComment(fromKey);
            data.removeTranslation(fromKey);
            String oldTranslation = data.setTranslation(toKey, translation, comment);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), fromKey, language, translation, null);
            this.firePostValueChanged(event);
            StorageValueChangeEvent event2 = new StorageValueChangeEvent(this, this.getId(), toKey, language, oldTranslation, translation);
            this.firePostValueChanged(event2);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public String getComment(TranslationKey key, TranslateLanguage language) {
        String comment = "";
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return comment;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return comment;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            comment = data.getComment(key);
        }
        if (comment == null) {
            comment = "";
        }
        return comment;
    }

    @Override
    public void setComment(TranslationKey key, TranslateLanguage language, String comment, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            String translation = data.getTranslation(key);
            String oldTranslation = data.setTranslation(key, translation, comment);
            this.firePostValueChanged(new StorageValueChangeEvent(this, this.id, key, language, oldTranslation, translation));
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public void removeComment(TranslationKey key, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, key.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            String translation = data.getTranslation(key);
            data.setTranslation(key, translation, null);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), key, language, translation, translation);
            this.firePostValueChanged(event);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public void moveComment(TranslationKey fromKey, TranslationKey toKey, TranslateLanguage language, boolean autoSave) {
        if (!StorageSettingsUtils.canStoreFeature(this.settings, fromKey.getFeatureSettings()) || !StorageSettingsUtils.canStoreFeature(this.settings, toKey.getFeatureSettings())) {
            return;
        }
        IFile file = this.getFile(language);
        if (file == null) {
            return;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            String translation = data.getTranslation(fromKey);
            String comment = data.getComment(fromKey);
            data.setTranslation(fromKey, translation, null);
            String toTranslation = data.getTranslation(toKey);
            data.setTranslation(toKey, toTranslation, comment);
            StorageValueChangeEvent event = new StorageValueChangeEvent(this, this.getId(), fromKey, language, translation, translation);
            this.firePostValueChanged(event);
            StorageValueChangeEvent event2 = new StorageValueChangeEvent(this, this.getId(), toKey, language, toTranslation, toTranslation);
            this.firePostValueChanged(event2);
            if (autoSave) {
                this.fileMediator.runAutoSaveOnDemand();
            }
        }
    }

    @Override
    public Map<IFile, byte[]> saveFiles(TranslateLanguage language, HashFunction hashFunction) {
        HashMap<IFile, byte[]> results = new HashMap<IFile, byte[]>();
        IFile file = this.getFile(language);
        byte[] hash = this.fileMediator.save(file, hashFunction);
        if (hash != null && hash.length != 0) {
            results.put(file, hash);
        }
        return results;
    }

    @Override
    public boolean hasKeyForValue(String value, TranslateLanguage language, TranslationKey skipKey) {
        IFile file = this.getFile(language);
        if (file == null) {
            return false;
        }
        DictionaryData data = this.getDictionaryData(file, language);
        if (data != null) {
            return data.hasKeyForValue(value, skipKey);
        }
        return false;
    }

    @Override
    protected Provider<ITranslationFileEditorFactory<?>> getTranslationFileEditorFactory(StorageSettings settings) {
        return () -> new DictionaryFormatFactory((DictionaryStorageSettings)settings, this.translatingProjectManager, this.storageSettingsManager, this.translationStorageManager);
    }

    private IFile getFile(TranslateLanguage language) {
        IProject languageProject = this.translatingProjectManager.getLanguageProject(this.project, language);
        if (languageProject != null) {
            IPath path = TranslationStorageUtils.getDictionaryFilePath(this.settings, language);
            return languageProject.getFile(path);
        }
        return null;
    }

    private DictionaryData getDictionaryData(IFile file, TranslateLanguage language) {
        IFileEditor editor = this.fileMediator.getFileOrLoad(file, this.project, language);
        if (editor != null) {
            return (DictionaryData)editor.getData();
        }
        return null;
    }
}

