/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.DictionaryTranslationKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.internal.storage.AbstractStorageTranslationProvider;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.settings.CommonFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class DictionaryStorageTranslationProvider
extends AbstractStorageTranslationProvider {
    private FeatureSettings defaultSettings = new CommonFeatureSettings("unknown", false, false, "unknown", false, false, false, false);

    @Override
    public List<String> translate(IContextTranslationQuery query) {
        Pair<ITranslatingProject, TranslateLanguage> target = this.getTargetProjectAndLanguage(query.getProjectName(), query.getSourceLanguage(), query.getTargetLanguage(), query.getFeatureValue().getContextKey().getFeatureSettings());
        if (target == null) {
            return Collections.emptyList();
        }
        return this.translate(target.getKey().getProject(), query.getFeatureValue().getContextKey(), target.getValue(), ITranslationStorageProvider.Storage.Type.COMMON);
    }

    @Override
    public List<String> translate(String text, String sourceLocale, String targetLocale) {
        ArrayList<String> result = new ArrayList<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            Pair<ITranslatingProject, TranslateLanguage> target = this.getTargetProjectAndLanguage(project.getName(), sourceLocale, targetLocale, null);
            if (target != null) {
                DictionaryTranslationKey key = new DictionaryTranslationKey(this.defaultSettings, text);
                List<String> translation = this.translate(target.getKey().getProject(), key, target.getValue(), ITranslationStorageProvider.Storage.Type.COMMON);
                if (!translation.isEmpty()) {
                    result.addAll(translation);
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public Map<String, List<String>> translate(List<String> texts, String sourceLocale, String targetLocale) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        texts.forEach(t -> {
            List<String> list = result.put((String)t, this.translate((String)t, sourceLocale, targetLocale));
        });
        return result;
    }
}

