/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.TranslationKey;
import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.IStorageSettingsChangeListener;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;

public class ProjectTranslationReader
implements IProjectTranslationReader {
    @Inject
    private IStorageSettingsManager settingsManager;
    @Inject
    private ITranslationStorageManager storageManager;
    private final IProject project;
    private final IStorageSettingsChangeListener settingsListener = this::settingsChanged;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ListenerList<IStorageValueChangedListener> listeners = new ListenerList();
    private volatile List<StorageSettings> storageSettings;

    public ProjectTranslationReader(IProject project) {
        CorePlugin.getDefault().getInjector().injectMembers((Object)this);
        Assert.isNotNull((Object)project);
        this.project = project;
    }

    @Override
    public String getStoredTranslation(TranslationKey key, TranslateLanguage language, ITranslationStorageProvider.Storage.Type ... storageTypes) {
        if (storageTypes == null || storageTypes.length == 0) {
            storageTypes = new ITranslationStorageProvider.Storage.Type[]{ITranslationStorageProvider.Storage.Type.CONTEXT, ITranslationStorageProvider.Storage.Type.COMMON};
        }
        ImmutableSet types = ImmutableSet.copyOf((Object[])storageTypes);
        return this.getStoredTranslationInternal(key, language, (Collection<ITranslationStorageProvider.Storage.Type>)types);
    }

    @Override
    public void addValueChangedListener(IStorageValueChangedListener listener) {
        this.listeners.add((Object)listener);
        for (StorageSettings settings : this.getStorageSettings()) {
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.project, settings.getStorageId());
            if (storage == null) continue;
            storage.addValueChangedListener(listener);
        }
    }

    @Override
    public void removeValueChangedListener(IStorageValueChangedListener listener) {
        this.listeners.remove((Object)listener);
        for (StorageSettings settings : this.getStorageSettings()) {
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.project, settings.getStorageId());
            if (storage == null) continue;
            storage.removeValueChangedListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<StorageSettings> getStorageSettings() {
        this.lock.readLock().lock();
        try {
            if (this.storageSettings != null) {
                List<StorageSettings> list = this.storageSettings;
                return list;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        ProjectTranslationReader projectTranslationReader = this;
        synchronized (projectTranslationReader) {
            block15: {
                if (this.storageSettings != null) {
                    List<StorageSettings> list = this.storageSettings;
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 6, 12] lbl17 : MonitorExitStatement: MONITOREXIT : var1_4
                    this.lock.writeLock().unlock();
                    return list;
                }
                if (this.project.isAccessible()) break block15;
                List<StorageSettings> list = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[1, 2, 6] lbl22 : MonitorExitStatement: MONITOREXIT : var1_4
                this.lock.writeLock().unlock();
                return list;
            }
            this.storageSettings = this.settingsManager.getSettingsOrDefault(this.project).getReadStorageSettings();
            this.settingsManager.addChangeListener(this.settingsListener);
            return this.storageSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void settingsChanged(IProject changed, boolean projectClosed) {
        if (this.project.equals((Object)changed)) {
            this.removeAllValueChangedListeners();
            this.lock.writeLock().lock();
            try {
                ProjectTranslationReader projectTranslationReader = this;
                synchronized (projectTranslationReader) {
                    this.storageSettings = null;
                    this.settingsManager.removeChangeListener(this.settingsListener);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.addAllValueChangedListeners(projectClosed);
        }
    }

    private void addAllValueChangedListeners(boolean projectClosed) {
        if (projectClosed || !this.project.isAccessible()) {
            this.lock.writeLock().lock();
            try {
                this.storageSettings = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return;
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        for (StorageSettings settings : this.getStorageSettings()) {
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.project, settings.getStorageId());
            if (storage == null) continue;
            for (IStorageValueChangedListener listener : this.listeners) {
                storage.addValueChangedListener(listener);
            }
        }
    }

    private void removeAllValueChangedListeners() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (StorageSettings settings : this.getStorageSettings()) {
            ITranslationStorageProvider.Storage storage = this.storageManager.getStorage(this.project, settings.getStorageId());
            if (storage == null) continue;
            for (IStorageValueChangedListener listener : this.listeners) {
                storage.removeValueChangedListener(listener);
            }
        }
    }

    private String getStoredTranslationInternal(TranslationKey key, TranslateLanguage language, Collection<ITranslationStorageProvider.Storage.Type> storageTypes) {
        String translation = "";
        for (StorageSettings settings : this.getStorageSettings()) {
            ITranslationStorageProvider.Storage storage;
            if (!StorageSettingsUtils.canStoreFeature(settings, key.getFeatureSettings()) || !storageTypes.contains((Object)(storage = this.storageManager.getStorage(this.project, settings.getStorageId())).getType())) continue;
            if (key instanceof FeatureValue) {
                translation = storage.getTranslation((FeatureValue)key, language);
            } else if (key instanceof ContextTranslationKey && storage instanceof ITranslationStorageProvider.ContextStorage) {
                translation = ((ITranslationStorageProvider.ContextStorage)storage).getTranslation((ContextTranslationKey)key, language);
            } else if (storage instanceof ITranslationStorageProvider.DictionaryStorage) {
                translation = ((ITranslationStorageProvider.DictionaryStorage)storage).getTranslation(key, language);
            }
            if (!StringUtils.isNotEmpty(translation)) continue;
            return translation;
        }
        return translation;
    }
}

