/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.storage.ProjectTranslationReader;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.IStorageSettingsChangeListener;
import com.e1c.langtool.storage.IStorageSettingsManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.annotation.NonNull;

@Singleton
public final class SharedProjectReaderCache {
    private static final long EXPIRATION_MINUTES = 20L;
    @Inject
    private IStorageSettingsManager storageSettingsManager;
    private final Cache<IProject, IProjectTranslationReader> projectReaders = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.MINUTES).removalListener(this::removedFromCache).build();
    private final IStorageSettingsChangeListener storageSettingsChangeListener = this::settingsChanged;

    public @NonNull IProjectTranslationReader getReader(IProject project) {
        try {
            return (IProjectTranslationReader)this.projectReaders.get((Object)project, () -> {
                this.storageSettingsManager.addChangeListener(this.storageSettingsChangeListener);
                return new ProjectTranslationReader(project);
            });
        }
        catch (ExecutionException e) {
            CorePlugin.logError(e);
            ProjectTranslationReader reader = new ProjectTranslationReader(project);
            this.projectReaders.put((Object)project, (Object)reader);
            return reader;
        }
    }

    private void settingsChanged(IProject porject, boolean projectClosed) {
        this.projectReaders.invalidate((Object)porject);
    }

    private void removedFromCache(RemovalNotification<IProject, IProjectTranslationReader> notification) {
        if (this.projectReaders.size() == 0L) {
            this.storageSettingsManager.removeChangeListener(this.storageSettingsChangeListener);
        }
    }
}

