/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.storage;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.internal.storage.SharedProjectReaderCache;
import com.e1c.langtool.storage.IProjectTranslationReader;
import com.e1c.langtool.storage.ITranslationStorageManager;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;

@Singleton
public class TranslationStorageManager
implements ITranslationStorageManager {
    private static final String EXTENSION_POINT_ID = "translationStorageProvider";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_ORDER = "order";
    private static final String ATT_ENABLE = "enable";
    private static final String ELEMENT_PROVIDER = "provider";
    private final SharedProjectReaderCache sharedProjectReaderCache;
    private volatile Map<String, StorageProvider> allStorageProviders;

    @Inject
    public TranslationStorageManager(SharedProjectReaderCache sharedProjectReaderCache) {
        this.sharedProjectReaderCache = sharedProjectReaderCache;
    }

    @Override
    public List<StorageID> getStorageIds(IProject project) {
        ArrayList ids = Lists.newArrayList();
        ArrayList providers = Lists.newArrayList(this.getAllStorageProviders().values());
        providers.sort(new Comparator<StorageProvider>(){

            @Override
            public int compare(StorageProvider o1, StorageProvider o2) {
                if (o1.getOrder() == o2.getOrder()) {
                    return o1.getId().hashCode() - o2.getId().hashCode();
                }
                return o1.getOrder() - o2.getOrder();
            }
        });
        for (StorageProvider sp : providers) {
            ITranslationStorageProvider provider = sp.getProvider();
            List<String> segments = provider.getStorageSegments(project);
            for (String segment : segments) {
                StorageID id = new StorageID(sp.getId(), segment);
                if (ids.contains(id)) continue;
                ids.add(id);
            }
        }
        return ids;
    }

    @Override
    public ITranslationStorageProvider getStorageProvider(String id) {
        StorageProvider provider = this.getAllStorageProviders().get(id);
        if (provider != null) {
            return provider.getProvider();
        }
        return null;
    }

    @Override
    public ITranslationStorageProvider getStorageProvider(StorageID id) {
        StorageProvider provider = this.getAllStorageProviders().get(id.getProviderId());
        if (provider != null) {
            return provider.getProvider();
        }
        return null;
    }

    @Override
    public ITranslationStorageProvider.Storage getStorage(IProject project, StorageID id) {
        ITranslationStorageProvider provider = this.getStorageProvider(id);
        if (provider != null) {
            return provider.getStorage(project, id.getSegment());
        }
        return null;
    }

    @Override
    public Collection<ITranslationStorageProvider> allStorageProviders() {
        return this.getAllStorageProviders().values().stream().map(StorageProvider::getProvider).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, StorageProvider> getAllStorageProviders() {
        Class<TranslationStorageManager> clazz;
        if (this.allStorageProviders != null) {
            return this.allStorageProviders;
        }
        Class<TranslationStorageManager> clazz2 = clazz = TranslationStorageManager.class;
        synchronized (clazz2) {
            IConfigurationElement[] configElements;
            if (this.allStorageProviders != null) {
                return this.allStorageProviders;
            }
            HashMap allStorageProviders = Maps.newHashMap();
            IConfigurationElement[] elements = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.e1c.langtool", EXTENSION_POINT_ID);
            int length = configElements.length;
            int index = 0;
            while (index < length) {
                IConfigurationElement configElement = elements[index];
                if (ELEMENT_PROVIDER.equals(configElement.getName())) {
                    try {
                        String id = configElement.getAttribute(ATT_ID);
                        ITranslationStorageProvider e = (ITranslationStorageProvider)configElement.createExecutableExtension(ATT_CLASS);
                        String name = configElement.getAttribute(ATT_NAME);
                        int order = 0;
                        try {
                            order = Integer.parseInt(configElement.getAttribute(ATT_ORDER));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        boolean enable = Boolean.parseBoolean(configElement.getAttribute(ATT_ENABLE));
                        StorageProvider provider = new StorageProvider(e, id, name, order, enable);
                        allStorageProviders.put(id, provider);
                    }
                    catch (CoreException e) {
                        CorePlugin.logError(e);
                    }
                }
                ++index;
            }
            this.allStorageProviders = allStorageProviders;
            return this.allStorageProviders;
        }
    }

    @Override
    public boolean isDefaultEnable(StorageID id) {
        StorageProvider provider = this.getAllStorageProviders().get(id.getProviderId());
        if (provider != null) {
            return provider.isEnable();
        }
        return false;
    }

    @Override
    public @NonNull IProjectTranslationReader getTranslationReader(@NonNull IProject project) {
        return this.sharedProjectReaderCache.getReader(project);
    }

    private class StorageProvider {
        private final ITranslationStorageProvider provider;
        private final String id;
        private final String name;
        private final int order;
        private final boolean enable;

        public StorageProvider(ITranslationStorageProvider provider, String id, String name, int order, boolean enable) {
            this.provider = provider;
            this.id = id;
            this.name = name;
            this.order = order < 1 ? 999 : order;
            this.enable = enable;
        }

        public ITranslationStorageProvider getProvider() {
            return this.provider;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isEnable() {
            return this.enable;
        }
    }
}

