/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.query;

import com.e1c.langtool.collector.FeatureValue;
import com.e1c.langtool.query.IContextTranslationQuery;
import com.e1c.langtool.storage.StorageID;

public final class ContextTranslationQuery
implements IContextTranslationQuery {
    private final String text;
    private final String sourceLanguage;
    private final String targetLanguage;
    private final boolean isProcessing;
    private final FeatureValue featureValue;
    private final StorageID storageId;
    private final String projectName;

    private ContextTranslationQuery(Builder builder) {
        this.text = builder.text;
        this.sourceLanguage = builder.sourceLanguage;
        this.targetLanguage = builder.targetLanguage;
        this.isProcessing = builder.isProcessing;
        this.featureValue = builder.featureValue;
        this.storageId = builder.storageId;
        this.projectName = builder.projectName;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @Override
    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    @Override
    public boolean isProcessingNeeded() {
        return this.isProcessing;
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.featureValue;
    }

    @Override
    public StorageID getStorageId() {
        return this.storageId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.featureValue == null ? 0 : this.featureValue.hashCode());
        result = 31 * result + (this.isProcessing ? 1231 : 1237);
        result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
        result = 31 * result + (this.sourceLanguage == null ? 0 : this.sourceLanguage.hashCode());
        result = 31 * result + (this.storageId == null ? 0 : this.storageId.hashCode());
        result = 31 * result + (this.targetLanguage == null ? 0 : this.targetLanguage.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContextTranslationQuery other = (ContextTranslationQuery)obj;
        if (this.featureValue == null ? other.featureValue != null : !this.featureValue.equals(other.featureValue)) {
            return false;
        }
        if (this.isProcessing != other.isProcessing) {
            return false;
        }
        if (this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName)) {
            return false;
        }
        if (this.sourceLanguage == null ? other.sourceLanguage != null : !this.sourceLanguage.equals(other.sourceLanguage)) {
            return false;
        }
        if (this.storageId == null ? other.storageId != null : !this.storageId.equals(other.storageId)) {
            return false;
        }
        if (this.targetLanguage == null ? other.targetLanguage != null : !this.targetLanguage.equals(other.targetLanguage)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public static class Builder {
        private String text;
        private String sourceLanguage = "";
        private String targetLanguage;
        private boolean isProcessing = true;
        private FeatureValue featureValue = null;
        private StorageID storageId = null;
        private String projectName = null;

        public static Builder valueOf(IContextTranslationQuery query) {
            return new Builder(query.getText(), query.getTargetLanguage()).sourceLanguage(query.getSourceLanguage()).featureValue(query.getFeatureValue()).projectName(query.getProjectName()).isProcessing(query.isProcessingNeeded()).storageId(query.getStorageId());
        }

        public Builder(String text, String targetLanguage) {
            if (text == null) {
                throw new IllegalArgumentException("Query text must not be null");
            }
            this.text = text;
            this.targetLanguage = targetLanguage;
        }

        public Builder text(String val) {
            if (val == null) {
                throw new IllegalArgumentException("Query text must not be null");
            }
            this.text = val;
            return this;
        }

        public Builder sourceLanguage(String val) {
            if (val == null) {
                throw new IllegalArgumentException("Query source language must not be null");
            }
            this.sourceLanguage = val;
            return this;
        }

        public Builder targetLanguage(String val) {
            if (val == null) {
                throw new IllegalArgumentException("Query target language must not be null");
            }
            this.targetLanguage = val;
            return this;
        }

        public Builder isProcessing(boolean val) {
            this.isProcessing = val;
            return this;
        }

        public Builder featureValue(FeatureValue val) {
            this.featureValue = val;
            return this;
        }

        public Builder storageId(StorageID val) {
            if (val != null) {
                this.storageId = new StorageID(val.getProviderId(), val.getSegment());
            }
            return this;
        }

        public Builder projectName(String val) {
            this.projectName = val;
            return this;
        }

        public ContextTranslationQuery build() {
            return new ContextTranslationQuery(this);
        }
    }
}

