/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.query;

import com.e1c.langtool.query.ISingleTranslationQuery;
import com.e1c.langtool.query.TranslationQuery;

public final class SingleTranslationQuery
extends TranslationQuery
implements ISingleTranslationQuery {
    private final String text;

    public static ISingleTranslationQuery createQuery(String text, String sourceLocale, String targetLocale, boolean isProcessing) {
        return new SingleTranslationQuery(text, sourceLocale, targetLocale, isProcessing);
    }

    public static ISingleTranslationQuery createQuery(String text, String sourceLocale, String targetLocale) {
        return new SingleTranslationQuery(text, sourceLocale, targetLocale, true);
    }

    private SingleTranslationQuery(String text, String source, String target, boolean isProcessingNeeded) {
        super(source, target, isProcessingNeeded);
        this.text = text;
        if (text == null) {
            throw new IllegalArgumentException("The text to translate must not be null");
        }
        if (source == null || target == null) {
            throw new IllegalArgumentException("Translation languages must not be null");
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleTranslationQuery other = (SingleTranslationQuery)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return "SingleTranslationQuery [text=" + this.text + ", sourceLang=" + this.getSourceLanguage() + ", targetLang=" + this.getTargetLanguage() + ", isProcessing=" + this.isProcessingNeeded() + "]";
    }
}

