/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.storage.CachedFileMediator;
import com.e1c.langtool.storage.IStorageValueChangedListener;
import com.e1c.langtool.storage.ITranslationFileEditorFactory;
import com.e1c.langtool.storage.ITranslationStorageProvider;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.StorageValueChangeEvent;
import com.e1c.langtool.storage.model.StorageSettings;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public abstract class AbstractFileStorage
implements ITranslationStorageProvider.Storage {
    private static final int BATCH_EVENTS_MAX_SIZE = 2000;
    protected final CachedFileMediator fileMediator;
    private final ListenerList<IStorageValueChangedListener> valueChangedListeners = new ListenerList();
    private final List<StorageValueChangeEvent> batchChangeEvents = new CopyOnWriteArrayList<StorageValueChangeEvent>();
    protected final IProject project;
    protected final StorageID id;
    private final StorageSettings settings;
    private final AtomicBoolean postInProgress = new AtomicBoolean(false);
    protected AtomicBoolean batchUpdate = new AtomicBoolean();

    public AbstractFileStorage(IProject project, StorageID id, StorageSettings settings) {
        this.project = project;
        this.id = id;
        this.settings = settings;
        this.fileMediator = new CachedFileMediator(this.getTranslationFileEditorFactory(settings));
    }

    @Override
    public StorageID getId() {
        return this.id;
    }

    @Override
    public String getSegment() {
        return this.getId().getSegment();
    }

    @Override
    public boolean isReadOnly() {
        return this.settings.isReadOnly();
    }

    @Override
    public void addValueChangedListener(IStorageValueChangedListener listener) {
        this.valueChangedListeners.add((Object)listener);
    }

    @Override
    public void removeValueChangedListener(IStorageValueChangedListener listener) {
        this.valueChangedListeners.remove((Object)listener);
    }

    @Override
    public void addBatchUpdateNotification(StorageValueChangeEvent event) {
        this.batchChangeEvents.add(event);
        if (this.batchChangeEvents.size() >= 2000) {
            this.firePostValuesChanged();
        }
    }

    @Override
    public void beginBatchUpdate() {
        this.fileMediator.beginBatchUpdate();
        this.batchUpdate.set(true);
    }

    @Override
    public void endBatchUpdate() {
        this.fileMediator.endBatchUpdate();
        this.batchUpdate.set(false);
        this.firePostValuesChanged();
    }

    public void dispose() {
        this.batchUpdate.set(false);
        this.fileMediator.dispose();
        this.valueChangedListeners.clear();
    }

    protected void firePostValueChanged(StorageValueChangeEvent event) {
        if (this.batchUpdate.get()) {
            return;
        }
        for (IStorageValueChangedListener l : this.valueChangedListeners) {
            try {
                SafeRunner.run(() -> l.changed(event));
            }
            catch (Throwable e) {
                CorePlugin.logError(e);
            }
        }
    }

    protected abstract Provider<ITranslationFileEditorFactory<?>> getTranslationFileEditorFactory(StorageSettings var1);

    private void firePostValuesChanged() {
        if (this.postInProgress.compareAndSet(false, true)) {
            ArrayList remove = Lists.newArrayList();
            for (StorageValueChangeEvent event : this.batchChangeEvents) {
                this.firePostValueChanged(event);
                remove.add(event);
            }
            this.batchChangeEvents.removeAll(remove);
            this.postInProgress.set(false);
        }
    }
}

