/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.IFileEditor;
import com.e1c.langtool.storage.ITranslationFileEditorFactory;
import com.e1c.langtool.storage.Messages;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.hash.HashFunction;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

@Singleton
public class CachedFileMediator {
    protected final Cache<IFile, IFileEditor<?>> filesCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> this.fileRemovalHandler(notification)).build();
    private final ConcurrentMap<IFile, IFileEditor<?>> files = this.filesCache.asMap();
    protected final ConcurrentNavigableMap<String, IFileEditor<?>> evictedTranslationFiles = new ConcurrentSkipListMap();
    private final IResourceChangeListener translationsChangeListener = new FileChangeListener();
    private final AtomicBoolean saveAutomatically = new AtomicBoolean(true);
    private final AtomicInteger updateLockCounter = new AtomicInteger(0);
    private final StoreFileDictionaryJob saveJob = new StoreFileDictionaryJob();
    private final Provider<ITranslationFileEditorFactory<?>> factoryProvider;
    private volatile ITranslationFileEditorFactory<?> factory;
    private final IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();

    public static CachedFileMediator getSharedInstance() {
        return (CachedFileMediator)CorePlugin.getDefault().getInjector().getInstance(CachedFileMediator.class);
    }

    public CachedFileMediator(Provider<ITranslationFileEditorFactory<?>> factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.translationsChangeListener);
        this.updateLockCounter.set(0);
        this.filesCache.invalidateAll();
    }

    public <T> IFileEditor<T> getFileOrLoad(IFile file, IProject project, TranslateLanguage language) {
        if (file != null) {
            try {
                return (IFileEditor)this.filesCache.get((Object)file, () -> {
                    IFileEditor<?> translationFile = (IFileEditor<?>)this.evictedTranslationFiles.remove(file.getFullPath().toPortableString());
                    if (translationFile == null) {
                        translationFile = this.getTranslationFileEditorFactory().getFileEditor(file, project, language);
                        translationFile.load();
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        workspace.addResourceChangeListener(this.translationsChangeListener);
                    }
                    return translationFile;
                });
            }
            catch (ExecutionException e) {
                return null;
            }
        }
        return null;
    }

    public void beginBatchUpdate() {
        this.saveAutomatically.set(false);
        try {
            this.joinSave();
        }
        catch (InterruptedException e) {
            CorePlugin.logError(e);
        }
        this.updateLockCounter.incrementAndGet();
    }

    public void endBatchUpdate() {
        int lockCounterValue = this.updateLockCounter.decrementAndGet();
        Assert.isLegal((lockCounterValue >= 0 ? 1 : 0) != 0, (String)"Disbalanced beginBatchUpdate()/endBatchUpdate()");
        this.runAutoSaveOnDemand();
        if (lockCounterValue == 0) {
            try {
                this.joinSave();
            }
            catch (InterruptedException e) {
                CorePlugin.logError(e);
            }
        }
        this.saveAutomatically.set(true);
    }

    public void runAutoSaveOnDemand() {
        if (this.saveAutomatically.get() || this.updateLockCounter.get() < 1) {
            this.saveJob.schedule(1000L);
        }
    }

    public byte[] save(IFile file, HashFunction hashFunction) {
        Assert.isNotNull((Object)file);
        IFileEditor fileEditor = (IFileEditor)this.files.get(file);
        if (fileEditor != null) {
            try {
                return this.saveOrDeleteEmpty(fileEditor, hashFunction, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                CorePlugin.logError(e);
            }
        }
        return null;
    }

    public void joinSave() throws InterruptedException {
        this.saveJob.join();
    }

    private void fileRemovalHandler(RemovalNotification<IFile, IFileEditor<?>> notification) {
        IFileEditor translationsFile = (IFileEditor)notification.getValue();
        if (translationsFile.isDirty()) {
            this.evictedTranslationFiles.put(((IFile)notification.getKey()).getFullPath().toPortableString(), translationsFile);
            this.runAutoSaveOnDemand();
        }
        if (this.files.isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.translationsChangeListener);
        }
    }

    private byte[] saveOrDeleteEmpty(IFileEditor<?> translationFile, HashFunction hashFunction, IProgressMonitor monitor) throws IOException {
        if (monitor.isCanceled()) {
            return null;
        }
        if (translationFile.isEmpty()) {
            translationFile.delete();
            return null;
        }
        IProject project = translationFile.getFile().getProject();
        this.createFoldersByPath(project, translationFile.getFile().getProjectRelativePath(), monitor);
        if (project.isAccessible()) {
            ISchedulingRule rule = this.ruleFactory.createRule((IResource)translationFile.getFile());
            try {
                Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
                if (hashFunction != null) {
                    byte[] byArray = translationFile.save(hashFunction, monitor);
                    return byArray;
                }
                translationFile.save(monitor);
            }
            finally {
                Job.getJobManager().endRule(rule);
            }
        }
        return null;
    }

    private ITranslationFileEditorFactory<?> getTranslationFileEditorFactory() {
        if (this.factory == null) {
            this.factory = (ITranslationFileEditorFactory)this.factoryProvider.get();
        }
        return this.factory;
    }

    private void createFoldersByPath(IProject project, IPath path, IProgressMonitor monitor) {
        IFolder folder = null;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            block8: {
                if (!project.isAccessible() || monitor.isCanceled()) {
                    return;
                }
                if (!(folder = folder == null ? project.getFolder(path.segment(i)) : folder.getFolder(path.segment(i))).exists()) {
                    ISchedulingRule rule = this.ruleFactory.createRule((IResource)folder);
                    try {
                        try {
                            Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
                            folder.create(false, true, monitor);
                        }
                        catch (CoreException e) {
                            CorePlugin.logError(e);
                            Job.getJobManager().endRule(rule);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        Job.getJobManager().endRule(rule);
                        throw throwable;
                    }
                    Job.getJobManager().endRule(rule);
                }
            }
            ++i;
        }
    }

    private class FileChangeListener
    implements IResourceChangeListener {
        private FileChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (CachedFileMediator.this.files.isEmpty()) {
                return;
            }
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IResource res = event.getResource();
                    if (!(res instanceof IProject)) break;
                    Iterator<Object> iterator = CachedFileMediator.this.files.keySet().iterator();
                    while (iterator.hasNext()) {
                        IFile file = (IFile)iterator.next();
                        if (!res.equals((Object)file.getProject())) continue;
                        iterator.remove();
                    }
                    iterator = CachedFileMediator.this.evictedTranslationFiles.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        IFile file = ((IFileEditor)entry.getValue()).getFile();
                        if (file == null || !file.getProject().equals((Object)res)) continue;
                        iterator.remove();
                    }
                    break;
                }
                case 1: {
                    for (IFile file : CachedFileMediator.this.files.keySet()) {
                        IResourceDelta delta = event.getDelta().findMember(file.getFullPath());
                        if (delta == null) continue;
                        if (delta.getKind() == 2 || delta.getKind() == 1) {
                            CachedFileMediator.this.files.remove(file);
                            continue;
                        }
                        if (delta.getKind() != 4 || (delta.getFlags() & 0x40100) == 0) continue;
                        CachedFileMediator.this.files.remove(file);
                    }
                    break;
                }
            }
        }
    }

    protected class StoreFileDictionaryJob
    extends Job {
        public StoreFileDictionaryJob() {
            super(Messages.CachedFileMediator_Saving_translations);
            super.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.CachedFileMediator_Saving_translations, -1);
            if (CachedFileMediator.this.files.isEmpty() && CachedFileMediator.this.evictedTranslationFiles.isEmpty()) {
                return Status.OK_STATUS;
            }
            try {
                ResourcesPlugin.getWorkspace().run(runnableMonitor -> {
                    Map.Entry evictedEntry;
                    runnableMonitor.beginTask(Messages.CachedFileMediator_Saving_translations, CachedFileMediator.this.files.size());
                    while ((evictedEntry = CachedFileMediator.this.evictedTranslationFiles.firstEntry()) != null) {
                        CachedFileMediator.this.evictedTranslationFiles.computeIfPresent((String)evictedEntry.getKey(), (fileName, translationFile) -> {
                            try {
                                CachedFileMediator.this.saveOrDeleteEmpty((IFileEditor<?>)translationFile, null, runnableMonitor);
                            }
                            catch (IOException e) {
                                CorePlugin.logError(e);
                                runnableMonitor.setCanceled(true);
                                return null;
                            }
                            return null;
                        });
                    }
                    Iterator iterator = CachedFileMediator.this.files.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        IFileEditor translationFile2 = (IFileEditor)entry.getValue();
                        if (runnableMonitor.isCanceled() || !translationFile2.isDirty()) continue;
                        try {
                            CachedFileMediator.this.saveOrDeleteEmpty(translationFile2, null, runnableMonitor);
                            iterator.remove();
                            runnableMonitor.worked(1);
                        }
                        catch (IOException e) {
                            CorePlugin.logError(e);
                            runnableMonitor.setCanceled(true);
                            return;
                        }
                    }
                }, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
                return CorePlugin.createErrorStatus(e.getLocalizedMessage(), e);
            }
            if (CachedFileMediator.this.files.isEmpty()) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(CachedFileMediator.this.translationsChangeListener);
            }
            return Status.OK_STATUS;
        }
    }
}

