/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class TranslationStorageUtils {
    private static final String LANGUAGE_CODE_SEPARATOR = "_";

    public static IPath getDictionaryFilePath(DictionaryStorageSettings settings, TranslateLanguage language) {
        String code = language.getLanguageCode();
        Path path = new Path(settings.getFilePath());
        Object last = "";
        String fileExt = null;
        if (!path.isEmpty()) {
            fileExt = path.getFileExtension();
            last = path.segment(path.segmentCount() - 1);
            path = path.removeLastSegments(1);
        }
        last = (String)last + LANGUAGE_CODE_SEPARATOR + code;
        if (fileExt == null) {
            fileExt = settings.getFileExtension();
        }
        return path.append((String)last).addFileExtension(fileExt);
    }

    public static IPath getContextFilePath(ContextStorageSettings settings, IPath resourcePath, TranslateLanguage language) {
        String replace;
        String code = language.getLanguageCode();
        IPath path = resourcePath;
        Object last = "";
        String fileExt = null;
        if (!path.isEmpty()) {
            int maxFolders = StorageSettingsUtils.getIntSettings(settings, "max_context_folders", -1);
            fileExt = path.getFileExtension();
            last = path.removeFileExtension().segment(path.segmentCount() - 1);
            path = path.removeLastSegments(1);
            if (maxFolders == 0) {
                path = Path.EMPTY;
            } else if (maxFolders > 0 && path.segmentCount() > maxFolders) {
                path = path.removeLastSegments(path.segmentCount() - maxFolders);
            }
        }
        if (StringUtils.isNotEmpty(replace = StorageSettingsUtils.getStringSettings(settings, "replace_file_name", ""))) {
            last = replace;
        }
        last = (String)last + LANGUAGE_CODE_SEPARATOR + code;
        if (settings.getFileExtension() != null) {
            fileExt = settings.getFileExtension();
        }
        return path.append((String)last).addFileExtension(fileExt);
    }

    private TranslationStorageUtils() {
        throw new IllegalAccessError();
    }
}

