/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.model;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.FeatureSettingsFilter;
import com.e1c.langtool.storage.model.Messages;
import com.e1c.langtool.storage.model.RuleSettings;
import com.e1c.langtool.storage.model.StorageIdList;
import com.e1c.langtool.storage.model.StorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class EditSettings
extends StorageSettings {
    private StorageIdList storages;
    private Map<String, RuleSettings> rules;
    private volatile List<StorageID> storageIDs;

    @Override
    public String getId() {
        return "edit";
    }

    @Override
    public synchronized void setId(String id) {
    }

    @Override
    public String getPresentation() {
        if (StringUtils.isNullOrEmpty(super.getPresentation())) {
            return Messages.EditSettings_Default_editing_storage;
        }
        return super.getPresentation();
    }

    @Override
    public StorageID getStorageId() {
        return StorageSettingsUtils.EDIT_DEFAULT_STORAGE_ID;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public synchronized void setReadOnly(Boolean readOnly) {
    }

    @Override
    public Map<String, FeatureSettingsFilter> getFeatureFilter() {
        return Map.of();
    }

    @Override
    public synchronized void setFeatureFilter(Map<String, FeatureSettingsFilter> featureFilter) {
    }

    @Override
    public Map<String, String> getSettings() {
        return Map.of();
    }

    @Override
    public synchronized void setSettings(Map<String, String> settings) {
    }

    public Map<String, RuleSettings> getRules() {
        if (this.rules == null) {
            this.setRules(new ArrayList<RuleSettings>());
        }
        return this.rules;
    }

    public Collection<RuleSettings> getRulesSettings() {
        if (this.rules == null) {
            this.setRules(new ArrayList<RuleSettings>());
        }
        return this.rules.values();
    }

    public synchronized void setRules(List<RuleSettings> rules) {
        if (rules != null) {
            this.rules = new LinkedHashMap<String, RuleSettings>();
            rules.forEach(e -> {
                RuleSettings ruleSettings = this.rules.put(e.getId(), (RuleSettings)e);
            });
        } else {
            this.rules = null;
        }
        this.storageIDs = null;
    }

    public synchronized void setRules(Map<String, RuleSettings> rules) {
        this.rules = rules;
        if (this.rules != null) {
            this.rules.forEach((k, v) -> v.setId((String)k));
        }
        this.storageIDs = null;
    }

    public synchronized void addRule(RuleSettings rule) {
        this.getRules().put(rule.getId(), rule);
        this.storageIDs = null;
    }

    public StorageIdList getStorages() {
        if (this.storages == null) {
            this.setStorages(new StorageIdList());
        }
        return this.storages;
    }

    public synchronized void setStorages(StorageIdList storages) {
        this.storages = storages;
        this.storageIDs = null;
    }

    public List<StorageID> getStorageIDs() {
        if (this.getStorages() != null) {
            return this.getStorages().getStorageIds();
        }
        return List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageID> allStorageIds() {
        if (this.storageIDs == null) {
            EditSettings editSettings = this;
            synchronized (editSettings) {
                if (this.storageIDs != null) {
                    return this.storageIDs;
                }
                TreeSet<StorageID> result = new TreeSet<StorageID>();
                if (this.getStorages() != null && !this.getStorages().isEmpty()) {
                    result.addAll(this.getStorages().getStorageIds());
                }
                if (this.getRules() != null && !this.getRules().isEmpty()) {
                    for (RuleSettings rule : this.getRulesSettings()) {
                        if (rule.getStorageIds().isEmpty()) continue;
                        result.addAll(rule.getStorageIds());
                    }
                }
                this.storageIDs = List.copyOf(result);
            }
        }
        return this.storageIDs;
    }
}

