/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.model;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.context.ContextFormatFactory;
import com.e1c.langtool.storage.dictionary.DictionaryFormatFactory;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.EditSettings;
import com.e1c.langtool.storage.model.IMessageAcceptor;
import com.e1c.langtool.storage.model.Messages;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.ResourceStorageSettings;
import com.e1c.langtool.storage.model.RuleSettings;
import com.e1c.langtool.storage.model.StorageIdList;
import com.e1c.langtool.storage.model.StorageSettings;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class StorageModelValidator {
    protected final ProjectStorageSettings root;
    protected final IMessageAcceptor messageAcceptor;

    public StorageModelValidator(ProjectStorageSettings object, IMessageAcceptor messageAcceptor) {
        this.root = object;
        this.messageAcceptor = messageAcceptor;
    }

    public void validate(IProgressMonitor monitor) {
        if (this.root == null || monitor.isCanceled()) {
            return;
        }
        this.validate(this.root.getEdit());
        if (monitor.isCanceled()) {
            return;
        }
        if (this.root.getRead().isEmpty()) {
            this.messageAcceptor.addError(this.root, Messages.StorageModelValidator_Project_settings_has_no_read_order_list_of_storages);
        } else {
            this.validate(this.root.getRead());
        }
        if (monitor.isCanceled()) {
            return;
        }
        for (Map.Entry<String, ContextStorageSettings> entry : this.root.getContext().entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.validate(entry.getValue());
        }
        for (Map.Entry<String, ResourceStorageSettings> entry : this.root.getDictionary().entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.validate((DictionaryStorageSettings)entry.getValue());
        }
        for (Map.Entry<String, StorageSettings> entry : this.root.getStorages().entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            this.validate(entry.getValue());
        }
    }

    protected void validate(EditSettings object) {
        if (object == null) {
            return;
        }
        if (StringUtils.isBlank(object.getPresentation())) {
            this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_presentation);
        }
        if (object.getStorages().isEmpty() && object.getRules().isEmpty()) {
            this.messageAcceptor.addError(object, Messages.StorageModelValidator_Edit_settings_has_no_storages_or_rules);
        } else {
            this.validate(object.getStorages());
            for (Map.Entry<String, RuleSettings> entry : object.getRules().entrySet()) {
                this.validate(entry.getValue());
            }
            this.validateReadOnly(object.getStorages());
            for (RuleSettings rule : object.getRulesSettings()) {
                this.validateReadOnly(rule.getStorages());
            }
        }
    }

    protected void validateReadOnly(StorageIdList object) {
        if (object == null) {
            return;
        }
        if (object.size() == object.getStorageIds().size()) {
            int i = 0;
            while (i < object.getStorageIds().size()) {
                StorageID id = object.getStorageIds().get(i);
                StorageSettings settings = this.root.allStorageSettings().get(id);
                if (settings != null && settings.isReadOnly()) {
                    String message = MessageFormat.format(Messages.StorageModelValidator_Storage_with_ID___0___is_read_only_and_cannot_be_used_for_editing, id);
                    this.messageAcceptor.addWarning(object, i, message);
                }
                ++i;
            }
        }
    }

    protected void validate(RuleSettings object) {
        if (object == null) {
            return;
        }
        if (StringUtils.isBlank(object.getId())) {
            this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Rule_shoud_be_set_the_id);
        }
        if (object.getStorageIds().isEmpty()) {
            this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Rule_shoud_has_at_least_one_storage_ID_in_the_storages_list);
        }
        if (object.getWhen().isEmpty()) {
            Iterator<RuleSettings> iterator = this.root.getEdit().getRulesSettings().iterator();
            while (iterator.hasNext()) {
                RuleSettings rule = iterator.next();
                if (rule != object || !iterator.hasNext()) continue;
                this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Rule_shoud_has_when_condition_settings);
            }
        }
    }

    protected void validate(StorageIdList object) {
        boolean hasParseError;
        if (object == null) {
            return;
        }
        List<StorageID> ids = object.getStorageIds();
        boolean bl = hasParseError = object.size() != ids.size();
        if (hasParseError) {
            int i = 0;
            while (i < object.size()) {
                String content = (String)object.get(i);
                if (i >= ids.size() || i < ids.size() && !ids.get(i).toString().equals(content)) {
                    this.messageAcceptor.addWarning(object, i, MessageFormat.format(Messages.StorageModelValidator_Storage_id_cannot_be_parsed_from_string___0, content));
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < ids.size()) {
                StorageID id = ids.get(i);
                StorageSettings setting = this.root.allStorageSettings().get(id);
                if (setting == null) {
                    this.messageAcceptor.addError(object, i, MessageFormat.format(Messages.StorageModelValidator_Storage_ID___0___cannot_be_found_in_the_project_settings, id));
                }
                ++i;
            }
        }
    }

    protected void validate(ContextStorageSettings object) {
        if (object == null) {
            return;
        }
        if (StringUtils.isBlank(object.getId())) {
            this.messageAcceptor.addError(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_id);
        }
        if (StringUtils.isBlank(object.getPresentation())) {
            this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_presentation);
        }
        if (StringUtils.isBlank(object.getFormat())) {
            this.messageAcceptor.addError(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_format);
        } else if (!ContextFormatFactory.isFormatSupported(object.getFormat())) {
            String message = MessageFormat.format(Messages.StorageModelValidator_Context_settings_format___0___is_not_supported, object.getFormat());
            this.messageAcceptor.addError(object, message);
        }
    }

    protected void validate(DictionaryStorageSettings object) {
        if (object == null) {
            return;
        }
        if (StringUtils.isBlank(object.getId())) {
            this.messageAcceptor.addError(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_id);
        }
        if (StringUtils.isBlank(object.getPresentation())) {
            this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_presentation);
        }
        if (StringUtils.isBlank(object.getFormat())) {
            this.messageAcceptor.addError(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_format);
        } else if (!DictionaryFormatFactory.isFormatSupported(object.getFormat())) {
            String message = MessageFormat.format(Messages.StorageModelValidator_Dictionary_format_type___0___is_not_support, object.getFormat());
            this.messageAcceptor.addError(object, message);
        }
        String path = object.getFilePath();
        if (StringUtils.isBlank(path) || !Path.isValidPosixPath((String)path)) {
            String message = MessageFormat.format(Messages.StorageModelValidator_Dictionary_file_path___0___is_not_valid, object.getFormat());
            this.messageAcceptor.addError(object, message);
        }
    }

    protected void validate(StorageSettings object) {
        if (object == null) {
            return;
        }
        if (StringUtils.isBlank(object.getId())) {
            this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_id);
        }
        if (StringUtils.isBlank(object.getPresentation())) {
            this.messageAcceptor.addWarning(object, Messages.StorageModelValidator_Settings_shoud_have_set_the_presentation);
        }
    }
}

