/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.model;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.common.Pair;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.settings.CommonFeatureSettings;
import com.e1c.langtool.settings.FeatureSettings;
import com.e1c.langtool.storage.StorageID;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.DictionaryStorageSettings;
import com.e1c.langtool.storage.model.EditSettings;
import com.e1c.langtool.storage.model.FeatureSettingsFilter;
import com.e1c.langtool.storage.model.IMessageAcceptor;
import com.e1c.langtool.storage.model.Messages;
import com.e1c.langtool.storage.model.ProjectStorageSettings;
import com.e1c.langtool.storage.model.RuleSettings;
import com.e1c.langtool.storage.model.StorageIdList;
import com.e1c.langtool.storage.model.StorageModelValidator;
import com.e1c.langtool.storage.model.StorageSettings;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.representer.SafeRepresenter;

public class StorageSettingsUtils {
    public static final String EDIT_PROVIDER_ID = "edit";
    public static final String EDIT_DEFAULT_SEGMENT = "default";
    public static final StorageID EDIT_DEFAULT_STORAGE_ID = new StorageID("edit", "default");
    public static final String FEATURE_FILTER_CAMELCASE = "camelcase";
    public static final String FEATURE_FILTER_ID = "id";
    public static final String FEATURE_FILTER_INTERFACE = "interface";
    public static final String FEATURE_FILTER_MULTILINE = "multiline";
    public static final String FEATURE_FILTER_MODEL = "model";
    public static final String FEATURE_FILTER_PREFERCONTEXT = "prefercontext";
    public static final String FEATURE_FILTER_UNIQUE = "unique";
    public static final String FEATURE_FILTER_TAGS = "tags";
    private static final String MARKER_ID = "com.e1c.langtool.storage.settings.validation";
    private static final String[] MARKERY_ATTRIBUTES = new String[]{"lineNumber", "message", "severity", "priority"};
    private static final String METHOD_NAME_GET_FEATURE_FILTER = "getFeatureFilter";
    private static final String METHOD_NAME_GET_FILE_EXTENTION = "getFileExtension";
    private static final String METHOD_NAME_IS_READ_ONLY = "isReadOnly";
    private static final String METHOD_NAME_SET_FEATURE_FILTER = "setFeatureFilter";
    private static final String METHOD_NAME_SET_FILE_EXTENTION = "setFileExtension";
    private static final String METHOD_NAME_SET_READ_ONLY = "setReadOnly";
    private static final String PROPERTY_ID = "id";
    private static final String PROPERTY_CONTEXT = "context";
    private static final String PROPERTY_DICTIONARY = "dictionary";
    private static final String PROPERTY_EDIT = "edit";
    private static final String PROPERTY_FEATURE_FILTER = "feature_filter";
    private static final String PROPERTY_FILE_EXTENSION = "file_extension";
    private static final String PROPERTY_FILE_PATH = "file_path";
    private static final String PROPERTY_FORMAT = "format";
    private static final String PROPERTY_PRESENTATION = "presentation";
    private static final String PROPERTY_READ = "read";
    private static final String PROPERTY_READ_ONLY = "read_only";
    private static final String PROPERTY_SETTINGS = "settings";
    private static final String PROPERTY_STORAGE = "storage";
    private static final String PROPERTY_VALIDATION = "validation";
    public static final String RULE_WHEN_LANGUAGE_CODE = "language_code";
    public static final String RULE_WHEN_FEATURE_KEY_REGEX = "feature_key_regex";
    public static final String RULE_WHEN_RESOURCE_PATH_REGEX = "resource_path_regex";
    public static final String RULE_WHEN_VALUE_REGEX = "value_regex";
    public static final boolean SETTINGS_DEFAULT_KEY_CASE_SENSITIVE = false;
    public static final int SETTINGS_DEFAULT_MAX_CONTEXT_FOLDERS = -1;
    public static final String SETTINGS_DEFAULT_REPLACE_FILE_NAME = "";
    public static final boolean SETTINGS_DEFAULT_VALUE_CASE_SENSITIVE = false;
    public static final String SETTINGS_DEFAULT_VALUE_NON_GLOBAL_UNIQUE_POSTFIX = "";
    public static final String SETTINGS_DEFAULT_VALUE_NON_GLOBAL_UNIQUE_PREFIX = "";
    public static final boolean SETTINGS_DEFAULT_VALUE_UNIQUE = true;
    public static final String SETTINGS_KEY_CASE_SENSITIVE = "key_case_sensitve";
    public static final String SETTINGS_MAX_CONTEXT_FOLDERS = "max_context_folders";
    public static final String SETTINGS_REPLACE_FILE_NAME = "replace_file_name";
    public static final String SETTINGS_VALUE_CASE_SENSITIVE = "value_case_sensitive";
    public static final String SETTINGS_VALUE_NON_GLOBAL_UNIQUE_POSTFIX = "value_non_global_unique_postfix";
    public static final String SETTINGS_VALUE_NON_GLOBAL_UNIQUE_PREFIX = "value_non_global_unique_prefix";
    public static final String SETTINGS_VALUE_UNIQUE = "value_unique";

    public static boolean canStoreByRule(RuleSettings rule, ContextTranslationKey key, TranslateLanguage language) {
        Pattern pattern;
        String value;
        if (rule.getStorages().isEmpty()) {
            return false;
        }
        Map<String, String> when = rule.getWhen();
        if (when.isEmpty()) {
            return true;
        }
        if (when.containsKey(RULE_WHEN_LANGUAGE_CODE)) {
            String languageCode = language.getLanguageCode();
            String value2 = when.get(RULE_WHEN_LANGUAGE_CODE);
            if (StringUtils.isNotEmpty(languageCode) && !languageCode.equals(value2)) {
                return false;
            }
        }
        FeatureSettings featureSettings = key.getFeatureSettings();
        if (when.containsKey(FEATURE_FILTER_CAMELCASE)) {
            boolean value3 = Boolean.parseBoolean(when.get(FEATURE_FILTER_CAMELCASE));
            if (featureSettings.isCamelCase() != value3) {
                return false;
            }
        }
        if (when.containsKey(FEATURE_FILTER_PREFERCONTEXT)) {
            boolean value4 = Boolean.parseBoolean(when.get(FEATURE_FILTER_PREFERCONTEXT));
            if (featureSettings.isPreferContext() != value4) {
                return false;
            }
        }
        if (when.containsKey(RULE_WHEN_RESOURCE_PATH_REGEX)) {
            IPath path = key.getResourceId();
            value = when.get(RULE_WHEN_RESOURCE_PATH_REGEX);
            if (!path.isEmpty() && StringUtils.isNotEmpty(value) && !(pattern = Pattern.compile(value, 256)).matcher(path.toString()).matches()) {
                return false;
            }
        }
        if (when.containsKey(RULE_WHEN_FEATURE_KEY_REGEX)) {
            FeatureKey featureKey = key.getFeatureKey();
            value = when.get(RULE_WHEN_FEATURE_KEY_REGEX);
            if (!featureKey.isEmpty() && StringUtils.isNotEmpty(value) && !(pattern = Pattern.compile(value, 256)).matcher(featureKey.toString()).matches()) {
                return false;
            }
        }
        if (when.containsKey(RULE_WHEN_VALUE_REGEX)) {
            String source = key.getValue();
            value = when.get(RULE_WHEN_VALUE_REGEX);
            if (StringUtils.isNotEmpty(value) && !(pattern = Pattern.compile(value, 256)).matcher(source).matches()) {
                return false;
            }
        }
        return true;
    }

    public static boolean canStoreFeature(Map<String, FeatureSettingsFilter> featureFilter, FeatureSettings featureSettings) {
        if (featureFilter.isEmpty()) {
            return true;
        }
        block20: for (Map.Entry<String, FeatureSettingsFilter> entry : featureFilter.entrySet()) {
            switch (entry.getKey()) {
                case "camelcase": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isCamelCase()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isCamelCase())) continue block20;
                    return false;
                }
                case "model": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isModel()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isModel())) continue block20;
                    return false;
                }
                case "id": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isId()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isId())) continue block20;
                    return false;
                }
                case "unique": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isUnique()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isUnique())) continue block20;
                    return false;
                }
                case "interface": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isInterface()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isInterface())) continue block20;
                    return false;
                }
                case "multiline": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isMultiLine()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isMultiLine())) continue block20;
                    return false;
                }
                case "prefercontext": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isPreferContext()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isPreferContext())) continue block20;
                    return false;
                }
                case "tags": {
                    if ((entry.getValue() != FeatureSettingsFilter.ONLY || featureSettings.isTag()) && (entry.getValue() != FeatureSettingsFilter.NONE || !featureSettings.isTag())) continue block20;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean canStoreFeature(StorageSettings settings, FeatureSettings featureSettings) {
        return StorageSettingsUtils.canStoreFeature(settings.getFeatureFilter(), featureSettings);
    }

    private static TypeDescription createContextStorageSettingsTypeDescription() {
        TypeDescription descr = new TypeDescription(ContextStorageSettings.class, new Tag(ContextStorageSettings.class));
        descr.substituteProperty(PROPERTY_READ_ONLY, Boolean.class, METHOD_NAME_IS_READ_ONLY, METHOD_NAME_SET_READ_ONLY, new Class[]{Boolean.class});
        descr.substituteProperty(PROPERTY_FEATURE_FILTER, Map.class, METHOD_NAME_GET_FEATURE_FILTER, METHOD_NAME_SET_FEATURE_FILTER, new Class[]{String.class, FeatureSettingsFilter.class});
        descr.substituteProperty(PROPERTY_FILE_EXTENSION, String.class, METHOD_NAME_GET_FILE_EXTENTION, METHOD_NAME_SET_FILE_EXTENTION, new Class[]{String.class});
        descr.setIncludes(new String[]{PROPERTY_PRESENTATION, PROPERTY_FORMAT, PROPERTY_FILE_EXTENSION, PROPERTY_READ_ONLY, PROPERTY_FEATURE_FILTER, PROPERTY_SETTINGS});
        return descr;
    }

    private static TypeDescription createDictionaryStorageSettingsTypeDescription() {
        TypeDescription descr = new TypeDescription(DictionaryStorageSettings.class, new Tag(DictionaryStorageSettings.class));
        descr.substituteProperty(PROPERTY_READ_ONLY, Boolean.class, METHOD_NAME_IS_READ_ONLY, METHOD_NAME_SET_READ_ONLY, new Class[]{Boolean.class});
        descr.substituteProperty(PROPERTY_FEATURE_FILTER, Map.class, METHOD_NAME_GET_FEATURE_FILTER, METHOD_NAME_SET_FEATURE_FILTER, new Class[]{String.class, FeatureSettingsFilter.class});
        descr.substituteProperty(PROPERTY_FILE_PATH, String.class, "getFilePath", "setFilePath", new Class[]{String.class});
        descr.substituteProperty(PROPERTY_FILE_EXTENSION, String.class, METHOD_NAME_GET_FILE_EXTENTION, METHOD_NAME_SET_FILE_EXTENTION, new Class[]{String.class});
        descr.setIncludes(new String[]{PROPERTY_PRESENTATION, PROPERTY_FORMAT, PROPERTY_FILE_EXTENSION, PROPERTY_FILE_PATH, PROPERTY_READ_ONLY, PROPERTY_FEATURE_FILTER, PROPERTY_SETTINGS, PROPERTY_VALIDATION});
        return descr;
    }

    private static TypeDescription createEditSettingsTypeDescription() {
        TypeDescription descr = new TypeDescription(EditSettings.class, new Tag(EditSettings.class));
        descr.setExcludes(new String[]{"storageIDs", "readOnly", "id", "featureFilter", "storageId", PROPERTY_SETTINGS});
        return descr;
    }

    private static TypeDescription createRuleSettingsTypeDescription() {
        TypeDescription descr = new TypeDescription(RuleSettings.class, new Tag(RuleSettings.class));
        descr.setExcludes(new String[]{"id"});
        return descr;
    }

    private static TypeDescription createFeatureSettingsFilterTypeDescription() {
        return new TypeDescription(FeatureSettingsFilter.class, new Tag(FeatureSettingsFilter.class)){

            public Object newInstance(Node node) {
                FeatureSettingsFilter value = null;
                if (node instanceof ScalarNode) {
                    String enumValueName = ((ScalarNode)node).getValue();
                    value = FeatureSettingsFilter.forName(enumValueName);
                }
                if (value == null) {
                    value = FeatureSettingsFilter.ANY;
                }
                return value;
            }
        };
    }

    public static Yaml createNewDumpYaml() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        options.setWidth(120);
        options.setPrettyFlow(true);
        NonAnchorRepresenter representer = new NonAnchorRepresenter();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        TypeDescription rootTypeDef = StorageSettingsUtils.createSettingsTypeDescription();
        Constructor cnstr = new Constructor(rootTypeDef);
        Yaml yaml = new Yaml((BaseConstructor)cnstr, (Representer)representer, options);
        yaml.setBeanAccess(BeanAccess.PROPERTY);
        cnstr.getPropertyUtils().setSkipMissingProperties(true);
        yaml.addTypeDescription(rootTypeDef);
        yaml.addTypeDescription(StorageSettingsUtils.createDictionaryStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createContextStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createFeatureSettingsFilterTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createStorageIdListTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createEditSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createRuleSettingsTypeDescription());
        representer.addClassTag(ProjectStorageSettings.class, Tag.MAP);
        representer.addClassTag(EditSettings.class, Tag.MAP);
        representer.addClassTag(StorageIdList.class, Tag.SEQ);
        representer.addClassTag(ContextStorageSettings.class, Tag.MAP);
        representer.addClassTag(DictionaryStorageSettings.class, Tag.MAP);
        representer.addClassTag(StorageSettings.class, Tag.MAP);
        representer.addClassTag(RuleSettings.class, Tag.MAP);
        return yaml;
    }

    public static Yaml createNewLoadYaml() {
        NonAnchorRepresenter representer = new NonAnchorRepresenter();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        TypeDescription rootTypeDef = StorageSettingsUtils.createSettingsTypeDescription();
        Constructor cnstr = new Constructor(rootTypeDef);
        Yaml yaml = new Yaml((BaseConstructor)cnstr, (Representer)representer);
        yaml.setBeanAccess(BeanAccess.PROPERTY);
        cnstr.getPropertyUtils().setSkipMissingProperties(true);
        yaml.addTypeDescription(rootTypeDef);
        yaml.addTypeDescription(StorageSettingsUtils.createDictionaryStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createContextStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createFeatureSettingsFilterTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createStorageIdListTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createEditSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createRuleSettingsTypeDescription());
        return yaml;
    }

    public static Constructor createNewSettingsConstructor() {
        Constructor cnstr = new Constructor(StorageSettingsUtils.createSettingsTypeDescription(), List.of(StorageSettingsUtils.createDictionaryStorageSettingsTypeDescription(), StorageSettingsUtils.createFeatureSettingsFilterTypeDescription(), StorageSettingsUtils.createStorageIdListTypeDescription(), StorageSettingsUtils.createEditSettingsTypeDescription(), StorageSettingsUtils.createRuleSettingsTypeDescription()));
        cnstr.getPropertyUtils().setSkipMissingProperties(true);
        return cnstr;
    }

    public static Yaml createNewValidatingYaml(final List<Pair<Node, Object>> mapping) {
        NonAnchorRepresenter representer = new NonAnchorRepresenter();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        TypeDescription rootTypeDef = StorageSettingsUtils.createSettingsTypeDescription();
        Constructor cnstr = new Constructor(rootTypeDef){

            protected Object constructObject(Node node) {
                Object result = super.constructObject(node);
                if (node != null) {
                    mapping.add(new Pair<Node, Object>(node, result));
                }
                return result;
            }
        };
        Yaml yaml = new Yaml((BaseConstructor)cnstr, (Representer)representer);
        yaml.setBeanAccess(BeanAccess.PROPERTY);
        cnstr.getPropertyUtils().setSkipMissingProperties(true);
        yaml.addTypeDescription(rootTypeDef);
        yaml.addTypeDescription(StorageSettingsUtils.createDictionaryStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createContextStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createStorageSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createFeatureSettingsFilterTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createStorageIdListTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createEditSettingsTypeDescription());
        yaml.addTypeDescription(StorageSettingsUtils.createRuleSettingsTypeDescription());
        return yaml;
    }

    private static TypeDescription createSettingsTypeDescription() {
        TypeDescription descr = new TypeDescription(ProjectStorageSettings.class, new Tag(ProjectStorageSettings.class));
        descr.addPropertyParameters("edit", new Class[]{EditSettings.class});
        descr.substituteProperty(PROPERTY_CONTEXT, Map.class, "getContext", "setContext", new Class[]{String.class, ContextStorageSettings.class});
        descr.substituteProperty(PROPERTY_DICTIONARY, Map.class, "getDictionary", "setDictionary", new Class[]{String.class, DictionaryStorageSettings.class});
        descr.substituteProperty(PROPERTY_STORAGE, Map.class, "getStorages", "setStorages", new Class[]{String.class, StorageSettings.class});
        descr.setIncludes(new String[]{"edit", PROPERTY_READ, PROPERTY_CONTEXT, PROPERTY_DICTIONARY, PROPERTY_STORAGE});
        return descr;
    }

    private static TypeDescription createStorageIdListTypeDescription() {
        TypeDescription descr = new TypeDescription(StorageIdList.class, new Tag(StorageIdList.class));
        descr.setExcludes(new String[]{"storageIds"});
        return descr;
    }

    private static TypeDescription createStorageSettingsTypeDescription() {
        TypeDescription descr = new TypeDescription(StorageSettings.class, new Tag(StorageSettings.class));
        descr.substituteProperty(PROPERTY_READ_ONLY, Boolean.class, METHOD_NAME_IS_READ_ONLY, METHOD_NAME_SET_READ_ONLY, new Class[]{Boolean.class});
        descr.substituteProperty(PROPERTY_FEATURE_FILTER, Map.class, METHOD_NAME_GET_FEATURE_FILTER, METHOD_NAME_SET_FEATURE_FILTER, new Class[]{String.class, FeatureSettingsFilter.class});
        descr.setIncludes(new String[]{PROPERTY_PRESENTATION, PROPERTY_READ_ONLY, PROPERTY_FEATURE_FILTER, PROPERTY_SETTINGS});
        return descr;
    }

    public static boolean getBooleanSettings(StorageSettings settings, String key, boolean defaultValue) {
        String value = settings.getSettings().get(key);
        if (StringUtils.isNotEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static int getIntSettings(ContextStorageSettings settings, String key, int defaultValue) {
        String value = settings.getSettings().get(key);
        if (StringUtils.isNotEmpty(value)) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static String getStringSettings(StorageSettings settings, String key, String defaultValue) {
        String value = settings.getSettings().get(key);
        if (StringUtils.isNotEmpty(value)) {
            return value;
        }
        return defaultValue;
    }

    public static ProjectStorageSettings loadStorageSettings(IFile file) {
        if (file.exists()) {
            Yaml yaml = StorageSettingsUtils.createNewLoadYaml();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream inputStream = file.getContents();){
                    return (ProjectStorageSettings)yaml.loadAs(inputStream, ProjectStorageSettings.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException | YAMLException e) {
                CorePlugin.logError(e);
            }
        }
        return null;
    }

    public static void saveStorageSettings(ProjectStorageSettings settings, IFile file, IProgressMonitor monitor) {
        if (settings == null) {
            return;
        }
        Yaml yaml = StorageSettingsUtils.createNewDumpYaml();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
                yaml.dump((Object)settings, (Writer)writer);
                ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
                if (file.exists()) {
                    file.setContents((InputStream)input, true, true, monitor);
                } else {
                    file.create((InputStream)input, true, monitor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            CorePlugin.logError(e);
        }
    }

    public static void validateStorageSettings(final IFile file, IProgressMonitor monitor) {
        if (!file.exists() || monitor.isCanceled()) {
            return;
        }
        try {
            file.deleteMarkers(MARKER_ID, true, 0);
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
        }
        final ArrayList<Pair<Node, Object>> mapping = new ArrayList<Pair<Node, Object>>();
        var messageAcceptor = new IMessageAcceptor(){
            private final List<MarkerInfo> markers = new ArrayList<MarkerInfo>();

            private void accept(String message, int line, int severenity) {
                MarkerInfo info = new MarkerInfo();
                info.vlaues = new Object[]{line, message, severenity, 2};
                this.markers.add(info);
            }

            @Override
            public void addError(Object object, int index, String message) {
                int line = object == null ? 1 : this.getLineByList(object, index);
                this.accept(message, line, 2);
            }

            @Override
            public void addError(Object object, String message) {
                int line = object == null ? 1 : this.getLineByObject(object);
                this.accept(message, line, 2);
            }

            @Override
            public void addError(String message, int line) {
                this.accept(message, line, 2);
            }

            @Override
            public void addWarning(Object object, int index, String message) {
                int line = object == null ? 1 : this.getLineByList(object, index);
                this.accept(message, line, 1);
            }

            @Override
            public void addWarning(Object object, String message) {
                int line = object == null ? 1 : this.getLineByObject(object);
                this.accept(message, line, 1);
            }

            @Override
            public void addWarning(String message, int line) {
                this.accept(message, line, 1);
            }

            public void flush(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.markers.size());
                try {
                    for (MarkerInfo info : this.markers) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        IMarker marker = file.createMarker(StorageSettingsUtils.MARKER_ID);
                        marker.setAttributes(MARKERY_ATTRIBUTES, info.vlaues);
                        subMonitor.worked(1);
                    }
                }
                catch (CoreException e) {
                    CorePlugin.logError(e);
                }
                subMonitor.done();
            }

            private int getLineByList(Object object, int index) {
                int i = 0;
                while (i < mapping.size()) {
                    Pair pair = (Pair)mapping.get(i);
                    if (pair.getValue() == object) {
                        if (object instanceof List && ((List)object).size() < i && ((List)object).size() > index) {
                            Object item = ((List)object).get(index);
                            int j = i;
                            while (j >= 0) {
                                Pair pair2 = (Pair)mapping.get(j);
                                if (pair2.getValue() == item) {
                                    return ((Node)pair2.getKey()).getStartMark().getLine() + 1;
                                }
                                --j;
                            }
                        }
                        return ((Node)pair.getKey()).getStartMark().getLine() + 1;
                    }
                    ++i;
                }
                return 1;
            }

            private int getLineByObject(Object object) {
                for (Pair pair : mapping) {
                    if (pair.getValue() != object) continue;
                    return ((Node)pair.getKey()).getStartMark().getLine() + 1;
                }
                return 1;
            }

            final class MarkerInfo {
                Object[] vlaues;

                MarkerInfo() {
                }
            }
        };
        Yaml yaml = StorageSettingsUtils.createNewValidatingYaml(mapping);
        ProjectStorageSettings model = null;
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (InputStream inputStream = file.getContents();){
                model = (ProjectStorageSettings)yaml.loadAs(inputStream, ProjectStorageSettings.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException | YAMLException e) {
            CorePlugin.logError(e);
            String message = MessageFormat.format(Messages.StorageSettingsUtils_Cannot_parse_yaml_settings__E, e.getLocalizedMessage());
            int line = 1;
            if (e instanceof MarkedYAMLException) {
                MarkedYAMLException marked = (MarkedYAMLException)e;
                if (marked.getProblemMark() != null) {
                    line = marked.getProblemMark().getLine() + 1;
                } else if (marked.getContextMark() != null) {
                    line = marked.getContextMark().getLine() + 1;
                }
            }
            messageAcceptor.addError(line, message);
        }
        StorageModelValidator validator = new StorageModelValidator(model, messageAcceptor);
        validator.validate(monitor);
        if (!monitor.isCanceled()) {
            messageAcceptor.flush(monitor);
        }
    }

    public static void appendFeatureSettingsByStorage(CommonFeatureSettings.Builder builder, StorageSettings settings) {
        FeatureSettingsFilter value = settings.getFeatureFilter().getOrDefault("id", FeatureSettingsFilter.ANY);
        if (value == FeatureSettingsFilter.ANY || value == FeatureSettingsFilter.ONLY) {
            builder.setId();
        }
        if ((value = settings.getFeatureFilter().getOrDefault(FEATURE_FILTER_MODEL, FeatureSettingsFilter.ANY)) == FeatureSettingsFilter.NONE) {
            builder.setInterface();
        }
        if ((value = settings.getFeatureFilter().getOrDefault(FEATURE_FILTER_CAMELCASE, FeatureSettingsFilter.ANY)) == FeatureSettingsFilter.ANY || value == FeatureSettingsFilter.ONLY) {
            builder.setCamelCase();
        }
        if ((value = settings.getFeatureFilter().getOrDefault(FEATURE_FILTER_MULTILINE, FeatureSettingsFilter.ANY)) == FeatureSettingsFilter.ANY || value == FeatureSettingsFilter.ONLY) {
            builder.setMultiLine();
        }
        if ((value = settings.getFeatureFilter().getOrDefault(FEATURE_FILTER_PREFERCONTEXT, FeatureSettingsFilter.ANY)) == FeatureSettingsFilter.ANY || value == FeatureSettingsFilter.ONLY) {
            builder.setPreferContext();
        }
    }

    private StorageSettingsUtils() {
    }

    private static class NonAnchorRepresenter
    extends Representer {
        public NonAnchorRepresenter() {
            this.multiRepresenters.put(Map.class, new SafeRepresenter.RepresentMap((SafeRepresenter)this){

                public Node representData(Object data) {
                    return this.representWithoutRecordingDescendents(data, object -> super.representData(object));
                }
            });
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null || propertyValue instanceof Collection && ((Collection)propertyValue).isEmpty() || propertyValue instanceof Map && ((Map)propertyValue).isEmpty()) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        protected Node representWithoutRecordingDescendents(Object data, Function<Object, Node> worker) {
            LinkedHashMap representedObjectsOnEntry = new LinkedHashMap(this.representedObjects);
            try {
                Node node = worker.apply(data);
                return node;
            }
            finally {
                this.representedObjects.clear();
                this.representedObjects.putAll(representedObjectsOnEntry);
            }
        }
    }
}

