/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.properties;

import com.e1c.langtool.internal.CorePlugin;
import com.e1c.langtool.storage.IFileEditor;
import com.e1c.langtool.storage.properties.LineReader;
import com.google.common.hash.HashFunction;
import com.google.common.hash.HashingOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractPropertiesFileEditor<T>
implements IFileEditor<T> {
    protected static final String FILE_COMMENT_PREFIX = "Translations for: ";
    protected final IFile file;
    protected volatile boolean dirty = false;

    protected AbstractPropertiesFileEditor(IFile file) {
        this.file = file;
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public synchronized void delete() {
        if (this.file != null && this.file.exists()) {
            try {
                this.file.delete(true, null);
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public byte[] save(HashFunction hashFunction, IProgressMonitor monitor) throws IOException {
        HashingOutputStream out;
        ByteArrayOutputStream byteOut;
        block5: {
            byteOut = new ByteArrayOutputStream();
            out = new HashingOutputStream(hashFunction, (OutputStream)byteOut);
            this.store((OutputStream)out);
            try {
                if (this.file.getProject().isAccessible()) break block5;
                return null;
            }
            catch (CoreException e) {
                CorePlugin.logError(e);
                return null;
            }
        }
        ByteArrayInputStream input = new ByteArrayInputStream(byteOut.toByteArray());
        if (this.file.exists()) {
            this.file.setContents((InputStream)input, true, true, monitor);
        } else {
            this.file.create((InputStream)input, true, monitor);
        }
        this.dirty = false;
        return out.hash().asBytes();
    }

    @Override
    public void save(IProgressMonitor monitor) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.store(out);
        try {
            if (!this.file.getProject().isAccessible()) {
                return;
            }
            ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
            if (this.file.exists()) {
                this.file.setContents((InputStream)input, true, true, monitor);
            } else {
                this.file.create((InputStream)input, true, monitor);
            }
            this.dirty = false;
        }
        catch (CoreException e) {
            CorePlugin.logError(e);
        }
    }

    public void store(Writer writer) throws IOException {
        this.storeInternal(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), false);
    }

    protected abstract void storeInternal(BufferedWriter var1, boolean var2) throws IOException;

    public void store(OutputStream out) throws IOException {
        this.storeInternal(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)), false);
    }

    @Override
    public void load() {
        this.dirty = false;
        if (this.file == null || !this.file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStreamReader reader = new InputStreamReader(this.file.getContents(), StandardCharsets.UTF_8);){
                this.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            CorePlugin.logError(e);
        }
    }

    public synchronized void load(Reader reader) throws IOException {
        this.loadInternal(new LineReader(reader));
    }

    protected abstract void loadInternal(LineReader var1) throws IOException;

    protected String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    protected String saveConvert(String theString, boolean escapeSpaceAndDot) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': 
                    case '.': {
                        if (x == 0 || escapeSpaceAndDot) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(aChar);
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        if (x + 1 != len && theString.charAt(x + 1) == '\n') break;
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    protected static void writeComments(BufferedWriter bw, String comments) throws IOException {
        bw.write("#");
        int len = comments.length();
        int current = 0;
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        while (current < len) {
            char c = comments.charAt(current);
            if (c == '\n' || c == '\r') {
                if (last != current) {
                    bw.write(comments.substring(last, current));
                }
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
                last = current + 1;
            }
            ++current;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }
}

