/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class LineReader {
    byte[] inByteBuf;
    char[] inCharBuf;
    char[] lineBuf = new char[1024];
    int inLimit = 0;
    int inOff = 0;
    InputStream inStream;
    Reader reader;
    String comment = null;
    char[] commentBuf = new char[1024];

    public LineReader(InputStream inStream) {
        this.inStream = inStream;
        this.inByteBuf = new byte[8192];
    }

    public LineReader(Reader reader) {
        this.reader = reader;
        this.inCharBuf = new char[8192];
    }

    int readLine() throws IOException {
        int len = 0;
        char c = '\u0000';
        this.commentBuf = new char[1024];
        this.comment = null;
        boolean skipWhiteSpace = true;
        boolean isCommentLine = false;
        boolean isNewLine = true;
        boolean appendedLineBegin = false;
        boolean precedingBackslash = false;
        boolean skipLF = false;
        while (true) {
            if (this.inOff >= this.inLimit) {
                this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                this.inOff = 0;
                if (this.inLimit <= 0) {
                    if (len == 0 || isCommentLine) {
                        return -1;
                    }
                    if (precedingBackslash) {
                        --len;
                    }
                    return len;
                }
            }
            c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
            if (skipLF) {
                skipLF = false;
                if (c == '\n') continue;
            }
            if (skipWhiteSpace) {
                if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                skipWhiteSpace = false;
                appendedLineBegin = false;
            }
            if (isNewLine) {
                isNewLine = false;
                if (c == '#' || c == '!') {
                    if (isCommentLine) {
                        this.commentBuf[len++] = 10;
                        this.commentBuf = this.increaseBuffer(this.commentBuf, len);
                    } else {
                        this.commentBuf = new char[1024];
                    }
                    isCommentLine = true;
                    skipWhiteSpace = true;
                    appendedLineBegin = true;
                    continue;
                }
                if (isCommentLine) {
                    this.comment = new String(this.commentBuf, 0, len);
                    this.commentBuf = new char[1024];
                    len = 0;
                } else {
                    this.comment = null;
                    this.commentBuf = new char[1024];
                }
                isCommentLine = false;
            }
            if (c != '\n' && c != '\r') {
                if (isCommentLine) {
                    this.commentBuf[len++] = c;
                    this.commentBuf = this.increaseBuffer(this.commentBuf, len);
                } else {
                    this.lineBuf[len++] = c;
                    this.lineBuf = this.increaseBuffer(this.lineBuf, len);
                }
                if (c == '\\' && !isCommentLine) {
                    precedingBackslash = !precedingBackslash;
                    continue;
                }
                precedingBackslash = false;
                continue;
            }
            if (isCommentLine || len == 0) {
                isNewLine = true;
                skipWhiteSpace = true;
                if (isCommentLine) {
                    appendedLineBegin = true;
                }
                if (c != '\r') continue;
                skipLF = true;
                continue;
            }
            if (this.inOff >= this.inLimit) {
                this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                this.inOff = 0;
                if (this.inLimit <= 0) {
                    if (precedingBackslash) {
                        --len;
                    }
                    return len;
                }
            }
            if (!precedingBackslash) break;
            --len;
            skipWhiteSpace = true;
            appendedLineBegin = true;
            precedingBackslash = false;
            if (c != '\r') continue;
            skipLF = true;
        }
        return len;
    }

    private char[] increaseBuffer(char[] currentBuf, int len) {
        if (len == currentBuf.length) {
            int newLength = currentBuf.length * 2;
            if (newLength < 0) {
                newLength = Integer.MAX_VALUE;
            }
            char[] buf = new char[newLength];
            System.arraycopy(currentBuf, 0, buf, 0, currentBuf.length);
            return buf;
        }
        return currentBuf;
    }
}

