/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.properties;

import com.e1c.langtool.ContextTranslationKey;
import com.e1c.langtool.collector.FeatureKey;
import com.e1c.langtool.collector.SegmentFeatureKey;
import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.platform.TranslateLanguage;
import com.e1c.langtool.storage.model.ContextStorageSettings;
import com.e1c.langtool.storage.model.StorageSettingsUtils;
import com.e1c.langtool.storage.properties.AbstractPropertiesFileEditor;
import com.e1c.langtool.storage.properties.FeatureKeyContextData;
import com.e1c.langtool.storage.properties.LineReader;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class PropertiesContextFileEditor
extends AbstractPropertiesFileEditor<FeatureKeyContextData> {
    private final FeatureKeyContextData data;

    public PropertiesContextFileEditor(IFile file, IProject project, ContextStorageSettings settings, TranslateLanguage language) {
        super(file);
        boolean valueUnique = StorageSettingsUtils.getBooleanSettings(settings, "value_unique", true);
        boolean keyCaseSensitive = StorageSettingsUtils.getBooleanSettings(settings, "key_case_sensitve", false);
        boolean valueCaseSensitive = StorageSettingsUtils.getBooleanSettings(settings, "value_case_sensitive", false);
        String comment = "Translations for: " + settings.getId();
        this.data = valueUnique ? new UniqueValueContextData(keyCaseSensitive, valueCaseSensitive, comment) : new FeatureKeyContextData(keyCaseSensitive, valueCaseSensitive, comment, this::markDirty);
    }

    @Override
    public boolean isEmpty() {
        return this.data.storage.isEmpty();
    }

    @Override
    public void load() {
        this.data.storage.clear();
        this.data.comments.clear();
        super.load();
    }

    @Override
    public FeatureKeyContextData getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeInternal(BufferedWriter bw, boolean escUnicode) throws IOException {
        if (this.data.getComment() != null) {
            PropertiesContextFileEditor.writeComments(bw, this.data.getComment());
            bw.newLine();
        }
        PropertiesContextFileEditor propertiesContextFileEditor = this;
        synchronized (propertiesContextFileEditor) {
            ArrayList<FeatureKey> keys = new ArrayList<FeatureKey>(this.data.storage.keySet());
            keys.sort(null);
            boolean firstLine = true;
            for (FeatureKey key : keys) {
                String keyComment = this.data.comments.get(key);
                if (!StringUtils.isBlank(keyComment)) {
                    if (!firstLine) {
                        bw.newLine();
                    }
                    String[] lines = keyComment.split(System.lineSeparator());
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        PropertiesContextFileEditor.writeComments(bw, " " + line);
                        ++i;
                    }
                    firstLine = false;
                }
                String val = this.data.storage.get(key);
                String keyString = null;
                int segmentCount = key.getSegmentCount();
                switch (segmentCount) {
                    case 0: {
                        keyString = "";
                        break;
                    }
                    case 1: {
                        keyString = this.saveConvert(key.getFirstSegment(), true);
                        break;
                    }
                    default: {
                        StringBuilder builder = new StringBuilder();
                        builder.append(this.saveConvert(key.getFirstSegment(), true));
                        int i = 1;
                        while (i < segmentCount) {
                            builder.append('.');
                            builder.append(this.saveConvert(key.getSegment(i), true));
                            ++i;
                        }
                        keyString = builder.toString();
                    }
                }
                if (val == null) {
                    val = "";
                }
                val = this.saveConvert(val, false);
                bw.write(keyString + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    @Override
    protected void loadInternal(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            char c = '\u0000';
            int keyLen = 0;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            while (keyLen < limit) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                ++keyLen;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            FeatureKey key = this.loadConvertKey(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            if (System.lineSeparator() != "\n") {
                value = value.replace("\n", System.lineSeparator());
            }
            this.data.storage.put(key, value);
            if (lr.comment == null) continue;
            String keyComment = String.join((CharSequence)System.lineSeparator(), lr.comment.split("\\n"));
            this.data.comments.put(key, keyComment);
        }
    }

    private FeatureKey loadConvertKey(char[] in, int off, int len, char[] convtBuf) {
        ArrayList segments = Lists.newArrayList();
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 116) {
                    aChar = 9;
                } else {
                    if (aChar == 114) continue;
                    if (aChar == 110) {
                        aChar = 10;
                    } else if (aChar == 102) {
                        aChar = 12;
                    }
                }
                out[outLen++] = aChar;
                continue;
            }
            if (aChar == 46) {
                segments.add(new String(out, 0, outLen));
                out = convtBuf;
                outLen = 0;
                continue;
            }
            out[outLen++] = aChar;
        }
        if (outLen > 0) {
            segments.add(new String(out, 0, outLen));
        }
        return SegmentFeatureKey.create(segments);
    }

    private final class UniqueValueContextData
    extends FeatureKeyContextData {
        public UniqueValueContextData(boolean keyCaseSensitive, boolean valueCaseSensitive, String comment) {
            super(keyCaseSensitive, valueCaseSensitive, comment, PropertiesContextFileEditor.this::markDirty);
        }

        @Override
        public String setTranslation(ContextTranslationKey translationKey, String value, String comment) {
            String result = super.setTranslation(translationKey, value, comment);
            return result;
        }

        @Override
        public String removeTranslation(ContextTranslationKey translationKey) {
            String result = super.removeTranslation(translationKey);
            return result;
        }
    }
}

