/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.storage.regex.model;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.storage.regex.RegExUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExItem
implements Serializable {
    private static final long serialVersionUID = 6221217984347950197L;
    public static final String PROPERTY_GROUPS_FROM_STORAGE = "groupsFromStorage";
    public static final String PROPERTY_TEST_STRING = "testString";
    public static final String PROPERTY_TRANSLATION = "translation";
    public static final String PROPERTY_INTERFACE = "interface";
    public static final String PROPERTY_REG_EX = "regEx";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_MODEL = "model";
    private transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private String description;
    private String regEx;
    private String testString;
    private boolean isModel;
    private boolean isInterface;
    private List<String> groupsFromStorage;
    private String translation;
    private transient boolean valided;
    private transient boolean valid;
    private transient Pattern pattern;
    private transient boolean patternInited;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;
        this.changeSupport.firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
    }

    public String getRegEx() {
        return this.regEx;
    }

    public void setRegEx(String regEx) {
        String oldValue = this.regEx;
        this.regEx = regEx;
        this.markInvalidate();
        this.changeSupport.firePropertyChange(PROPERTY_REG_EX, oldValue, regEx);
        this.initializePattern();
    }

    public boolean isModel() {
        return this.isModel;
    }

    public void setModel(boolean model) {
        boolean oldValue = this.isModel;
        this.isModel = model;
        this.markInvalidate();
        this.changeSupport.firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        boolean oldValue = this.isInterface;
        this.isInterface = isInterface;
        this.markInvalidate();
        this.changeSupport.firePropertyChange(PROPERTY_INTERFACE, oldValue, isInterface);
    }

    public boolean isValid() {
        if (!this.valided) {
            this.valid = false;
            this.valided = true;
            if (StringUtils.isBlank(this.getRegEx())) {
                return this.valid;
            }
            if (StringUtils.isBlank(this.getTranslation())) {
                return this.valid;
            }
            if (StringUtils.isBlank(this.getTestString())) {
                return this.valid;
            }
            if (!this.isInterface() && !this.isModel()) {
                return this.valid;
            }
            if (this.getPattern() == null) {
                return this.valid;
            }
            List<String> groups = RegExUtil.getRegExGroups(this);
            if (!this.getGroupsFromStorage().isEmpty() && groups.isEmpty()) {
                return this.valid;
            }
            for (String group : this.getGroupsFromStorage()) {
                if (groups.contains(group)) continue;
                return this.valid;
            }
            this.valid = true;
        }
        return this.valid;
    }

    public Pattern getPattern() {
        if (!this.patternInited) {
            this.initializePattern();
        }
        return this.pattern;
    }

    private void initializePattern() {
        this.pattern = null;
        try {
            this.pattern = StringUtils.isBlank(this.regEx) ? null : Pattern.compile(this.regEx);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        this.patternInited = true;
    }

    public List<String> getGroupsFromStorage() {
        if (this.groupsFromStorage == null) {
            this.groupsFromStorage = new ArrayList<String>();
        }
        return this.groupsFromStorage;
    }

    public void setGroupsFromStorage(List<String> groupsFromStorage) {
        List<String> oldValue = this.groupsFromStorage;
        this.groupsFromStorage = groupsFromStorage;
        this.markInvalidate();
        this.changeSupport.firePropertyChange(PROPERTY_GROUPS_FROM_STORAGE, oldValue, groupsFromStorage);
    }

    public String getTranslation() {
        return this.translation;
    }

    public void setTranslation(String translation) {
        String oldValue = this.translation;
        this.translation = translation;
        this.markInvalidate();
        this.changeSupport.firePropertyChange(PROPERTY_TRANSLATION, oldValue, translation);
    }

    public String getTestString() {
        return this.testString;
    }

    public void setTestString(String testString) {
        String oldValue = this.testString;
        this.testString = testString;
        this.markInvalidate();
        this.changeSupport.firePropertyChange(PROPERTY_TEST_STRING, oldValue, testString);
    }

    private void markInvalidate() {
        this.valided = false;
    }
}

