/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.flags.ui;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.internal.flags.ui.FlagsPlugin;
import com.e1c.langtool.internal.flags.ui.LanguageCountriesPreferenceInitializer;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class SharedImages {
    private static final String T_OBJ16 = "/obj16/";
    public static final String IMG_OBJ16_DEFAULT = "com.e1c.langtool.flags.ui/obj16/default.png";
    private static final String ICONS_PATH = "/icons";
    private static Map<String, String> countryFlags;

    public static void initializeImageRegistry(ImageRegistry reg) {
        reg.put(IMG_OBJ16_DEFAULT, SharedImages.createImageDescriptorFromKey(IMG_OBJ16_DEFAULT));
    }

    public static Collection<String> getCountryCodes() {
        return SharedImages.getCountryFlags().keySet();
    }

    public static Collection<String> getLanguageCodes() {
        return LanguageCountriesPreferenceInitializer.getDefaultLanguageCountries().keySet();
    }

    public static Image getLanguageFlagImage(IProject project, String languageCode) {
        String key = SharedImages.getLanguageFlagImageSymbolicName(languageCode, project);
        Image image = FlagsPlugin.getDefault().getImageRegistry().get(key);
        if (image == null) {
            FlagsPlugin.getDefault().getImageRegistry().put(key, SharedImages.createImageDescriptorFromKey(key));
        }
        return FlagsPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getLanguageFlagImageDescriptor(IProject project, String languageCode) {
        String key = SharedImages.getLanguageFlagImageSymbolicName(languageCode, project);
        ImageDescriptor descriptor = FlagsPlugin.getDefault().getImageRegistry().getDescriptor(key);
        if (descriptor == null) {
            FlagsPlugin.getDefault().getImageRegistry().put(key, SharedImages.createImageDescriptorFromKey(key));
        }
        return FlagsPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Image getLanguageFlagImage(String languageCode) {
        Image image = FlagsPlugin.getDefault().getImageRegistry().get(languageCode);
        if (image != null) {
            return image;
        }
        String symbolicName = SharedImages.getLanguageFlagImageSymbolicName(languageCode);
        return SharedImages.getImage(symbolicName);
    }

    public static Image getCountryFlagImage(String countryCode) {
        String key = SharedImages.getFlagSymbolicName(countryCode);
        return SharedImages.getImage(key);
    }

    public static Image getImage(String symbolicName) {
        Image image = FlagsPlugin.getDefault().getImageRegistry().get(symbolicName);
        if (image != null) {
            return image;
        }
        FlagsPlugin.getDefault().getImageRegistry().put(symbolicName, SharedImages.createImageDescriptorFromKey(symbolicName));
        return FlagsPlugin.getDefault().getImageRegistry().get(symbolicName);
    }

    public static ImageDescriptor getImageDescriptor(String symbolicName) {
        ImageDescriptor descriptor = FlagsPlugin.getDefault().getImageRegistry().getDescriptor(symbolicName);
        if (descriptor != null) {
            return descriptor;
        }
        String key = SharedImages.getLanguageFlagImageSymbolicName(symbolicName);
        descriptor = FlagsPlugin.getDefault().getImageRegistry().getDescriptor(key);
        if (descriptor == null) {
            FlagsPlugin.getDefault().getImageRegistry().put(key, SharedImages.createImageDescriptorFromKey(key));
        }
        return FlagsPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    private static ImageDescriptor createImageDescriptorFromKey(String key) {
        String path = ICONS_PATH + key.substring("com.e1c.langtool.flags.ui".length());
        return FlagsPlugin.imageDescriptorFromPlugin((String)"com.e1c.langtool.flags.ui", (String)path);
    }

    private static String getLanguageFlagImageSymbolicName(String languageTag, IProject project) {
        IPreferenceStore prefs = FlagsPlugin.getDefault().getPreferenceStore(project);
        String countryCode = prefs.getString(languageTag);
        if (countryCode != null) {
            return SharedImages.getFlagSymbolicName(countryCode);
        }
        Locale locale = Locale.forLanguageTag(languageTag.replace("_", "-"));
        String country = locale.getCountry();
        if (country != null && country.trim().length() > 0) {
            country = country.trim().toUpperCase();
        } else {
            String language = locale.getLanguage();
            if (language != null && language.trim().length() > 0) {
                country = prefs.getString(language);
            }
        }
        return SharedImages.getFlagSymbolicName(country);
    }

    private static String getLanguageFlagImageSymbolicName(String languageTag) {
        IPreferenceStore prefs = FlagsPlugin.getDefault().getPreferenceStore();
        String country = prefs.getString(languageTag);
        if (country != null) {
            return SharedImages.getFlagSymbolicName(country);
        }
        Locale locale = Locale.forLanguageTag(languageTag.replace("_", "-"));
        country = locale.getCountry();
        if (country != null && country.trim().length() > 0) {
            country = country.trim().toUpperCase();
        } else {
            String language = locale.getLanguage();
            if (language != null && language.trim().length() > 0) {
                country = prefs.getString(language);
            }
        }
        return SharedImages.getFlagSymbolicName(country);
    }

    private static String getFlagSymbolicName(String country) {
        if (StringUtils.isBlank((String)country)) {
            return IMG_OBJ16_DEFAULT;
        }
        String icon = SharedImages.getCountryFlags().get(country);
        if (icon != null) {
            return "com.e1c.langtool.flags.ui/obj16/" + icon;
        }
        return IMG_OBJ16_DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getCountryFlags() {
        if (countryFlags != null) {
            return countryFlags;
        }
        Class<SharedImages> clazz = SharedImages.class;
        synchronized (SharedImages.class) {
            if (countryFlags != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return countryFlags;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"AC", (Object)"ac.png");
            builder.put((Object)"AD", (Object)"ad.png");
            builder.put((Object)"AE", (Object)"ae.png");
            builder.put((Object)"AF", (Object)"af.png");
            builder.put((Object)"AG", (Object)"ag.png");
            builder.put((Object)"AI", (Object)"ai.png");
            builder.put((Object)"AL", (Object)"al.png");
            builder.put((Object)"AM", (Object)"am.png");
            builder.put((Object)"AN", (Object)"an.png");
            builder.put((Object)"AO", (Object)"ao.png");
            builder.put((Object)"AQ", (Object)"aq.png");
            builder.put((Object)"AR", (Object)"ar.png");
            builder.put((Object)"AS", (Object)"as.png");
            builder.put((Object)"AT", (Object)"at.png");
            builder.put((Object)"AU", (Object)"au.png");
            builder.put((Object)"AW", (Object)"aw.png");
            builder.put((Object)"AX", (Object)"ax.png");
            builder.put((Object)"AZ", (Object)"az.png");
            builder.put((Object)"BA", (Object)"ba.png");
            builder.put((Object)"BB", (Object)"bb.png");
            builder.put((Object)"BD", (Object)"bd.png");
            builder.put((Object)"BE", (Object)"be.png");
            builder.put((Object)"BF", (Object)"bf.png");
            builder.put((Object)"BG", (Object)"bg.png");
            builder.put((Object)"BH", (Object)"bh.png");
            builder.put((Object)"BI", (Object)"bi.png");
            builder.put((Object)"BJ", (Object)"bj.png");
            builder.put((Object)"BL", (Object)"bl.png");
            builder.put((Object)"BM", (Object)"bm.png");
            builder.put((Object)"BN", (Object)"bn.png");
            builder.put((Object)"BO", (Object)"bo.png");
            builder.put((Object)"BQ", (Object)"bq.png");
            builder.put((Object)"BR", (Object)"br.png");
            builder.put((Object)"BS", (Object)"bs.png");
            builder.put((Object)"BT", (Object)"bt.png");
            builder.put((Object)"BV", (Object)"bv.png");
            builder.put((Object)"BW", (Object)"bw.png");
            builder.put((Object)"BY", (Object)"by.png");
            builder.put((Object)"BZ", (Object)"bz.png");
            builder.put((Object)"CA", (Object)"ca.png");
            builder.put((Object)"CAT", (Object)"cat.png");
            builder.put((Object)"CC", (Object)"cc.png");
            builder.put((Object)"CD", (Object)"cd.png");
            builder.put((Object)"CF", (Object)"cf.png");
            builder.put((Object)"CG", (Object)"cg.png");
            builder.put((Object)"CH", (Object)"ch.png");
            builder.put((Object)"CI", (Object)"ci.png");
            builder.put((Object)"CK", (Object)"ck.png");
            builder.put((Object)"CL", (Object)"cl.png");
            builder.put((Object)"CM", (Object)"cm.png");
            builder.put((Object)"CN", (Object)"cn.png");
            builder.put((Object)"CO", (Object)"co.png");
            builder.put((Object)"CR", (Object)"cr.png");
            builder.put((Object)"CS", (Object)"cs.png");
            builder.put((Object)"CU", (Object)"cu.png");
            builder.put((Object)"CV", (Object)"cv.png");
            builder.put((Object)"CW", (Object)"cw.png");
            builder.put((Object)"CX", (Object)"cx.png");
            builder.put((Object)"CY", (Object)"cy.png");
            builder.put((Object)"CZ", (Object)"cz.png");
            builder.put((Object)"DD", (Object)"dd.png");
            builder.put((Object)"DE", (Object)"de.png");
            builder.put((Object)"DJ", (Object)"dj.png");
            builder.put((Object)"DK", (Object)"dk.png");
            builder.put((Object)"DM", (Object)"dm.png");
            builder.put((Object)"DO", (Object)"do.png");
            builder.put((Object)"DZ", (Object)"dz.png");
            builder.put((Object)"EC", (Object)"ec.png");
            builder.put((Object)"EE", (Object)"ee.png");
            builder.put((Object)"EG", (Object)"eg.png");
            builder.put((Object)"EH", (Object)"eh.png");
            builder.put((Object)"ER", (Object)"er.png");
            builder.put((Object)"ES", (Object)"es.png");
            builder.put((Object)"ET", (Object)"et.png");
            builder.put((Object)"EU", (Object)"eu.png");
            builder.put((Object)"FI", (Object)"fi.png");
            builder.put((Object)"FJ", (Object)"fj.png");
            builder.put((Object)"FK", (Object)"fk.png");
            builder.put((Object)"FM", (Object)"fm.png");
            builder.put((Object)"FO", (Object)"fo.png");
            builder.put((Object)"FR", (Object)"fr.png");
            builder.put((Object)"FX", (Object)"fx.png");
            builder.put((Object)"GA", (Object)"ga.png");
            builder.put((Object)"GB", (Object)"gb.png");
            builder.put((Object)"GD", (Object)"gd.png");
            builder.put((Object)"GE", (Object)"ge.png");
            builder.put((Object)"GF", (Object)"gf.png");
            builder.put((Object)"GG", (Object)"gg.png");
            builder.put((Object)"GH", (Object)"gh.png");
            builder.put((Object)"GI", (Object)"gi.png");
            builder.put((Object)"GL", (Object)"gl.png");
            builder.put((Object)"GM", (Object)"gm.png");
            builder.put((Object)"GN", (Object)"gn.png");
            builder.put((Object)"GP", (Object)"gp.png");
            builder.put((Object)"GQ", (Object)"gq.png");
            builder.put((Object)"GR", (Object)"gr.png");
            builder.put((Object)"GS", (Object)"gs.png");
            builder.put((Object)"GT", (Object)"gt.png");
            builder.put((Object)"GU", (Object)"gu.png");
            builder.put((Object)"GW", (Object)"gw.png");
            builder.put((Object)"GY", (Object)"gy.png");
            builder.put((Object)"HK", (Object)"hk.png");
            builder.put((Object)"HM", (Object)"hm.png");
            builder.put((Object)"HN", (Object)"hn.png");
            builder.put((Object)"HR", (Object)"hr.png");
            builder.put((Object)"HT", (Object)"ht.png");
            builder.put((Object)"HU", (Object)"hu.png");
            builder.put((Object)"ID", (Object)"id.png");
            builder.put((Object)"IE", (Object)"ie.png");
            builder.put((Object)"IL", (Object)"il.png");
            builder.put((Object)"IM", (Object)"im.png");
            builder.put((Object)"IN", (Object)"in.png");
            builder.put((Object)"IO", (Object)"io.png");
            builder.put((Object)"IQ", (Object)"iq.png");
            builder.put((Object)"IR", (Object)"ir.png");
            builder.put((Object)"IS", (Object)"is.png");
            builder.put((Object)"IT", (Object)"it.png");
            builder.put((Object)"JE", (Object)"je.png");
            builder.put((Object)"JM", (Object)"jm.png");
            builder.put((Object)"JO", (Object)"jo.png");
            builder.put((Object)"JP", (Object)"jp.png");
            builder.put((Object)"KE", (Object)"ke.png");
            builder.put((Object)"KG", (Object)"kg.png");
            builder.put((Object)"KH", (Object)"kh.png");
            builder.put((Object)"KI", (Object)"ki.png");
            builder.put((Object)"KM", (Object)"km.png");
            builder.put((Object)"KN", (Object)"kn.png");
            builder.put((Object)"KP", (Object)"kp.png");
            builder.put((Object)"KR", (Object)"kr.png");
            builder.put((Object)"KW", (Object)"kw.png");
            builder.put((Object)"KY", (Object)"ky.png");
            builder.put((Object)"KZ", (Object)"kz.png");
            builder.put((Object)"LA", (Object)"la.png");
            builder.put((Object)"LB", (Object)"lb.png");
            builder.put((Object)"LC", (Object)"lc.png");
            builder.put((Object)"LI", (Object)"li.png");
            builder.put((Object)"LK", (Object)"lk.png");
            builder.put((Object)"LR", (Object)"lr.png");
            builder.put((Object)"LS", (Object)"ls.png");
            builder.put((Object)"LT", (Object)"lt.png");
            builder.put((Object)"LU", (Object)"lu.png");
            builder.put((Object)"LV", (Object)"lv.png");
            builder.put((Object)"LY", (Object)"ly.png");
            builder.put((Object)"MA", (Object)"ma.png");
            builder.put((Object)"MC", (Object)"mc.png");
            builder.put((Object)"MD", (Object)"md.png");
            builder.put((Object)"ME", (Object)"me.png");
            builder.put((Object)"MF", (Object)"mf.png");
            builder.put((Object)"MG", (Object)"mg.png");
            builder.put((Object)"MH", (Object)"mh.png");
            builder.put((Object)"MK", (Object)"mk.png");
            builder.put((Object)"ML", (Object)"ml.png");
            builder.put((Object)"MM", (Object)"mm.png");
            builder.put((Object)"MN", (Object)"mn.png");
            builder.put((Object)"MO", (Object)"mo.png");
            builder.put((Object)"MP", (Object)"mp.png");
            builder.put((Object)"MQ", (Object)"mq.png");
            builder.put((Object)"MR", (Object)"mr.png");
            builder.put((Object)"MS", (Object)"ms.png");
            builder.put((Object)"MT", (Object)"mt.png");
            builder.put((Object)"MU", (Object)"mu.png");
            builder.put((Object)"MV", (Object)"mv.png");
            builder.put((Object)"MW", (Object)"mw.png");
            builder.put((Object)"MX", (Object)"mx.png");
            builder.put((Object)"MY", (Object)"my.png");
            builder.put((Object)"MZ", (Object)"mz.png");
            builder.put((Object)"NA", (Object)"na.png");
            builder.put((Object)"NC", (Object)"nc.png");
            builder.put((Object)"NE", (Object)"ne.png");
            builder.put((Object)"NF", (Object)"nf.png");
            builder.put((Object)"NG", (Object)"ng.png");
            builder.put((Object)"NI", (Object)"ni.png");
            builder.put((Object)"NL", (Object)"nl.png");
            builder.put((Object)"NO", (Object)"no.png");
            builder.put((Object)"NP", (Object)"np.png");
            builder.put((Object)"NR", (Object)"nr.png");
            builder.put((Object)"NU", (Object)"nu.png");
            builder.put((Object)"NZ", (Object)"nz.png");
            builder.put((Object)"OM", (Object)"om.png");
            builder.put((Object)"PA", (Object)"pa.png");
            builder.put((Object)"PE", (Object)"pe.png");
            builder.put((Object)"PF", (Object)"pf.png");
            builder.put((Object)"PG", (Object)"pg.png");
            builder.put((Object)"PH", (Object)"ph.png");
            builder.put((Object)"PK", (Object)"pk.png");
            builder.put((Object)"PL", (Object)"pl.png");
            builder.put((Object)"PM", (Object)"pm.png");
            builder.put((Object)"PN", (Object)"pn.png");
            builder.put((Object)"PR", (Object)"pr.png");
            builder.put((Object)"PS", (Object)"ps.png");
            builder.put((Object)"PT", (Object)"pt.png");
            builder.put((Object)"PW", (Object)"pw.png");
            builder.put((Object)"PY", (Object)"py.png");
            builder.put((Object)"QA", (Object)"qa.png");
            builder.put((Object)"RE", (Object)"re.png");
            builder.put((Object)"RO", (Object)"ro.png");
            builder.put((Object)"RS", (Object)"rs.png");
            builder.put((Object)"RU", (Object)"ru.png");
            builder.put((Object)"RW", (Object)"rw.png");
            builder.put((Object)"SA", (Object)"sa.png");
            builder.put((Object)"SB", (Object)"sb.png");
            builder.put((Object)"SC", (Object)"sc.png");
            builder.put((Object)"SD", (Object)"sd.png");
            builder.put((Object)"SE", (Object)"se.png");
            builder.put((Object)"SG", (Object)"sg.png");
            builder.put((Object)"SH", (Object)"sh.png");
            builder.put((Object)"SI", (Object)"si.png");
            builder.put((Object)"SJ", (Object)"sj.png");
            builder.put((Object)"SK", (Object)"sk.png");
            builder.put((Object)"SL", (Object)"sl.png");
            builder.put((Object)"SM", (Object)"sm.png");
            builder.put((Object)"SN", (Object)"sn.png");
            builder.put((Object)"SO", (Object)"so.png");
            builder.put((Object)"SR", (Object)"sr.png");
            builder.put((Object)"SS", (Object)"ss.png");
            builder.put((Object)"ST", (Object)"st.png");
            builder.put((Object)"SU", (Object)"su.png");
            builder.put((Object)"SV", (Object)"sv.png");
            builder.put((Object)"SX", (Object)"sx.png");
            builder.put((Object)"SY", (Object)"sy.png");
            builder.put((Object)"SZ", (Object)"sz.png");
            builder.put((Object)"TC", (Object)"tc.png");
            builder.put((Object)"TD", (Object)"td.png");
            builder.put((Object)"TF", (Object)"tf.png");
            builder.put((Object)"TG", (Object)"tg.png");
            builder.put((Object)"TH", (Object)"th.png");
            builder.put((Object)"TJ", (Object)"tj.png");
            builder.put((Object)"TK", (Object)"tk.png");
            builder.put((Object)"TL", (Object)"tl.png");
            builder.put((Object)"TM", (Object)"tm.png");
            builder.put((Object)"TN", (Object)"tn.png");
            builder.put((Object)"TO", (Object)"to.png");
            builder.put((Object)"TP", (Object)"tp.png");
            builder.put((Object)"TR", (Object)"tr.png");
            builder.put((Object)"TT", (Object)"tt.png");
            builder.put((Object)"TV", (Object)"tv.png");
            builder.put((Object)"TW", (Object)"tw.png");
            builder.put((Object)"TZ", (Object)"tz.png");
            builder.put((Object)"UA", (Object)"ua.png");
            builder.put((Object)"UG", (Object)"ug.png");
            builder.put((Object)"UK", (Object)"uk.png");
            builder.put((Object)"UM", (Object)"um.png");
            builder.put((Object)"US", (Object)"us.png");
            builder.put((Object)"UY", (Object)"uy.png");
            builder.put((Object)"UZ", (Object)"uz.png");
            builder.put((Object)"VA", (Object)"va.png");
            builder.put((Object)"VC", (Object)"vc.png");
            builder.put((Object)"VE", (Object)"ve.png");
            builder.put((Object)"VG", (Object)"vg.png");
            builder.put((Object)"VI", (Object)"vi.png");
            builder.put((Object)"VN", (Object)"vn.png");
            builder.put((Object)"VU", (Object)"vu.png");
            builder.put((Object)"WF", (Object)"wf.png");
            builder.put((Object)"WS", (Object)"ws.png");
            builder.put((Object)"YE", (Object)"ye.png");
            builder.put((Object)"YT", (Object)"yt.png");
            builder.put((Object)"YU", (Object)"yu.png");
            builder.put((Object)"ZA", (Object)"za.png");
            builder.put((Object)"ZM", (Object)"zm.png");
            builder.put((Object)"ZR", (Object)"zr.png");
            builder.put((Object)"ZW", (Object)"zw.png");
            builder.put((Object)"", (Object)"default.png");
            countryFlags = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return countryFlags;
        }
    }
}

