/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.flags.ui;

import com.e1c.langtool.internal.flags.ui.FlagsPlugin;
import com.e1c.langtool.internal.flags.ui.LanguageDefaultFlagsComposite;
import com.e1c.langtool.internal.flags.ui.Messages;
import com.e1c.langtool.platform.ITranslatingProject;
import com.e1c.langtool.platform.ITranslatingProjectManager;
import com.e1c.langtool.platform.TranslateLanguage;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class FlagsPropertyPage
extends PropertyPage {
    @Inject
    private ITranslatingProjectManager projectManager;
    private LanguageDefaultFlagsComposite languageDefaultFlags;

    protected IPreferenceStore doGetPreferenceStore() {
        return FlagsPlugin.getDefault().getPreferenceStore((IProject)this.getElement());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 300).applyTo((Control)composite);
        IProject project = (IProject)this.getElement();
        Label description = new Label(composite, 0);
        description.setText(MessageFormat.format(Messages.FlagsPropertyPage_Language_default_country_flags_for_the_project, project.getName()));
        this.languageDefaultFlags = new LanguageDefaultFlagsComposite(composite, this.getPreferenceStore());
        HashSet languageCodes = Sets.newHashSet();
        ITranslatingProject translating = this.projectManager.getProject(project);
        for (TranslateLanguage language : translating.getInterfaceLanguages()) {
            languageCodes.add(language.getLanguageCode());
        }
        this.languageDefaultFlags.loadLanguageCodes(languageCodes);
        return composite;
    }

    protected Point doComputeSize() {
        if (this.languageDefaultFlags != null) {
            Point bodySize = this.languageDefaultFlags.computeSize(-1, -1, true);
            GridData gd = (GridData)this.languageDefaultFlags.getLayoutData();
            gd.widthHint = bodySize.x;
        }
        return super.doComputeSize();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.languageDefaultFlags.performDefaults();
    }

    public boolean performOk() {
        return this.languageDefaultFlags.performOk();
    }
}

