/*
 * Decompiled with CFR 0.152.
 */
package com.e1c.langtool.internal.flags.ui;

import com.e1c.langtool.common.StringUtils;
import com.e1c.langtool.flags.ui.SharedImages;
import com.e1c.langtool.internal.flags.ui.FlagsPlugin;
import com.e1c.langtool.internal.flags.ui.Messages;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class LanguageDefaultFlagsComposite
extends Composite {
    private final IPreferenceStore prefs;
    private TableViewer viewer;
    private Map<String, String> defaultCountries = Maps.newHashMap();
    private final String[] items;

    public LanguageDefaultFlagsComposite(Composite parent, IPreferenceStore prefs) {
        super(parent, 0);
        this.prefs = prefs;
        this.items = new String[SharedImages.getCountryCodes().size() + 1];
        this.items[0] = "";
        System.arraycopy(SharedImages.getCountryCodes().toArray(), 0, this.items, 1, SharedImages.getCountryCodes().size());
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        Font font = parent.getFont();
        this.viewer = new TableViewer(parent, 68354);
        this.createViewerColumns();
        this.viewer.setLabelProvider((IBaseLabelProvider)new MapEntryLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new MapEntryContenPorovider());
        Table table = this.viewer.getTable();
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 200).applyTo((Control)table);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)new MapKeyComparator());
        this.viewer.setInput(this.defaultCountries);
    }

    public void loadLanguageCodes(Collection<String> languageCodes) {
        this.viewer.getTable().setRedraw(false);
        for (String languageCode : languageCodes) {
            Locale locale;
            String countryCode = this.prefs.getString(languageCode);
            if (StringUtils.isBlank((String)countryCode) && StringUtils.isNotEmpty((String)(countryCode = (locale = Locale.forLanguageTag(languageCode.replace("_", "-"))).getCountry()))) {
                this.prefs.setDefault(languageCode, countryCode);
            }
            this.defaultCountries.put(languageCode, countryCode);
        }
        this.viewer.refresh();
        this.viewer.getTable().setRedraw(true);
    }

    public void performDefaults() {
        this.viewer.getTable().setRedraw(false);
        for (Map.Entry<String, String> entry : this.defaultCountries.entrySet()) {
            entry.setValue(this.prefs.getDefaultString(entry.getKey()));
        }
        this.viewer.refresh();
        this.viewer.getTable().setRedraw(true);
    }

    public boolean performOk() {
        for (Map.Entry<String, String> entry : this.defaultCountries.entrySet()) {
            this.prefs.setValue(entry.getKey(), entry.getValue());
        }
        if (this.prefs.needsSaving() && this.prefs instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)this.prefs).save();
            }
            catch (IOException e) {
                FlagsPlugin.logError(e);
                return false;
            }
        }
        return true;
    }

    protected void createViewerColumns() {
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.LanguageDefaultFlagsComposite_Language_code);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(true);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.LanguageDefaultFlagsComposite_Country_flag);
        column.getColumn().setResizable(true);
        column.getColumn().setWidth(100);
        column.getColumn().setMoveable(true);
        column.setEditingSupport((EditingSupport)new CountryCodeEditingSupport());
    }

    private class CountryCodeEditingSupport
    extends EditingSupport {
        private final ComboBoxCellEditor cellEditor;

        private CountryCodeEditingSupport() {
            super((ColumnViewer)LanguageDefaultFlagsComposite.this.viewer);
            this.cellEditor = new ComboBoxCellEditor((Composite)LanguageDefaultFlagsComposite.this.viewer.getTable(), LanguageDefaultFlagsComposite.this.items, 8);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof Map.Entry && ((Map.Entry)element).getValue() instanceof String;
        }

        protected Object getValue(Object element) {
            String textValue;
            int index = 0;
            if (element instanceof Map.Entry && ((Map.Entry)element).getValue() instanceof String && !StringUtils.isBlank((String)(textValue = (String)((Map.Entry)element).getValue()))) {
                int i = 0;
                while (i < LanguageDefaultFlagsComposite.this.items.length) {
                    if (LanguageDefaultFlagsComposite.this.items[i].equals(textValue)) {
                        return i;
                    }
                    ++i;
                }
            }
            return index;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof Map.Entry && ((Map.Entry)element).getValue() instanceof String && value instanceof Integer && LanguageDefaultFlagsComposite.this.items.length > (Integer)value) {
                ((Map.Entry)element).setValue(LanguageDefaultFlagsComposite.this.items[(Integer)value]);
                LanguageDefaultFlagsComposite.this.viewer.refresh(element);
            }
        }
    }

    private class MapEntryContenPorovider
    implements IStructuredContentProvider {
        private MapEntryContenPorovider() {
        }

        public Object[] getElements(Object inputElement) {
            return LanguageDefaultFlagsComposite.this.defaultCountries.entrySet().toArray();
        }
    }

    private class MapEntryLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private MapEntryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image result = null;
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                if (columnIndex == 1 && StringUtils.isNotEmpty((String)((String)entry.getValue()))) {
                    result = SharedImages.getCountryFlagImage((String)entry.getValue());
                } else if (columnIndex == 1 && StringUtils.isNullOrEmpty((String)((String)entry.getValue()))) {
                    result = SharedImages.getImage("com.e1c.langtool.flags.ui/obj16/default.png");
                }
            }
            return result;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                result = columnIndex == 0 ? (String)entry.getKey() : (String)entry.getValue();
            }
            return result != null ? result : "";
        }
    }

    private class MapKeyComparator
    extends ViewerComparator {
        private MapKeyComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Map.Entry && e2 instanceof Map.Entry) {
                String name1 = (String)((Map.Entry)e1).getKey();
                String name2 = (String)((Map.Entry)e2).getKey();
                return this.getComparator().compare(name1, name2);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

